/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.Field;
import io.ballerina.types.definition.MappingDefinition;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.types.RecordType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BRecordType
extends BStructureType
implements RecordType {
    private static final String SPACE = " ";
    private static final String RECORD = "record";
    private static final String CLOSE_LEFT = "{|";
    private static final String SEMI = ";";
    private static final String CLOSE_RIGHT = "|}";
    private static final String REST = "...";
    public static final String OPTIONAL = "?";
    public static final String EMPTY = "";
    public static final String READONLY = "readonly";
    public boolean sealed;
    public BType restFieldType;
    public BRecordType mutableType;
    private final Env env;
    private MappingDefinition md = null;

    public BRecordType(Env env, BTypeSymbol tSymbol) {
        super(12, tSymbol);
        this.env = env;
    }

    public BRecordType(Env env, BTypeSymbol tSymbol, long flags) {
        super(12, tSymbol, flags);
        this.env = env;
    }

    protected void restMd() {
        this.md = null;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.RECORD;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.shouldPrintShape()) {
            StringBuilder sb = new StringBuilder();
            sb.append(RECORD).append(SPACE).append(CLOSE_LEFT);
            for (BField field : this.fields.values()) {
                BType type;
                sb.append(SPACE);
                if (Symbols.isFlagOn(field.symbol.flags, 32L)) {
                    sb.append(READONLY).append(SPACE);
                }
                if ((type = field.type) == this) {
                    sb.append(REST);
                } else {
                    sb.append(type);
                }
                sb.append(SPACE).append(field.name).append(Symbols.isOptional(field.symbol) ? OPTIONAL : EMPTY).append(SEMI);
            }
            if (this.sealed) {
                sb.append(SPACE).append(CLOSE_RIGHT);
                return !Symbols.isFlagOn(this.getFlags(), 32L) ? sb.toString() : sb.toString().concat(" & readonly");
            }
            sb.append(SPACE).append(this.restFieldType).append(REST).append(SEMI).append(SPACE).append(CLOSE_RIGHT);
            return !Symbols.isFlagOn(this.getFlags(), 32L) ? sb.toString() : sb.toString().concat(" & readonly");
        }
        return this.tsymbol.toString();
    }

    private boolean hasTypeHoles() {
        if (this.fields != null) {
            for (BField member : this.fields.values()) {
                if (!(member.type instanceof BNoType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetSemType() {
        this.md = null;
    }

    @Override
    public SemType semType() {
        if (this.md != null) {
            return this.md.getSemType(this.env);
        }
        this.md = new MappingDefinition();
        if (this.hasTypeHoles()) {
            return this.md.defineMappingTypeWrapped(this.env, List.of(), (SemType)PredefinedType.VAL);
        }
        Object restFieldSemType = this.restFieldType == null || this.restFieldType instanceof BNoType || this.restFieldType.semType() == null ? PredefinedType.NEVER : this.restFieldType.semType();
        ArrayList<Field> semFields = new ArrayList<Field>(this.fields.size());
        for (BField field : this.fields.values()) {
            boolean optional = Symbols.isOptional(field.symbol);
            BType bType = field.type;
            SemType ty = bType.semType();
            if (ty == null || PredefinedType.NEVER.equals((Object)ty)) {
                if (!optional) {
                    this.md.setSemTypeToNever();
                    return PredefinedType.NEVER;
                }
                if (Core.isNever((SemType)restFieldSemType)) continue;
            }
            Field semField = Field.from((String)field.name.value, (SemType)ty, (boolean)Symbols.isFlagOn(field.symbol.flags, 32L), (boolean)optional);
            semFields.add(semField);
        }
        boolean isReadonly = Symbols.isFlagOn(this.getFlags(), 32L);
        CellAtomicType.CellMutability mut = isReadonly ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        return this.md.defineMappingTypeWrapped(this.env, semFields, (SemType)restFieldSemType, mut);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void setFlags(long flags) {
        super.setFlags(flags);
        this.restMd();
    }

    @Override
    public void addFlags(long flags) {
        super.addFlags(flags);
        this.restMd();
    }
}

