/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.StreamDefinition;
import org.ballerinalang.model.types.StreamType;
import org.ballerinalang.model.types.Type;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BStreamType
extends BType
implements StreamType {
    public BType constraint;
    public BType completionType;
    private final Env env;
    private StreamDefinition d = null;

    public BStreamType(Env env, int tag, BType constraint, BType completionType, BTypeSymbol tsymbol) {
        super(tag, tsymbol);
        this.constraint = constraint;
        this.completionType = completionType != null ? completionType : BType.createNilType();
        this.env = env;
    }

    @Override
    public BType getConstraint() {
        return this.constraint;
    }

    @Override
    public Type getCompletionType() {
        return this.completionType;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.STREAM;
    }

    @Override
    public String toString() {
        if (this.constraint.tag == 18) {
            return super.toString();
        }
        return super.toString() + "<" + String.valueOf(this.constraint) + (String)(this.completionType.tag == 10 ? ">" : "," + String.valueOf(this.completionType) + ">");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void resetSemType() {
        this.d = null;
    }

    @Override
    public SemType semType() {
        if (this.constraint == null || this.constraint instanceof BNoType) {
            return PredefinedType.STREAM;
        }
        if (this.d != null) {
            return this.d.getSemType(this.env);
        }
        this.d = new StreamDefinition();
        return this.d.define(this.env, this.constraint.semType(), this.completionType.semType());
    }
}

