/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Context;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.types.TableType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BTableType
extends BType
implements TableType {
    public BType constraint;
    public BType keyTypeConstraint;
    public List<String> fieldNameList = new ArrayList<String>();
    public Location keyPos;
    public boolean isTypeInlineDefined;
    public Location constraintPos;
    public BTableType mutableType;
    private final Env env;

    public BTableType(Env env, BType constraint, BTypeSymbol tSymbol) {
        super(9, tSymbol);
        this.constraint = constraint;
        this.env = env;
    }

    public BTableType(Env env, BType constraint, BTypeSymbol tSymbol, long flags) {
        super(9, tSymbol, flags);
        this.constraint = constraint;
        this.env = env;
    }

    public BType getConstraint() {
        return this.constraint;
    }

    public void setConstraint(BType constraint) {
        this.constraint = constraint;
        this.semType = null;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        Object stringRep;
        boolean readonly = Symbols.isFlagOn(this.getFlags(), 32L);
        if (this.constraint == null) {
            return readonly ? super.toString().concat(" & readonly") : super.toString();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        if (!this.fieldNameList.isEmpty()) {
            for (String fieldName : this.fieldNameList) {
                if (!keyStringBuilder.toString().isEmpty()) {
                    keyStringBuilder.append(", ");
                }
                keyStringBuilder.append(fieldName);
            }
            stringRep = super.toString() + "<" + String.valueOf(this.constraint) + "> key(" + keyStringBuilder.toString() + ")";
        } else {
            stringRep = (super.toString() + "<" + String.valueOf(this.constraint) + "> " + (String)(this.keyTypeConstraint != null ? "key<" + String.valueOf(this.keyTypeConstraint) + ">" : "")).trim();
        }
        return readonly ? ((String)stringRep).concat(" & readonly") : stringRep;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TABLE;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SemType semType() {
        if (this.semType != null) {
            return this.semType;
        }
        SemType s = this.semTypeInner();
        boolean readonly = Symbols.isFlagOn(this.getFlags(), 32L);
        this.semType = readonly ? SemTypes.intersect((SemType)PredefinedType.VAL_READONLY, (SemType)s) : s;
        return this.semType;
    }

    private SemType semTypeInner() {
        SemType semType;
        BType constraintType = Types.getReferredType(this.constraint);
        if (constraintType.tag == 9 || constraintType.tag == 28) {
            return PredefinedType.TABLE;
        }
        if (constraintType instanceof BIntersectionType) {
            BIntersectionType intersectionType = (BIntersectionType)constraintType;
            for (BType memberType : intersectionType.getConstituentTypes()) {
                if (Types.getReferredType((BType)memberType).tag != 9) continue;
                return PredefinedType.TABLE;
            }
        }
        if (constraintType instanceof BParameterizedType) {
            BParameterizedType p = (BParameterizedType)constraintType;
            semType = p.paramValueType.semType();
        } else {
            semType = constraintType.semType();
        }
        SemType tableConstraint = semType;
        tableConstraint = SemTypes.intersect((SemType)tableConstraint, (SemType)PredefinedType.MAPPING);
        Context cx = Context.from((Env)this.env);
        String[] fieldNames = (String[])this.fieldNameList.toArray(String[]::new);
        if (!this.fieldNameList.isEmpty()) {
            return SemTypes.tableContainingKeySpecifier((Context)cx, (SemType)tableConstraint, (String[])fieldNames);
        }
        BType keyConstraintType = Types.getReferredType(this.keyTypeConstraint);
        if (this.keyTypeConstraint != null && keyConstraintType.tag != 50 && this.keyTypeConstraint.tag != 28) {
            SemType keyConstraint = this.keyTypeConstraint.semType();
            return SemTypes.tableContainingKeyConstraint((Context)cx, (SemType)tableConstraint, (SemType)keyConstraint);
        }
        return SemTypes.tableContaining((Env)this.env, (SemType)tableConstraint);
    }
}

