/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.types.UnionType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Names;

public class BUnionType
extends BType
implements UnionType {
    public boolean resolvingToString = false;
    private String cachedToString;
    protected LinkedHashSet<BType> memberTypes;
    public boolean isCyclic = false;
    private LinkedHashSet<BType> originalMemberTypes;
    private static final String INT_CLONEABLE = "__Cloneable";
    private static final String CLONEABLE = "Cloneable";
    private static final String CLONEABLE_TYPE = "CloneableType";
    private static final Pattern pCloneable = Pattern.compile("__Cloneable");
    private static final Pattern pCloneableType = Pattern.compile("CloneableType");
    public final Env env;

    public BUnionType(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> memberTypes, boolean readonly) {
        this(env, tsymbol, memberTypes, memberTypes, readonly, false);
    }

    private BUnionType(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> originalMemberTypes, LinkedHashSet<BType> memberTypes, boolean readonly) {
        this(env, tsymbol, originalMemberTypes, memberTypes, readonly, false);
    }

    private BUnionType(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> memberTypes, boolean readonly, boolean isCyclic) {
        this(env, tsymbol, null, memberTypes, readonly, isCyclic);
    }

    private BUnionType(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> originalMemberTypes, LinkedHashSet<BType> memberTypes, boolean readonly, boolean isCyclic) {
        super(21, tsymbol);
        if (readonly) {
            this.addFlags(32L);
            if (tsymbol != null) {
                this.tsymbol.flags |= 0x20L;
            }
        }
        this.originalMemberTypes = originalMemberTypes;
        this.memberTypes = memberTypes;
        this.isCyclic = isCyclic;
        this.env = env;
    }

    public LinkedHashSet<BType> getMemberTypes() {
        return this.memberTypes;
    }

    public LinkedHashSet<BType> getOriginalMemberTypes() {
        return this.originalMemberTypes;
    }

    public void setMemberTypes(LinkedHashSet<BType> memberTypes) {
        assert (memberTypes.isEmpty());
        this.memberTypes = memberTypes;
        this.originalMemberTypes = new LinkedHashSet<BType>(memberTypes);
    }

    public void setOriginalMemberTypes(LinkedHashSet<BType> memberTypes) {
        this.originalMemberTypes = new LinkedHashSet<BType>(memberTypes);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.UNION;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.resolvingToString) {
            return "...";
        }
        this.resolvingToString = true;
        this.computeStringRepresentation();
        this.resolvingToString = false;
        return this.cachedToString;
    }

    public static BUnionType create(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> types, boolean isCyclic) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>(types.size());
        boolean isImmutable = true;
        return new BUnionType(env, tsymbol, memberTypes, isImmutable, isCyclic);
    }

    public static BUnionType create(Env env, BTypeSymbol tsymbol, LinkedHashSet<BType> types) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>(types.size());
        if (types.isEmpty()) {
            return new BUnionType(env, tsymbol, memberTypes, true);
        }
        boolean isImmutable = true;
        for (BType memBType : BUnionType.toFlatTypeSet(types)) {
            if (!BUnionType.isNeverType(memBType)) {
                memberTypes.add(memBType);
            }
            if (!isImmutable || Symbols.isFlagOn(memBType.getFlags(), 32L)) continue;
            isImmutable = false;
        }
        if (memberTypes.isEmpty()) {
            memberTypes.add(BType.createNeverType());
            return new BUnionType(env, tsymbol, memberTypes, isImmutable);
        }
        return new BUnionType(env, tsymbol, types, memberTypes, isImmutable);
    }

    public static BUnionType create(Env env, BTypeSymbol tsymbol, BType ... types) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>(types.length);
        memberTypes.addAll(Arrays.asList(types));
        return BUnionType.create(env, tsymbol, memberTypes);
    }

    public void add(BType type) {
        if (type.tag == 21 && !BUnionType.isTypeParamAvailable(type)) {
            assert (type instanceof BUnionType);
            BUnionType addUnion = (BUnionType)type;
            if (addUnion.isCyclic) {
                this.mergeUnionType(addUnion);
            } else {
                this.originalMemberTypes.add(addUnion);
                this.memberTypes.addAll(BUnionType.toFlatTypeSet(addUnion.memberTypes));
            }
        } else {
            this.originalMemberTypes.add(type);
            this.memberTypes.add(type);
        }
        if (Symbols.isFlagOn(this.getFlags(), 32L) && !Symbols.isFlagOn(type.getFlags(), 32L)) {
            this.setFlags(this.getFlags() ^ 0x20L);
        }
        this.setCyclicFlag(type);
        this.semType = null;
    }

    private void setCyclicFlag(BType type) {
        if (this.isCyclic) {
            return;
        }
        if (type instanceof BArrayType) {
            BArrayType arrayType = (BArrayType)type;
            if (arrayType.eType == this) {
                this.isCyclic = true;
            }
        }
        if (type instanceof BMapType) {
            BMapType mapType = (BMapType)type;
            if (mapType.constraint == this) {
                this.isCyclic = true;
            }
        }
        if (type instanceof BTableType) {
            BType bType;
            BTableType tableType = (BTableType)type;
            if (tableType.constraint == this) {
                this.isCyclic = true;
            }
            if ((bType = tableType.constraint) instanceof BMapType) {
                BMapType mapType = (BMapType)bType;
                if (mapType.constraint == this) {
                    this.isCyclic = true;
                }
            }
        }
    }

    public void addAll(Set<BType> types) {
        types.forEach(this::add);
    }

    public void remove(BType type) {
        if (type.tag == 21) {
            assert (type instanceof BUnionType);
            this.memberTypes.removeAll(((BUnionType)type).getMemberTypes());
        } else {
            this.memberTypes.remove(type);
        }
        this.originalMemberTypes.remove(type);
        if (Symbols.isFlagOn(this.getFlags(), 32L)) {
            return;
        }
        boolean isImmutable = true;
        for (BType memBType : this.memberTypes) {
            if (Symbols.isFlagOn(memBType.getFlags(), 32L)) continue;
            isImmutable = false;
            break;
        }
        if (isImmutable) {
            this.addFlags(32L);
        }
    }

    public void mergeUnionType(BUnionType unionType) {
        if (!unionType.isCyclic) {
            for (BType member : unionType.getMemberTypes()) {
                this.add(member);
            }
            return;
        }
        this.isCyclic = true;
        for (BType member : unionType.getMemberTypes()) {
            if (member instanceof BArrayType) {
                BArrayType arrayType = (BArrayType)member;
                if (BUnionType.getImpliedType(arrayType.eType) == unionType) {
                    BArrayType newArrayType = new BArrayType(this.env, this, arrayType.tsymbol, arrayType.getSize(), arrayType.state, arrayType.getFlags());
                    this.add(newArrayType);
                    continue;
                }
            } else if (member instanceof BMapType) {
                BMapType mapType = (BMapType)member;
                if (BUnionType.getImpliedType(mapType.constraint) == unionType) {
                    BMapType newMapType = new BMapType(this.env, mapType.tag, this, mapType.tsymbol, mapType.getFlags());
                    this.add(newMapType);
                    continue;
                }
            } else if (member instanceof BTableType) {
                BType newTableType;
                BTableType tableType = (BTableType)member;
                if (BUnionType.getImpliedType(tableType.constraint) == unionType) {
                    newTableType = new BTableType(this.env, this, tableType.tsymbol, tableType.getFlags());
                    this.add(newTableType);
                    continue;
                }
                newTableType = tableType.constraint;
                if (newTableType instanceof BMapType) {
                    BMapType mapType = (BMapType)newTableType;
                    if (BUnionType.getImpliedType(mapType.constraint) == unionType) {
                        BMapType newMapType = new BMapType(this.env, mapType.tag, this, mapType.tsymbol, mapType.getFlags());
                        BTableType newTableType2 = new BTableType(this.env, newMapType, tableType.tsymbol, tableType.getFlags());
                        this.add(newTableType2);
                        continue;
                    }
                }
            }
            this.add(member);
        }
    }

    public Iterator<BType> iterator() {
        return this.memberTypes.iterator();
    }

    public static LinkedHashSet<BType> toFlatTypeSet(LinkedHashSet<BType> types) {
        return types.stream().flatMap(type -> {
            BType refType = BUnionType.getImpliedType(type);
            if (refType.tag == 21 && !BUnionType.isTypeParamAvailable(type)) {
                return ((BUnionType)refType).memberTypes.stream();
            }
            return Stream.of(type);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static BType getImpliedType(BType type) {
        if ((type = BUnionType.getReferredType(type)) != null && type.tag == 22) {
            return BUnionType.getImpliedType(((BIntersectionType)type).effectiveType);
        }
        return type;
    }

    private static BType getReferredType(BType type) {
        if (type != null && type.tag == 14) {
            return BUnionType.getReferredType(((BTypeReferenceType)type).referredType);
        }
        return type;
    }

    private static boolean isTypeParamAvailable(BType type) {
        return type.tsymbol != null && Symbols.isFlagOn(type.tsymbol.flags, 0x200000L);
    }

    private String getQualifiedName(String pkg, String name) {
        return pkg.isBlank() || pkg.equals(".") ? name : pkg + ":" + name;
    }

    private void computeStringRepresentation() {
        if (this.cachedToString != null) {
            return;
        }
        if (this.tsymbol != null && !this.tsymbol.getName().getValue().isEmpty()) {
            String typeName = this.tsymbol.getName().getValue();
            String packageId = this.tsymbol.pkgID.toString();
            boolean isTypeParam = Symbols.isFlagOn(this.getFlags(), 0x200000L);
            if (this.isCyclic && (pCloneable.matcher(typeName).matches() || isTypeParam && pCloneableType.matcher(typeName).matches())) {
                this.cachedToString = this.getQualifiedName(packageId, CLONEABLE);
                return;
            }
            if (!isTypeParam) {
                this.cachedToString = this.getQualifiedName(packageId, typeName);
                return;
            }
        }
        LinkedHashSet<BType> uniqueTypes = new LinkedHashSet<BType>(this.originalMemberTypes.size());
        for (BType bType : this.originalMemberTypes) {
            if (bType.tag != 21) {
                uniqueTypes.add(bType);
                continue;
            }
            BTypeSymbol tsymbol = bType.tsymbol;
            if (tsymbol != null && !tsymbol.getName().getValue().isEmpty()) {
                uniqueTypes.add(bType);
                continue;
            }
            uniqueTypes.addAll(((BUnionType)bType).originalMemberTypes);
        }
        StringJoiner joiner = new StringJoiner(this.getKind().typeName());
        boolean hasNilableMember = false;
        long numberOfNotNilTypes = 0L;
        for (BType bType : uniqueTypes) {
            if (bType.tag == 10) continue;
            String memToString = bType.toString();
            if (bType.tag == 21 && memToString.startsWith("(") && memToString.endsWith(")")) {
                joiner.add(memToString.substring(1, memToString.length() - 1));
            } else {
                joiner.add(memToString);
            }
            ++numberOfNotNilTypes;
            if (hasNilableMember || !bType.isNullable()) continue;
            hasNilableMember = true;
        }
        Object typeStr = numberOfNotNilTypes > 1L ? "(" + String.valueOf(joiner) + ")" : joiner.toString();
        boolean hasNilType = (long)uniqueTypes.size() > numberOfNotNilTypes;
        this.cachedToString = this.isNullable() && hasNilType && !hasNilableMember ? (String)typeStr + Names.QUESTION_MARK.value : typeStr;
    }

    private static boolean isNeverType(BType type) {
        if (type.tag == 50) {
            return true;
        }
        if (type.tag == 14) {
            return BUnionType.isNeverType(BUnionType.getImpliedType(type));
        }
        if (type.tag == 21) {
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                if (BUnionType.isNeverType(memberType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetSemType() {
        this.semType = null;
    }

    @Override
    public SemType semType() {
        if (this.semType == null) {
            this.semType = this.computeSemTypeFromMemberTypes();
        }
        return this.semType;
    }

    private SemType computeSemTypeFromMemberTypes() {
        BasicTypeBitSet t = PredefinedType.NEVER;
        for (BType ty : this.memberTypes) {
            t = SemTypes.union((SemType)t, (SemType)ty.semType());
        }
        return t;
    }
}

