/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ClassDefinition;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.MarkdownDocumentationNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.VariableNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangClassDefinition
extends BLangNode
implements ClassDefinition {
    public BLangIdentifier name;
    public List<BLangAnnotationAttachment> annAttachments;
    public BLangMarkdownDocumentation markdownDocumentationAttachment;
    public BLangFunction initFunction;
    public List<BLangFunction> functions = new ArrayList<BLangFunction>();
    public List<BLangSimpleVariable> fields;
    public List<BLangType> typeRefs = new ArrayList<BLangType>();
    public Set<Flag> flagSet;
    public boolean isServiceDecl;
    public BTypeSymbol symbol;
    public BLangFunction generatedInitFunction;
    public BLangSimpleVariable receiver;
    public List<BLangSimpleVariable> referencedFields;
    public List<BLangSimpleVarRef.BLangLocalVarRef> localVarRefs;
    public int precedence;
    public boolean definitionCompleted;
    public OCEDynamicEnvironmentData oceEnvData;
    public boolean isObjectContructorDecl = false;
    public BObjectType objectType = null;
    public boolean hasClosureVars;
    public SymbolEnv typeDefEnv;
    public int cycleDepth = -1;

    public BLangClassDefinition() {
        this.fields = new ArrayList<BLangSimpleVariable>();
        this.flagSet = EnumSet.noneOf(Flag.class);
        this.flagSet.add(Flag.CLASS);
        this.annAttachments = new ArrayList<BLangAnnotationAttachment>();
        this.referencedFields = new ArrayList<BLangSimpleVariable>();
        this.oceEnvData = new OCEDynamicEnvironmentData();
    }

    @Override
    public IdentifierNode getName() {
        return this.name;
    }

    @Override
    public void setName(IdentifierNode name) {
        this.name = (BLangIdentifier)name;
    }

    @Override
    public List<BLangFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public void addFunction(FunctionNode function) {
        this.functions.add((BLangFunction)function);
    }

    @Override
    public FunctionNode getInitFunction() {
        return this.initFunction;
    }

    @Override
    public void addField(VariableNode field) {
        this.fields.add((BLangSimpleVariable)field);
    }

    @Override
    public void addTypeReference(TypeNode typeRef) {
        this.typeRefs.add((BLangType)typeRef);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.CLASS_DEFN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("class ").append(this.name.value).append(" { ");
        for (BLangType typeRef : this.typeRefs) {
            sb.append("*").append(typeRef.toString()).append(";\n");
        }
        for (BLangSimpleVariable field : this.fields) {
            sb.append(field.toString()).append(";\n");
        }
        for (BLangFunction function : this.functions) {
            sb.append(function.toString()).append("\n");
        }
        return sb.append(" }").toString();
    }

    @Override
    public Set<? extends Flag> getFlags() {
        return this.flagSet;
    }

    @Override
    public void addFlag(Flag flag) {
        this.flagSet.add(flag);
    }

    public List<BLangAnnotationAttachment> getAnnotationAttachments() {
        return this.annAttachments;
    }

    @Override
    public void addAnnotationAttachment(AnnotationAttachmentNode annAttachment) {
        this.annAttachments.add((BLangAnnotationAttachment)annAttachment);
    }

    @Override
    public BLangMarkdownDocumentation getMarkdownDocumentationAttachment() {
        return this.markdownDocumentationAttachment;
    }

    @Override
    public void setMarkdownDocumentationAttachment(MarkdownDocumentationNode documentationNode) {
        this.markdownDocumentationAttachment = (BLangMarkdownDocumentation)documentationNode;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }
}

