/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.MarkdownDocumentationNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;

public class BLangMarkdownDocumentation
extends BLangNode
implements MarkdownDocumentationNode {
    public LinkedList<BLangMarkdownDocumentationLine> documentationLines = new LinkedList();
    public LinkedList<BLangMarkdownParameterDocumentation> parameters = new LinkedList();
    public LinkedList<BLangMarkdownReferenceDocumentation> references = new LinkedList();
    public BLangMarkdownReturnParameterDocumentation returnParameter;
    public BLangMarkDownDeprecationDocumentation deprecationDocumentation;
    public BLangMarkDownDeprecatedParametersDocumentation deprecatedParametersDocumentation;

    @Override
    public LinkedList<BLangMarkdownDocumentationLine> getDocumentationLines() {
        return this.documentationLines;
    }

    @Override
    public void addDocumentationLine(BLangMarkdownDocumentationLine description) {
        this.documentationLines.add(description);
    }

    @Override
    public LinkedList<BLangMarkdownParameterDocumentation> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParameter(BLangMarkdownParameterDocumentation parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public BLangMarkdownReturnParameterDocumentation getReturnParameter() {
        return this.returnParameter;
    }

    @Override
    public BLangMarkDownDeprecationDocumentation getDeprecationDocumentation() {
        return this.deprecationDocumentation;
    }

    @Override
    public void setReturnParameter(BLangMarkdownReturnParameterDocumentation returnParameter) {
        this.returnParameter = returnParameter;
    }

    @Override
    public void setDeprecationDocumentation(BLangMarkDownDeprecationDocumentation deprecationDocumentation) {
        this.deprecationDocumentation = deprecationDocumentation;
    }

    @Override
    public void setDeprecatedParametersDocumentation(BLangMarkDownDeprecatedParametersDocumentation deprecatedParametersDocumentation) {
        this.deprecatedParametersDocumentation = deprecatedParametersDocumentation;
    }

    @Override
    public BLangMarkDownDeprecatedParametersDocumentation getDeprecatedParametersDocumentation() {
        return this.deprecatedParametersDocumentation;
    }

    @Override
    public String getDocumentation() {
        return this.documentationLines.stream().map(BLangMarkdownDocumentationLine::getText).collect(Collectors.joining("\n")).replace("\r", "");
    }

    @Override
    public Map<String, BLangMarkdownParameterDocumentation> getParameterDocumentations() {
        HashMap<String, BLangMarkdownParameterDocumentation> parameterDocumentations = new HashMap<String, BLangMarkdownParameterDocumentation>();
        this.parameters.forEach(p -> parameterDocumentations.put(p.getParameterName().getValue(), (BLangMarkdownParameterDocumentation)p));
        return parameterDocumentations;
    }

    @Override
    public String getReturnParameterDocumentation() {
        return this.returnParameter == null ? null : this.returnParameter.getReturnParameterDocumentation();
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.MARKDOWN_DOCUMENTATION;
    }

    public String toString() {
        return "BLangMarkdownDocumentation: " + String.valueOf(this.documentationLines) + " " + String.valueOf(this.references) + " " + String.valueOf(this.parameters) + " " + String.valueOf(this.returnParameter == null ? "" : this.returnParameter);
    }

    public LinkedList<BLangMarkdownReferenceDocumentation> getReferences() {
        return this.references;
    }

    @Override
    public void addReference(BLangMarkdownReferenceDocumentation reference) {
        if (reference != null) {
            this.references.add(reference);
        }
    }
}

