/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangObjectConstructorExpression
extends BLangExpression {
    public BLangClassDefinition classNode;
    public BLangTypeInit typeInit;
    public BLangType referenceType;
    public boolean isClient = false;
    public boolean isService = false;
    public boolean defined;
    public List<BLangLambdaFunction> langLambdaFunctionList;

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.OBJECT_CTOR_EXPRESSION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.isClient) {
            sb.append("client ");
        }
        if (this.isService) {
            sb.append("service ");
        }
        sb.append("object ");
        if (this.referenceType != null && this.referenceType.getBType().name != null) {
            sb.append(this.referenceType.getBType().name.getValue());
        }
        sb.append(" {");
        sb.append(this.classNode.toString());
        sb.append("};\n");
        return sb.toString();
    }

    public void addTypeReference(TypeNode type) {
        if (this.referenceType == null) {
            this.referenceType = (BLangType)type;
            this.classNode.addTypeReference(type);
            return;
        }
        throw new RuntimeException("object-constructor-expr can only have one type-reference");
    }
}

