/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.WaitForAllExpressionNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BLangWaitForAllExpr
extends BLangExpression
implements WaitForAllExpressionNode {
    private static final String WAIT_KEYWORD = "wait";
    public List<BLangWaitKeyValue> keyValuePairs = new ArrayList<BLangWaitKeyValue>();

    @Override
    public List<BLangWaitKeyValue> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.WAIT_EXPR;
    }

    public String toString() {
        return "wait {" + String.join((CharSequence)",", this.keyValPairs()) + "}";
    }

    private List<String> keyValPairs() {
        ArrayList<String> keyValList = new ArrayList<String>();
        for (BLangWaitKeyValue keyVal : this.keyValuePairs) {
            if (keyVal.valueExpr != null) {
                keyValList.add(keyVal.key.value + ":" + keyVal.valueExpr.toString());
                continue;
            }
            keyValList.add(keyVal.key.value);
        }
        return keyValList;
    }

    public static class BLangWaitKeyValue
    extends BLangNode
    implements WaitForAllExpressionNode.WaitKeyValueNode {
        public BLangIdentifier key;
        public BLangExpression valueExpr;
        public BLangExpression keyExpr;
        public BVarSymbol keySymbol;

        @Override
        public BLangIdentifier getKey() {
            return this.key;
        }

        @Override
        public BLangExpression getValue() {
            return this.valueExpr;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.WAIT_LITERAL_KEY_VALUE;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }

    public static class BLangWaitLiteral
    extends BLangWaitForAllExpr {
        public BAttachedFunction initializer;

        public BLangWaitLiteral(List<BLangWaitKeyValue> keyValuePairs, BType structType) {
            this.keyValuePairs = keyValuePairs;
            this.setBType(structType);
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

