/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;

public class BLangXMLNavigationAccess
extends BLangExpression
implements XMLNavigationAccess {
    public BLangExpression expr;
    public final List<BLangXMLElementFilter> filters;
    public final XMLNavigationAccess.NavAccessType navAccessType;

    public BLangXMLNavigationAccess(Location pos, BLangExpression expr, List<BLangXMLElementFilter> filters, XMLNavigationAccess.NavAccessType navAccessType) {
        this.pos = pos;
        this.expr = expr;
        this.filters = filters;
        this.navAccessType = navAccessType;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.XML_NAVIGATION;
    }

    @Override
    public XMLNavigationAccess.NavAccessType getNavAccessType() {
        return this.navAccessType;
    }

    @Override
    public List<BLangXMLElementFilter> getFilters() {
        return this.filters;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    public String toString() {
        StringJoiner filters = new StringJoiner(" |");
        this.filters.forEach(f -> filters.add(f.toString()));
        switch (this.navAccessType) {
            case CHILDREN: {
                return String.valueOf(this.expr) + "/*";
            }
            case CHILD_ELEMS: {
                return String.valueOf(this.expr) + "/<" + filters.toString() + ">";
            }
            case DESCENDANTS: {
                return String.valueOf(this.expr) + "/**/<" + filters.toString() + ">";
            }
        }
        return null;
    }
}

