/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import io.ballerina.tools.diagnostics.Location;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.VariableReferenceNode;
import org.ballerinalang.model.tree.statements.CompoundAssignmentNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangValueExpression;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangCompoundAssignment
extends BLangStatement
implements CompoundAssignmentNode {
    public BLangValueExpression varRef;
    public BLangExpression expr;
    public OperatorKind opKind;
    public BLangExpression modifiedExpr;

    public BLangCompoundAssignment() {
    }

    public BLangCompoundAssignment(Location pos, BLangAccessExpression varRef, BLangExpression expr) {
        this.pos = pos;
        this.varRef = varRef;
        this.expr = expr;
    }

    @Override
    public OperatorKind getOperatorKind() {
        return this.opKind;
    }

    @Override
    public BLangExpression getVariable() {
        return this.varRef;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public void setExpression(ExpressionNode expression) {
        this.expr = (BLangExpression)expression;
    }

    @Override
    public void setVariable(VariableReferenceNode variableReferenceNode) {
        this.varRef = (BLangValueExpression)((Object)variableReferenceNode);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.COMPOUND_ASSIGNMENT;
    }

    public String toString() {
        return "BLangCompoundAssignment: " + String.valueOf(this.varRef != null ? this.varRef : "") + (String)(this.expr != null ? String.valueOf((Object)this.opKind) + "=" + String.valueOf(this.expr) : "");
    }
}

