/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.TupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangTupleTypeNode
extends BLangType
implements TupleTypeNode {
    public List<BLangSimpleVariable> members = new ArrayList<BLangSimpleVariable>();
    public BLangType restParamType;

    public List<BLangSimpleVariable> getMemberNodes() {
        return this.members;
    }

    public List<BLangType> getMemberTypeNodes() {
        ArrayList<BLangType> types = new ArrayList<BLangType>();
        this.members.forEach(member -> types.add(member.typeNode));
        return types;
    }

    @Override
    public BLangType getRestParamType() {
        return this.restParamType;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TUPLE_TYPE_NODE;
    }

    public String toString() {
        return "[" + this.members.stream().map(BLangSimpleVariable::toString).collect(Collectors.joining(",")) + (String)(this.restParamType != null ? "," + this.restParamType.toString() + "...]" : "]");
    }
}

