/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public final class CompilerUtils {
    private static final String DISTRIBUTED_TRANSACTIONS = "distributed.transactions";

    private CompilerUtils() {
    }

    public static boolean isDistributedTransactionsEnabled() {
        boolean distributedTransactionEnabled = true;
        String distributedTxEnabledProp = System.getProperty(DISTRIBUTED_TRANSACTIONS);
        if (distributedTxEnabledProp != null) {
            distributedTransactionEnabled = Boolean.valueOf(distributedTxEnabledProp);
        }
        return distributedTransactionEnabled;
    }

    public static boolean isMainFunction(BLangFunction funcNode) {
        return "main".equals(funcNode.name.value) && Symbols.isPublic(funcNode.symbol);
    }

    public static boolean getBooleanValueIfSet(CompilerOptions compilerOptions, CompilerOptionName optionName) {
        return compilerOptions.isSet(optionName) && Boolean.parseBoolean(compilerOptions.get(optionName));
    }

    public static String getMajorVersion(String version) {
        return version.split("\\.")[0];
    }

    public static String getPackageIDStringWithMajorVersion(PackageID packageID) {
        if (Names.DOT.equals(packageID.name)) {
            return packageID.name.value;
        }
        Object org = "";
        if (packageID.orgName != null && !packageID.orgName.equals(Names.ANON_ORG)) {
            org = String.valueOf(packageID.orgName) + Names.ORG_NAME_SEPARATOR.value;
        }
        if (packageID.version.equals(Names.EMPTY)) {
            return (String)org + packageID.name.value;
        }
        return (String)org + String.valueOf(packageID.name) + Names.VERSION_SEPARATOR.value + CompilerUtils.getMajorVersion(packageID.version.value);
    }

    public static boolean isInParameterList(BSymbol symbol, List<BLangSimpleVariable> params) {
        for (BLangSimpleVariable param : params) {
            if (param.symbol != symbol) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignmentToOptionalField(BLangAssignment assignNode) {
        BLangExpression varRef = assignNode.varRef;
        if (varRef.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR) {
            return false;
        }
        BLangFieldBasedAccess fieldAccessNode = (BLangFieldBasedAccess)varRef;
        BType targetType = Types.getImpliedType(fieldAccessNode.expr.getBType());
        if (targetType.tag != 12) {
            return false;
        }
        BField field = (BField)((BRecordType)targetType).fields.get(fieldAccessNode.field.value);
        return field != null && Symbols.isOptional(field.symbol);
    }
}

