/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.util.Flags;

public final class ImmutableTypeCloner {
    private ImmutableTypeCloner() {
    }

    public static BType getEffectiveImmutableType(Location pos, Types types, BType type, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        return ImmutableTypeCloner.getImmutableIntersectionType((Location)pos, (Types)types, (BType)type, (SymbolEnv)env, (PackageID)env.enclPkg.packageID, (BSymbol)env.scope.owner, (SymbolTable)symTable, (BLangAnonymousModelHelper)anonymousModelHelper, (Names)names, new HashSet<Flag>(), new HashSet<BType>()).effectiveType;
    }

    public static BType getEffectiveImmutableType(Location pos, Types types, BType type, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        return ImmutableTypeCloner.getImmutableIntersectionType((Location)pos, (Types)types, (BType)type, null, (PackageID)pkgId, (BSymbol)owner, (SymbolTable)symTable, (BLangAnonymousModelHelper)anonymousModelHelper, (Names)names, new HashSet<Flag>(), new HashSet<BType>()).effectiveType;
    }

    public static BIntersectionType getImmutableIntersectionType(Location pos, Types types, BType type, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet) {
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, types, type, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, origObjFlagSet, new HashSet<BType>());
    }

    public static BIntersectionType getImmutableIntersectionType(BType type, SymbolTable symbolTable, Names names, Types types, PackageID pkgId) {
        return ImmutableTypeCloner.getImmutableIntersectionType(null, types, type, null, pkgId, null, symbolTable, null, names, null, new HashSet<BType>());
    }

    public static void markFieldsAsImmutable(BLangClassDefinition classDef, SymbolEnv pkgEnv, BObjectType objectType, Types types, BLangAnonymousModelHelper anonymousModelHelper, SymbolTable symbolTable, Names names, Location pos) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDef, objectType.tsymbol.scope, pkgEnv);
        Iterator objectTypeFieldIterator = objectType.fields.values().iterator();
        HashMap<String, BLangSimpleVariable> classFields = new HashMap<String, BLangSimpleVariable>();
        for (BLangSimpleVariable field : classDef.fields) {
            classFields.put(field.name.value, field);
        }
        for (BLangSimpleVariable field : classDef.referencedFields) {
            classFields.put(field.name.value, field);
        }
        while (objectTypeFieldIterator.hasNext()) {
            BField typeField = (BField)objectTypeFieldIterator.next();
            BLangSimpleVariable classField = (BLangSimpleVariable)classFields.get(typeField.name.value);
            BType type = typeField.type;
            if (!types.isInherentlyImmutableType(type)) {
                typeField.symbol.type = ImmutableTypeCloner.getImmutableIntersectionType(pos, types, type, typeDefEnv, symbolTable, anonymousModelHelper, names, classDef.flagSet);
                BIntersectionType immutableFieldType = typeField.symbol.type;
                typeField.type = immutableFieldType;
                classField.setBType(typeField.type);
            }
            typeField.symbol.flags |= 4L;
            classField.flagSet.add(Flag.FINAL);
        }
    }

    public static BType getImmutableType(Location pos, Types types, BType type, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes) {
        if (type == null) {
            return symTable.semanticError;
        }
        if (types.isInherentlyImmutableType(type) || Symbols.isFlagOn(type.getFlags(), 32L)) {
            return type;
        }
        if (!types.isSelectivelyImmutableType(type, unresolvedTypes, pkgId)) {
            return symTable.semanticError;
        }
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, types, type, env, pkgId, owner, symTable, anonymousModelHelper, names, new HashSet<Flag>(), unresolvedTypes);
    }

    private static BIntersectionType getImmutableIntersectionType(Location pos, Types types, BType bType, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet, Set<BType> unresolvedTypes) {
        BType refType = Types.getReferredType(bType);
        SelectivelyImmutableReferenceType type = (SelectivelyImmutableReferenceType)((Object)refType);
        if (refType.tag == 22 && Symbols.isFlagOn(refType.getFlags(), 32L)) {
            return (BIntersectionType)refType;
        }
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        return ImmutableTypeCloner.setImmutableType(pos, types, type, bType, env, pkgId, owner, symTable, anonymousModelHelper, names, origObjFlagSet, unresolvedTypes);
    }

    private static BIntersectionType setImmutableType(Location pos, Types types, SelectivelyImmutableReferenceType selectivelyImmutableRefType, BType originalType, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet, Set<BType> unresolvedTypes) {
        BType type = (BType)((Object)selectivelyImmutableRefType);
        switch (type.tag) {
            case 46: 
            case 47: 
            case 48: {
                BXMLSubType origXmlSubType = (BXMLSubType)type;
                BXMLSubType immutableXmlSubType = BXMLSubType.newImmutableXMLSubType(origXmlSubType);
                BIntersectionType immutableXmlSubTypeIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, immutableXmlSubType, symTable);
                Types.addImmutableType(symTable, pkgId, origXmlSubType, immutableXmlSubTypeIntersectionType);
                return immutableXmlSubTypeIntersectionType;
            }
            case 8: {
                return ImmutableTypeCloner.defineImmutableXMLType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BXMLType)type, originalType);
            }
            case 20: 
            case 35: {
                return ImmutableTypeCloner.defineImmutableArrayType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BArrayType)type, originalType);
            }
            case 31: {
                return ImmutableTypeCloner.defineImmutableTupleType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BTupleType)type, originalType);
            }
            case 16: {
                return ImmutableTypeCloner.defineImmutableMapType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BMapType)type, originalType);
            }
            case 12: {
                BRecordType origRecordType = (BRecordType)type;
                return ImmutableTypeCloner.defineImmutableRecordType(pos, origRecordType, originalType, env, symTable, anonymousModelHelper, names, types, unresolvedTypes);
            }
            case 34: {
                BObjectType origObjectType = (BObjectType)type;
                return ImmutableTypeCloner.defineImmutableObjectType(pos, origObjectType, originalType, env, symTable, anonymousModelHelper, names, types, origObjFlagSet, unresolvedTypes);
            }
            case 9: {
                return ImmutableTypeCloner.defineImmutableTableType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BTableType)type, originalType);
            }
            case 18: {
                BAnyType origAnyType = (BAnyType)type;
                BAnyType immutableAnyType = BAnyType.newImmutableBAnyType();
                BIntersectionType immutableAnyIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, immutableAnyType, symTable);
                Types.addImmutableType(symTable, pkgId, origAnyType, immutableAnyIntersectionType);
                return immutableAnyIntersectionType;
            }
            case 7: 
            case 11: {
                return ImmutableTypeCloner.defineImmutableBuiltInUnionType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BUnionType)type, originalType);
            }
            case 22: {
                return (BIntersectionType)type;
            }
        }
        return ImmutableTypeCloner.defineImmutableUnionType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, (BUnionType)type, originalType);
    }

    private static BIntersectionType defineImmutableTableType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BTableType type, BType originalType) {
        BTypeSymbol immutableTableTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, new BTableType(symTable.typeEnv(), null, immutableTableTSymbol, type.getFlags() | 0x20L), symTable));
        BIntersectionType immutableTableType = Types.getImmutableType(symTable, pkgId, type).orElseThrow();
        BTableType tableEffectiveImmutableType = (BTableType)immutableTableType.effectiveType;
        tableEffectiveImmutableType.constraint = ImmutableTypeCloner.getImmutableType(pos, types, type.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        BType origKeyTypeConstraint = type.keyTypeConstraint;
        if (origKeyTypeConstraint != null) {
            tableEffectiveImmutableType.keyTypeConstraint = ImmutableTypeCloner.getImmutableType(pos, types, origKeyTypeConstraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        }
        tableEffectiveImmutableType.keyPos = type.keyPos;
        tableEffectiveImmutableType.constraintPos = type.constraintPos;
        tableEffectiveImmutableType.isTypeInlineDefined = type.isTypeInlineDefined;
        tableEffectiveImmutableType.fieldNameList = type.fieldNameList;
        tableEffectiveImmutableType.mutableType = type;
        if (immutableTableTSymbol != null) {
            immutableTableTSymbol.type = tableEffectiveImmutableType;
        }
        return immutableTableType;
    }

    private static BIntersectionType defineImmutableXMLType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BXMLType type, BType originalType) {
        BTypeSymbol immutableXmlTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, new BXMLType(null, immutableXmlTSymbol, type.getFlags() | 0x20L), symTable));
        BIntersectionType immutableXMLType = Types.getImmutableType(symTable, pkgId, type).orElseThrow();
        BXMLType xmlEffectiveImmutableType = (BXMLType)immutableXMLType.effectiveType;
        xmlEffectiveImmutableType.mutableType = type;
        xmlEffectiveImmutableType.constraint = ImmutableTypeCloner.getImmutableType(pos, types, type.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        return immutableXMLType;
    }

    private static BIntersectionType defineImmutableArrayType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BArrayType type, BType originalType) {
        BTypeSymbol immutableArrayTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, new BArrayType(symTable.typeEnv(), null, immutableArrayTSymbol, type.getSize(), type.state, type.getFlags() | 0x20L), symTable));
        BIntersectionType immutableArrayType = Types.getImmutableType(symTable, pkgId, type).orElseThrow();
        BArrayType arrayEffectiveImmutableType = (BArrayType)immutableArrayType.effectiveType;
        arrayEffectiveImmutableType.mutableType = type;
        arrayEffectiveImmutableType.eType = ImmutableTypeCloner.getImmutableType(pos, types, type.eType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        return immutableArrayType;
    }

    private static BIntersectionType defineImmutableMapType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BMapType type, BType originalType) {
        BTypeSymbol immutableMapTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, new BMapType(symTable.typeEnv(), 16, null, immutableMapTSymbol, type.getFlags() | 0x20L), symTable));
        BIntersectionType immutableMapType = Types.getImmutableType(symTable, pkgId, type).orElseThrow();
        BMapType mapEffectiveImmutableType = (BMapType)immutableMapType.effectiveType;
        mapEffectiveImmutableType.mutableType = type;
        mapEffectiveImmutableType.constraint = ImmutableTypeCloner.getImmutableType(pos, types, type.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        return immutableMapType;
    }

    private static BIntersectionType defineImmutableTupleType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BTupleType type, BType originalType) {
        BTypeSymbol origTupleTypeSymbol = type.tsymbol;
        List<BTupleMember> origTupleMembers = type.getMembers();
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symTable, pkgId, type);
        if (immutableType.isPresent()) {
            return immutableType.get();
        }
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, new BTupleType(symTable.typeEnv(), origTupleTypeSymbol), symTable));
        ArrayList<BTupleMember> immutableMemTypes = new ArrayList<BTupleMember>(origTupleMembers.size());
        BTupleType tupleEffectiveImmutableType = (BTupleType)Types.getImmutableType((SymbolTable)symTable, (PackageID)pkgId, (SelectivelyImmutableReferenceType)type).get().effectiveType;
        tupleEffectiveImmutableType.mutableType = type;
        tupleEffectiveImmutableType.isCyclic = type.isCyclic;
        tupleEffectiveImmutableType.setMembers(immutableMemTypes);
        String originalTypeName = origTupleTypeSymbol == null ? "" : origTupleTypeSymbol.name.getValue();
        Name origTupleTypeSymbolName = Names.EMPTY;
        if (!originalTypeName.isEmpty()) {
            origTupleTypeSymbolName = origTupleTypeSymbol.name.value.isEmpty() ? Names.EMPTY : Types.getImmutableTypeName(ImmutableTypeCloner.getSymbolFQN(origTupleTypeSymbol));
            tupleEffectiveImmutableType.name = origTupleTypeSymbolName;
        }
        for (BTupleMember origTupleMemType : origTupleMembers) {
            if (types.isInherentlyImmutableType(origTupleMemType.type)) {
                tupleEffectiveImmutableType.addMembers(origTupleMemType);
                continue;
            }
            if (!types.isSelectivelyImmutableType(origTupleMemType.type, unresolvedTypes, pkgId)) continue;
            BType newType = ImmutableTypeCloner.getImmutableType(pos, types, origTupleMemType.type, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(newType);
            BTupleMember member = new BTupleMember(newType, varSymbol);
            tupleEffectiveImmutableType.addMembers(member);
        }
        if (type.restType != null) {
            tupleEffectiveImmutableType.addRestType(ImmutableTypeCloner.getImmutableType(pos, types, type.restType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes));
        }
        BIntersectionType immutableTupleIntersectionType = Types.getImmutableType(symTable, pkgId, type).get();
        BType effectiveTypeFromType = immutableTupleIntersectionType.effectiveType;
        if (origTupleTypeSymbol != null) {
            BTypeSymbol immutableTupleTSymbol;
            effectiveTypeFromType.tsymbol = immutableTupleTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(origTupleTypeSymbol, env, pkgId, owner, origTupleTypeSymbolName);
            effectiveTypeFromType.addFlags(type.getFlags() | 0x20L);
            immutableTupleTSymbol.type = effectiveTypeFromType;
        } else {
            effectiveTypeFromType.addFlags(type.getFlags() | 0x20L);
        }
        BType effectiveType = immutableTupleIntersectionType.effectiveType;
        BTypeSymbol tsymbol = immutableTupleIntersectionType.effectiveType.tsymbol;
        if (Types.getImpliedType((BType)effectiveType).tag != 31 || tsymbol == null || tsymbol.name == null || tsymbol.name.value.isEmpty()) {
            return immutableTupleIntersectionType;
        }
        BLangTupleTypeNode tupleTypeNode = (BLangTupleTypeNode)TreeBuilder.createTupleTypeNode();
        tupleTypeNode.setBType(effectiveType);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(effectiveType, effectiveType.tsymbol, tupleTypeNode, env);
        typeDefinition.pos = pos;
        effectiveType.addFlags(0x80000000000L);
        return immutableTupleIntersectionType;
    }

    public static void defineUndefinedImmutableFields(BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv pkgEnv, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        Location pos = immutableTypeDefinition.pos;
        SymbolEnv env = SymbolEnv.createTypeEnv(immutableTypeDefinition.typeNode, immutableTypeDefinition.symbol.scope, pkgEnv);
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BType immutableType = Types.getImpliedType(immutableTypeDefinition.getBType());
        if (immutableType.tag == 12) {
            ImmutableTypeCloner.defineUndefinedImmutableRecordFields((BRecordType)immutableType, pos, pkgID, immutableTypeDefinition, types, env, symTable, anonymousModelHelper, names);
            return;
        }
        ImmutableTypeCloner.defineUndefinedImmutableObjectFields((BObjectType)immutableType, pos, pkgID, immutableTypeDefinition, types, env, symTable, anonymousModelHelper, names);
    }

    private static void defineUndefinedImmutableRecordFields(BRecordType immutableRecordType, Location loc, PackageID pkgID, BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        BType currentRestFieldType;
        BRecordType origRecordType = immutableRecordType.mutableType;
        if (origRecordType != null && origRecordType.fields.size() != immutableRecordType.fields.size()) {
            ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, (BLangRecordTypeNode)immutableTypeDefinition.typeNode, immutableRecordType, origRecordType, loc, env, pkgID, new HashSet<BType>());
        }
        if ((currentRestFieldType = immutableRecordType.restFieldType) != null && currentRestFieldType != symTable.noType) {
            return;
        }
        ImmutableTypeCloner.setRestType(types, symTable, anonymousModelHelper, names, immutableRecordType, origRecordType, loc, env, new HashSet<BType>());
    }

    private static void defineUndefinedImmutableObjectFields(BObjectType immutableObjectType, Location location, PackageID pkgID, BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        BObjectType origObjectType = immutableObjectType.mutableType;
        if (origObjectType.fields.size() != immutableObjectType.fields.size()) {
            TypeDefBuilderHelper.populateStructureFieldsAndTypeInclusions(types, symTable, anonymousModelHelper, names, (BLangObjectTypeNode)immutableTypeDefinition.typeNode, immutableObjectType, origObjectType, location, env, pkgID, new HashSet<BType>(), 4L, true);
        }
    }

    private static void populateImmutableStructureFields(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BLangStructureTypeNode immutableStructureTypeNode, BStructureType immutableStructureType, BStructureType origStructureType, Location pos, SymbolEnv env, PackageID pkgID, Set<BType> unresolvedTypes) {
        TypeDefBuilderHelper.populateStructureFieldsAndTypeInclusions(types, symTable, anonymousModelHelper, names, immutableStructureTypeNode, immutableStructureType, origStructureType, pos, env, pkgID, unresolvedTypes, 32L, true);
    }

    private static void setRestType(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BRecordType immutableRecordType, BRecordType origRecordType, Location pos, SymbolEnv env, Set<BType> unresolvedTypes) {
        immutableRecordType.sealed = origRecordType.sealed;
        BType origRestFieldType = origRecordType.restFieldType;
        if (origRestFieldType == null || origRestFieldType == symTable.noType) {
            immutableRecordType.restFieldType = origRestFieldType;
            return;
        }
        BType restFieldImmutableType = ImmutableTypeCloner.getImmutableType(pos, types, origRestFieldType, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, unresolvedTypes);
        immutableRecordType.restFieldType = restFieldImmutableType == symTable.semanticError ? symTable.neverType : restFieldImmutableType;
    }

    private static BIntersectionType defineImmutableRecordType(Location pos, BRecordType origRecordType, BType originalType, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Types types, Set<BType> unresolvedTypes) {
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BTypeSymbol recordTypeSymbol = origRecordType.tsymbol;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(recordTypeSymbol.flags | 0x20L, Types.getImmutableTypeName(ImmutableTypeCloner.getSymbolFQN(recordTypeSymbol)), pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BInvokableType bInvokableType = new BInvokableType(symTable.typeEnv(), List.of(), symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1L, Names.EMPTY, Names.EMPTY, env.enclPkg.symbol.pkgID, bInvokableType, env.scope.owner, false, symTable.builtinPos, SymbolOrigin.VIRTUAL);
        initFuncSymbol.retType = symTable.nilType;
        recordSymbol.scope = new Scope(recordSymbol);
        BRecordType immutableRecordType = new BRecordType(symTable.typeEnv(), (BTypeSymbol)recordSymbol, origRecordType.getFlags() | 0x20L);
        BIntersectionType immutableRecordIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, originalType, immutableRecordType, symTable);
        Types.addImmutableType(symTable, pkgID, origRecordType, immutableRecordIntersectionType);
        immutableRecordType.mutableType = origRecordType;
        recordSymbol.type = immutableRecordType;
        immutableRecordType.tsymbol = recordSymbol;
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(new ArrayList<BLangSimpleVariable>(), immutableRecordType, pos);
        ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, recordTypeNode, immutableRecordType, origRecordType, pos, env, pkgID, unresolvedTypes);
        ImmutableTypeCloner.setRestType(types, symTable, anonymousModelHelper, names, immutableRecordType, origRecordType, pos, env, unresolvedTypes);
        TypeDefBuilderHelper.addTypeDefinition(immutableRecordType, recordSymbol, recordTypeNode, env);
        return immutableRecordIntersectionType;
    }

    private static BIntersectionType defineImmutableObjectType(Location pos, BObjectType origObjectType, BType originalType, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Types types, Set<Flag> flagSet, Set<BType> unresolvedTypes) {
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BObjectTypeSymbol origObjectTSymbol = (BObjectTypeSymbol)origObjectType.tsymbol;
        long flags = origObjectTSymbol.flags | 0x20L;
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(flags &= 0xFFFFFFFFEFFFFFFFL, Types.getImmutableTypeName(ImmutableTypeCloner.getSymbolFQN(origObjectTSymbol)), pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        objectSymbol.scope = new Scope(objectSymbol);
        ImmutableTypeCloner.defineObjectFunctions(objectSymbol, origObjectTSymbol, names, symTable);
        BObjectType immutableObjectType = new BObjectType(symTable.typeEnv(), (BTypeSymbol)objectSymbol, origObjectType.getFlags() | 0x20L);
        immutableObjectType.typeIdSet = origObjectType.typeIdSet;
        BIntersectionType immutableObjectIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, originalType, immutableObjectType, symTable);
        Types.addImmutableType(symTable, pkgID, origObjectType, immutableObjectIntersectionType);
        immutableObjectType.mutableType = origObjectType;
        objectSymbol.type = immutableObjectType;
        immutableObjectType.tsymbol = objectSymbol;
        BLangObjectTypeNode objectTypeNode = TypeDefBuilderHelper.createObjectTypeNode(new ArrayList<BLangSimpleVariable>(), immutableObjectType, pos);
        objectTypeNode.flagSet.addAll(flagSet);
        TypeDefBuilderHelper.populateStructureFieldsAndTypeInclusions(types, symTable, anonymousModelHelper, names, objectTypeNode, immutableObjectType, origObjectType, pos, env, pkgID, unresolvedTypes, 4L, true);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(immutableObjectType, objectSymbol, objectTypeNode, env);
        typeDefinition.pos = pos;
        return immutableObjectIntersectionType;
    }

    public static void defineObjectFunctions(BObjectTypeSymbol immutableObjectSymbol, BObjectTypeSymbol originalObjectSymbol, Names names, SymbolTable symTable) {
        List originalObjectAttachedFuncs = originalObjectSymbol.attachedFuncs;
        List immutableObjectAttachedFuncs = immutableObjectSymbol.attachedFuncs;
        if (originalObjectAttachedFuncs.isEmpty() || immutableObjectAttachedFuncs.size() == originalObjectAttachedFuncs.size()) {
            return;
        }
        ArrayList<BAttachedFunction> immutableFuncs = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction origFunc : originalObjectAttachedFuncs) {
            Name funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(immutableObjectSymbol.name.value, origFunc.funcName.value));
            BInvokableSymbol immutableFuncSymbol = ASTBuilderUtil.duplicateFunctionDeclarationSymbol(symTable.typeEnv(), origFunc.symbol, immutableObjectSymbol, funcName, immutableObjectSymbol.pkgID, symTable.builtinPos, SymbolOrigin.VIRTUAL);
            immutableFuncs.add(new BAttachedFunction(origFunc.funcName, immutableFuncSymbol, (BInvokableType)immutableFuncSymbol.type, symTable.builtinPos));
            immutableObjectSymbol.scope.define(funcName, immutableFuncSymbol);
        }
        immutableObjectSymbol.attachedFuncs = immutableFuncs;
    }

    private static BIntersectionType defineImmutableUnionType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BUnionType type, BType originalType) {
        BTypeSymbol origUnionTypeSymbol = type.tsymbol;
        Set originalMemberList = type.getMemberTypes();
        Optional<BIntersectionType> immutableTypeOptional = Types.getImmutableType(symTable, pkgId, type);
        if (immutableTypeOptional.isPresent()) {
            return immutableTypeOptional.get();
        }
        BUnionType immutableUnionType = BUnionType.create(symTable.typeEnv(), origUnionTypeSymbol, new BType[0]);
        Types.addImmutableType(symTable, pkgId, type, ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, immutableUnionType, symTable));
        BIntersectionType immutableType = ImmutableTypeCloner.handleImmutableUnionType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, type, origUnionTypeSymbol, (LinkedHashSet<BType>)originalMemberList);
        BType effectiveType = immutableType.effectiveType;
        BTypeSymbol tsymbol = effectiveType.tsymbol;
        if (effectiveType.tag != 21 || tsymbol == null || tsymbol.name == null || tsymbol.name.value.isEmpty()) {
            return immutableType;
        }
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.setBType(effectiveType);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(effectiveType, effectiveType.tsymbol, unionTypeNode, env);
        typeDefinition.pos = pos;
        return immutableType;
    }

    private static BIntersectionType defineImmutableBuiltInUnionType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BUnionType type, BType originalType) {
        BTypeSymbol origBuiltInUnionTypeSymbol = type.tsymbol;
        Optional<BIntersectionType> immutableTypeOptional = Types.getImmutableType(symTable, pkgId, type);
        if (immutableTypeOptional.isPresent()) {
            return immutableTypeOptional.get();
        }
        BUnionType effectiveType = type.tag == 7 ? ImmutableTypeCloner.defineImmutableJsonType(env, pkgId, owner, names, (BJSONType)type) : ImmutableTypeCloner.defineImmutableAnydataType(env, pkgId, owner, names, (BAnydataType)type);
        BIntersectionType immutableBuiltInUnionIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, originalType, effectiveType, symTable);
        Types.addImmutableType(symTable, pkgId, type, immutableBuiltInUnionIntersectionType);
        return ImmutableTypeCloner.handleImmutableUnionType(pos, types, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes, type, origBuiltInUnionTypeSymbol, (LinkedHashSet<BType>)type.getMemberTypes());
    }

    private static BAnydataType defineImmutableAnydataType(SymbolEnv env, PackageID pkgId, BSymbol owner, Names names, BAnydataType type) {
        BTypeSymbol immutableAnydataTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        if (immutableAnydataTSymbol != null) {
            BAnydataType immutableAnydataType = BAnydataType.newImmutableBAnydataType(type, immutableAnydataTSymbol, immutableAnydataTSymbol.name, type.isNullable());
            immutableAnydataTSymbol.type = immutableAnydataType;
            return immutableAnydataType;
        }
        return BAnydataType.newImmutableBAnydataType(type, null, Types.getImmutableTypeName(TypeKind.ANYDATA.typeName()), type.isNullable());
    }

    private static BJSONType defineImmutableJsonType(SymbolEnv env, PackageID pkgId, BSymbol owner, Names names, BJSONType type) {
        BTypeSymbol immutableJsonTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(type.tsymbol, env, pkgId, owner);
        BJSONType immutableJsonType = BJSONType.newImmutableBJSONType(type, immutableJsonTSymbol, type.isNullable());
        if (immutableJsonTSymbol != null) {
            immutableJsonTSymbol.type = immutableJsonType;
        }
        return immutableJsonType;
    }

    private static BIntersectionType handleImmutableUnionType(Location pos, Types types, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes, BUnionType type, BTypeSymbol origUnionTypeSymbol, LinkedHashSet<BType> originalMemberList) {
        String originalTypeName;
        BIntersectionType immutableType = Types.getImmutableType(symTable, pkgId, type).get();
        LinkedHashSet<BType> readOnlyMemTypes = new LinkedHashSet<BType>(originalMemberList.size());
        BUnionType unionEffectiveImmutableType = (BUnionType)immutableType.effectiveType;
        unionEffectiveImmutableType.isCyclic = type.isCyclic;
        unionEffectiveImmutableType.setMemberTypes(readOnlyMemTypes);
        String string = originalTypeName = origUnionTypeSymbol == null ? "" : origUnionTypeSymbol.name.getValue();
        if (!originalTypeName.isEmpty()) {
            unionEffectiveImmutableType.name = Types.getImmutableTypeName(ImmutableTypeCloner.getSymbolFQN(origUnionTypeSymbol));
        }
        for (BType memberType : originalMemberList) {
            if (types.isInherentlyImmutableType(memberType)) {
                unionEffectiveImmutableType.add(memberType);
                continue;
            }
            if (!types.isSelectivelyImmutableType(memberType, unresolvedTypes, pkgId)) continue;
            BType immutableMemberType = ImmutableTypeCloner.getImmutableType(pos, types, memberType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
            unionEffectiveImmutableType.add(immutableMemberType);
        }
        if (readOnlyMemTypes.size() == 1) {
            immutableType.effectiveType = (BType)readOnlyMemTypes.iterator().next();
        } else if (origUnionTypeSymbol != null) {
            BTypeSymbol immutableUnionTSymbol;
            immutableType.effectiveType.tsymbol = immutableUnionTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(origUnionTypeSymbol, env, pkgId, owner, origUnionTypeSymbol.name.value.isEmpty() ? Names.EMPTY : Types.getImmutableTypeName(ImmutableTypeCloner.getSymbolFQN(origUnionTypeSymbol)));
            immutableType.effectiveType.addFlags(type.getFlags() | 0x20L);
            immutableUnionTSymbol.type = immutableType.effectiveType;
        } else {
            immutableType.effectiveType.addFlags(type.getFlags() | 0x20L);
        }
        return immutableType;
    }

    private static BTypeSymbol getReadonlyTSymbol(BTypeSymbol originalTSymbol, SymbolEnv env, PackageID pkgId, BSymbol owner) {
        if (originalTSymbol == null) {
            return null;
        }
        return ImmutableTypeCloner.getReadonlyTSymbol(originalTSymbol, env, pkgId, owner, ImmutableTypeCloner.getImmutableTypeName(originalTSymbol));
    }

    private static BTypeSymbol getReadonlyTSymbol(BTypeSymbol originalTSymbol, SymbolEnv env, PackageID pkgId, BSymbol owner, Name immutableTypeName) {
        if (originalTSymbol == null) {
            return null;
        }
        if (env == null) {
            return Symbols.createTypeSymbol(originalTSymbol.tag, originalTSymbol.flags | 0x20L, immutableTypeName, pkgId, null, owner, originalTSymbol.pos, SymbolOrigin.SOURCE);
        }
        return Symbols.createTypeSymbol(originalTSymbol.tag, originalTSymbol.flags | 0x20L, immutableTypeName, env.enclPkg.symbol.pkgID, null, env.scope.owner, originalTSymbol.pos, SymbolOrigin.SOURCE);
    }

    private static String getSymbolFQN(BTypeSymbol originalTSymbol) {
        PackageID pkgID = originalTSymbol.pkgID;
        if (pkgID == PackageID.DEFAULT || pkgID.equals(PackageID.ANNOTATIONS) || pkgID.name == Names.DEFAULT_PACKAGE) {
            return originalTSymbol.name.value;
        }
        return String.valueOf(pkgID.orgName) + Names.ORG_NAME_SEPARATOR.value + String.valueOf(pkgID.name) + String.valueOf(Names.VERSION_SEPARATOR) + CompilerUtils.getMajorVersion(pkgID.version.value) + ":" + String.valueOf(originalTSymbol.name);
    }

    private static Name getImmutableTypeName(BTypeSymbol originalTSymbol) {
        return Types.getImmutableTypeName(originalTSymbol.name.getValue());
    }

    private static BIntersectionType createImmutableIntersectionType(SymbolEnv env, BType nonReadOnlyType, BType effectiveType, SymbolTable symTable) {
        return ImmutableTypeCloner.createImmutableIntersectionType(env.enclPkg.symbol.pkgID, env.scope.owner, nonReadOnlyType, effectiveType, symTable);
    }

    private static BIntersectionType createImmutableIntersectionType(PackageID pkgId, BSymbol owner, final BType nonReadOnlyType, BType effectiveType, final SymbolTable symTable) {
        BTypeSymbol intersectionTypeSymbol = Symbols.createTypeSymbol(2129948L, Flags.asMask(EnumSet.of(Flag.PUBLIC, Flag.READONLY)), Names.EMPTY, pkgId, null, owner, symTable.builtinPos, SymbolOrigin.VIRTUAL);
        LinkedHashSet<BType> constituentTypes = new LinkedHashSet<BType>(){
            {
                this.add(nonReadOnlyType);
                this.add(symTable.readonlyType);
            }
        };
        BIntersectionType intersectionType = new BIntersectionType(intersectionTypeSymbol, constituentTypes, effectiveType, 0x20L | effectiveType.getFlags());
        intersectionTypeSymbol.type = intersectionType;
        return intersectionType;
    }
}

