/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public final class NodeUtils {
    private NodeUtils() {
    }

    public static Name getName(Names names, List<BLangIdentifier> pkgNameComps) {
        String pkgName = String.join((CharSequence)".", pkgNameComps.stream().map(id -> id.value).toList());
        return Names.fromString(pkgName);
    }

    public static Name getName(String localname, String namespaceURI) {
        String qname = (String)(namespaceURI == null ? "" : "{" + namespaceURI + "}") + localname;
        return new Name(qname);
    }

    public static PackageID getPackageID(Names names, BLangIdentifier orgNameNode, List<BLangIdentifier> pkgNameComps, BLangIdentifier versionNode) {
        Name version;
        List<Name> nameList = pkgNameComps.stream().map(names::fromIdNode).toList();
        Name orgName = null;
        if (orgNameNode != null) {
            orgName = names.fromIdNode(orgNameNode);
        }
        if ((version = names.fromIdNode(versionNode)) == Names.EMPTY) {
            version = Names.DEFAULT_VERSION;
        }
        return new PackageID(orgName, nameList, version);
    }
}

