/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public final class TypeDefBuilderHelper {
    public static final String INTERSECTED_ERROR_DETAIL = "$IntersectedErrorDetail$";

    private TypeDefBuilderHelper() {
    }

    public static BLangRecordTypeNode createRecordTypeNode(BRecordType recordType, PackageID packageID, SymbolTable symTable, Location pos) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : recordType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            if (symbol == null) {
                symbol = new BVarSymbol(1L, field.name, packageID, symTable.pureType, null, field.pos, SymbolOrigin.VIRTUAL);
            }
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createRecordTypeNode(fieldList, recordType, pos);
    }

    public static BLangObjectTypeNode createObjectTypeNode(BObjectType objectType, Location pos) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : objectType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createObjectTypeNode(fieldList, objectType, pos);
    }

    public static BLangRecordTypeNode createRecordTypeNode(List<BLangSimpleVariable> typeDefFields, BRecordType recordType, Location pos) {
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)TreeBuilder.createRecordTypeNode();
        recordTypeNode.setBType(recordType);
        recordTypeNode.fields = typeDefFields;
        recordTypeNode.symbol = recordType.tsymbol;
        recordTypeNode.pos = pos;
        return recordTypeNode;
    }

    public static BLangObjectTypeNode createObjectTypeNode(List<BLangSimpleVariable> typeDefFields, BObjectType objectType, Location pos) {
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)TreeBuilder.createObjectTypeNode();
        objectTypeNode.setBType(objectType);
        objectTypeNode.fields = typeDefFields;
        objectTypeNode.symbol = objectType.tsymbol;
        objectTypeNode.pos = pos;
        return objectTypeNode;
    }

    public static BLangFunction createInitFunctionForStructureType(BSymbol symbol, SymbolEnv env, Names names, Name suffix, SymbolTable symTable, BType type) {
        return TypeDefBuilderHelper.createInitFunctionForStructureType(symTable.typeEnv(), symbol, env, names, suffix, type, symTable.nilType);
    }

    public static BLangFunction createInitFunctionForStructureType(Env typeEnv, BSymbol symbol, SymbolEnv env, Names names, Name suffix, BType type, BType returnType) {
        BVarSymbol receiverSymbol;
        String structTypeName = type.tsymbol.name.value;
        BLangFunction initFunction = ASTBuilderUtil.createInitFunctionWithNilReturn(null, structTypeName, suffix);
        initFunction.receiver = ASTBuilderUtil.createReceiver(null, type);
        initFunction.receiver.symbol = receiverSymbol = new BVarSymbol(Flags.asMask(EnumSet.noneOf(Flag.class)), names.fromIdNode(initFunction.receiver.name), names.originalNameFromIdNode(initFunction.receiver.name), env.enclPkg.symbol.pkgID, type, null, null, SymbolOrigin.VIRTUAL);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        initFunction.setBType(new BInvokableType(typeEnv, List.of(), returnType, null));
        Name funcSymbolName = Names.fromString(Symbols.getAttachedFuncSymbolName(structTypeName, suffix.value));
        initFunction.symbol = Symbols.createFunctionSymbol(Flags.asMask(initFunction.flagSet), funcSymbolName, funcSymbolName, env.enclPkg.symbol.pkgID, initFunction.getBType(), symbol, initFunction.body != null, initFunction.pos, SymbolOrigin.VIRTUAL);
        initFunction.symbol.scope = new Scope(initFunction.symbol);
        initFunction.symbol.scope.define(receiverSymbol.name, receiverSymbol);
        initFunction.symbol.receiverSymbol = receiverSymbol;
        initFunction.name = ASTBuilderUtil.createIdentifier(null, funcSymbolName.value);
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(33587228L, initFunction.symbol.flags, env.enclPkg.packageID, initFunction.getBType(), initFunction.symbol, initFunction.pos, SymbolOrigin.VIRTUAL);
        tsymbol.params = initFunction.symbol.params;
        tsymbol.restParam = initFunction.symbol.restParam;
        tsymbol.returnType = initFunction.symbol.retType;
        initFunction.getBType().tsymbol = tsymbol;
        receiverSymbol.owner = initFunction.symbol;
        initFunction.symbol.retType = returnType;
        return initFunction;
    }

    public static BLangTypeDefinition addTypeDefinition(BType type, BTypeSymbol symbol, BLangType typeNode, SymbolEnv env) {
        BLangTypeDefinition typeDefinition = (BLangTypeDefinition)TreeBuilder.createTypeDefinition();
        typeDefinition.typeNode = typeNode;
        typeDefinition.setBType(type);
        typeDefinition.symbol = symbol;
        typeDefinition.name = ASTBuilderUtil.createIdentifier(symbol.pos, symbol.name.value);
        if (env != null) {
            env.enclPkg.addTypeDefinition(typeDefinition);
        }
        return typeDefinition;
    }

    public static BLangTypeDefinition createTypeDefinitionForTSymbol(BType type, BSymbol symbol, BLangType typeNode, SymbolEnv env) {
        BLangTypeDefinition typeDefinition = (BLangTypeDefinition)TreeBuilder.createTypeDefinition();
        typeDefinition.typeNode = typeNode;
        typeDefinition.setBType(type);
        typeDefinition.symbol = Symbols.createTypeDefinitionSymbol(symbol.flags, Names.fromString(symbol.name.value), symbol.pkgID, type, symbol.owner, symbol.pos, symbol.origin);
        typeDefinition.name = ASTBuilderUtil.createIdentifier(symbol.pos, symbol.name.value);
        env.enclPkg.addTypeDefinition(typeDefinition);
        return typeDefinition;
    }

    public static BLangClassDefinition createClassDef(Location pos, BObjectTypeSymbol classTSymbol, SymbolEnv env) {
        BObjectType objType = (BObjectType)classTSymbol.type;
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : objType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        BLangClassDefinition classDefNode = (BLangClassDefinition)TreeBuilder.createClassDefNode();
        classDefNode.setBType(objType);
        classDefNode.fields = fieldList;
        classDefNode.symbol = classTSymbol;
        classDefNode.pos = pos;
        env.enclPkg.addClassDefinition(classDefNode);
        return classDefNode;
    }

    public static BLangErrorType createBLangErrorType(Location pos, BErrorType type, SymbolEnv env, BLangAnonymousModelHelper anonymousModelHelper) {
        BLangErrorType errorType = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorType.setBType(type);
        BLangUserDefinedType userDefinedTypeNode = (BLangUserDefinedType)TreeBuilder.createUserDefinedTypeNode();
        userDefinedTypeNode.pos = pos;
        userDefinedTypeNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        BType detailType = Types.getImpliedType(type.detailType);
        if (detailType.tag == 16) {
            BLangBuiltInRefTypeNode refType = (BLangBuiltInRefTypeNode)TreeBuilder.createBuiltInReferenceTypeNode();
            refType.typeKind = TypeKind.MAP;
            refType.pos = pos;
            BLangConstrainedType constrainedType = (BLangConstrainedType)TreeBuilder.createConstrainedTypeNode();
            constrainedType.constraint = userDefinedTypeNode;
            userDefinedTypeNode.typeName = ASTBuilderUtil.createIdentifier(pos, INTERSECTED_ERROR_DETAIL);
            constrainedType.type = refType;
            constrainedType.pos = pos;
            errorType.detailType = constrainedType;
            return errorType;
        }
        String typeName = detailType.tsymbol != null ? detailType.tsymbol.name.value : anonymousModelHelper.getNextAnonymousIntersectionErrorDetailTypeName(env.enclPkg.packageID);
        userDefinedTypeNode.typeName = ASTBuilderUtil.createIdentifier(pos, typeName);
        userDefinedTypeNode.setBType(detailType);
        errorType.detailType = userDefinedTypeNode;
        return errorType;
    }

    public static String getPackageAlias(SymbolEnv env, String compUnitName, PackageID typePkgId) {
        for (BLangImportPackage importStmt : env.enclPkg.imports) {
            if (importStmt == null || importStmt.compUnit == null || importStmt.compUnit.value == null || !importStmt.compUnit.value.equals(compUnitName) || importStmt.symbol == null || !typePkgId.equals(importStmt.symbol.pkgID)) continue;
            return importStmt.alias.value;
        }
        return "";
    }

    public static void populateStructureFieldsAndTypeInclusions(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BLangStructureTypeNode structureTypeNode, BStructureType structureType, BStructureType origStructureType, Location pos, SymbolEnv env, PackageID pkgID, Set<BType> unresolvedTypes, long flag, boolean isImmutable) {
        BTypeSymbol structureSymbol = structureType.tsymbol;
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        structureType.typeInclusions = origStructureType.typeInclusions;
        for (BField origField : origStructureType.fields.values()) {
            BVarSymbol fieldSymbol;
            BType fieldType = isImmutable ? ImmutableTypeCloner.getImmutableType(pos, types, origField.type, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, unresolvedTypes) : origField.type;
            Name origFieldName = origField.symbol.originalName;
            Name fieldName = origField.name;
            BType referredType = Types.getImpliedType(fieldType);
            if (referredType.tag == 17 && referredType.tsymbol != null) {
                fieldSymbol = new BInvokableSymbol(origField.symbol.tag, origField.symbol.flags | flag, fieldName, origFieldName, pkgID, fieldType, (BSymbol)structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)referredType.tsymbol;
                BInvokableSymbol invokableSymbol = (BInvokableSymbol)fieldSymbol;
                invokableSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
                invokableSymbol.restParam = tsymbol.restParam;
                invokableSymbol.retType = tsymbol.returnType;
                invokableSymbol.flags |= tsymbol.flags;
            } else {
                fieldSymbol = fieldType == symTable.semanticError ? new BVarSymbol(origField.symbol.flags | flag | 0x1000L, fieldName, origFieldName, pkgID, symTable.neverType, (BSymbol)structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE) : new BVarSymbol(origField.symbol.flags | flag, fieldName, origFieldName, pkgID, fieldType, (BSymbol)structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
            }
            fieldSymbol.isDefaultable = origField.symbol.isDefaultable;
            String nameString = fieldName.value;
            fields.put(nameString, new BField(fieldName, null, fieldSymbol));
            structureSymbol.scope.define(fieldName, fieldSymbol);
        }
        structureType.fields = fields;
        if (origStructureType.tag == 34) {
            return;
        }
        BLangUserDefinedType origTypeRef = new BLangUserDefinedType(ASTBuilderUtil.createIdentifier(pos, TypeDefBuilderHelper.getPackageAlias(env, null, origStructureType.tsymbol.pkgID)), ASTBuilderUtil.createIdentifier(pos, origStructureType.tsymbol.name.value));
        origTypeRef.pos = pos;
        origTypeRef.setBType(origStructureType);
        if (isImmutable) {
            structureTypeNode.typeRefs.add(origTypeRef);
        }
    }

    public static void createTypeDefinition(BRecordType type, Location pos, Names names, Types types, SymbolTable symTable, SymbolEnv env) {
        BRecordTypeSymbol recordSymbol = (BRecordTypeSymbol)type.tsymbol;
        BTypeDefinitionSymbol typeDefinitionSymbol = Symbols.createTypeDefinitionSymbol(type.tsymbol.flags, type.tsymbol.name, env.scope.owner.pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        typeDefinitionSymbol.scope = new Scope(typeDefinitionSymbol);
        typeDefinitionSymbol.scope.define(Names.fromString(typeDefinitionSymbol.name.value), typeDefinitionSymbol);
        type.tsymbol.scope = new Scope(type.tsymbol);
        for (BField field : ((HashMap)type.fields).values()) {
            type.tsymbol.scope.define(field.name, field.symbol);
            field.symbol.owner = recordSymbol;
        }
        typeDefinitionSymbol.type = type;
        recordSymbol.type = type;
        recordSymbol.typeDefinitionSymbol = typeDefinitionSymbol;
        recordSymbol.markdownDocumentation = new MarkdownDocAttachment(0);
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(new ArrayList<BLangSimpleVariable>(), type, pos);
        TypeDefBuilderHelper.populateStructureFieldsAndTypeInclusions(types, symTable, null, names, recordTypeNode, type, type, pos, env, env.scope.owner.pkgID, null, 256L, false);
        recordTypeNode.sealed = true;
        recordTypeNode.analyzed = true;
        type.restFieldType = new BNoType(24);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.createTypeDefinitionForTSymbol(null, typeDefinitionSymbol, recordTypeNode, env);
        typeDefinition.symbol.scope = new Scope(typeDefinition.symbol);
        typeDefinition.symbol.type = type;
        typeDefinition.flagSet = new HashSet<Flag>();
        typeDefinition.flagSet.add(Flag.PUBLIC);
        typeDefinition.flagSet.add(Flag.ANONYMOUS);
    }
}

