/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

public final class TypeTags {
    public static final int INT = 1;
    public static final int BYTE = 2;
    public static final int FLOAT = 3;
    public static final int DECIMAL = 4;
    public static final int STRING = 5;
    public static final int BOOLEAN = 6;
    public static final int JSON = 7;
    public static final int XML = 8;
    public static final int TABLE = 9;
    public static final int NIL = 10;
    public static final int ANYDATA = 11;
    public static final int RECORD = 12;
    public static final int TYPEDESC = 13;
    public static final int TYPEREFDESC = 14;
    public static final int STREAM = 15;
    public static final int MAP = 16;
    public static final int INVOKABLE = 17;
    public static final int ANY = 18;
    public static final int ENDPOINT = 19;
    public static final int ARRAY = 20;
    public static final int UNION = 21;
    public static final int INTERSECTION = 22;
    public static final int PACKAGE = 23;
    public static final int NONE = 24;
    public static final int VOID = 25;
    public static final int XMLNS = 26;
    public static final int ANNOTATION = 27;
    public static final int SEMANTIC_ERROR = 28;
    public static final int ERROR = 29;
    public static final int ITERATOR = 30;
    public static final int TUPLE = 31;
    public static final int FUTURE = 32;
    public static final int FINITE = 33;
    public static final int OBJECT = 34;
    public static final int BYTE_ARRAY = 35;
    public static final int FUNCTION_POINTER = 36;
    public static final int HANDLE = 37;
    public static final int READONLY = 38;
    public static final int SIGNED32_INT = 39;
    public static final int SIGNED16_INT = 40;
    public static final int SIGNED8_INT = 41;
    public static final int UNSIGNED32_INT = 42;
    public static final int UNSIGNED16_INT = 43;
    public static final int UNSIGNED8_INT = 44;
    public static final int CHAR_STRING = 45;
    public static final int XML_ELEMENT = 46;
    public static final int XML_PI = 47;
    public static final int XML_COMMENT = 48;
    public static final int XML_TEXT = 49;
    public static final int NEVER = 50;
    public static final int NULL_SET = 51;
    public static final int PARAMETERIZED_TYPE = 52;
    public static final int REGEXP = 53;
    public static final int EMPTY = 54;
    public static final int SEQUENCE = 54;

    private TypeTags() {
    }

    public static boolean isIntegerTypeTag(int tag) {
        return switch (tag) {
            case 1, 39, 40, 41, 42, 43, 44 -> true;
            default -> false;
        };
    }

    public static boolean isSignedIntegerTypeTag(int tag) {
        return switch (tag) {
            case 1, 39, 40, 41 -> true;
            default -> false;
        };
    }

    public static boolean isXMLTypeTag(int tag) {
        return switch (tag) {
            case 8, 46, 47, 48, 49 -> true;
            default -> false;
        };
    }

    public static boolean isXMLNonSequenceType(int tag) {
        return switch (tag) {
            case 46, 47, 48, 49 -> true;
            default -> false;
        };
    }

    public static boolean isStringTypeTag(int tag) {
        return switch (tag) {
            case 5, 45 -> true;
            default -> false;
        };
    }

    public static boolean isSimpleBasicType(int tag) {
        return switch (tag) {
            case 2, 3, 4, 6, 10 -> true;
            default -> TypeTags.isIntegerTypeTag(tag) || TypeTags.isStringTypeTag(tag);
        };
    }
}

