/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class Unifier
implements BTypeVisitor<BType, BType> {
    private Map<String, BType> paramValueTypes;
    private Set<BType> visitedTypes = new HashSet<BType>();
    private boolean isInvocation;
    private BLangInvocation invocation;
    private BLangFunction function;
    private SymbolTable symbolTable;
    private SymbolEnv env;
    private Types types;
    private BLangDiagnosticLog dlog;
    private Env typeEnv;

    public BType build(Env typeEnv, BType originalType, BType expType, BLangInvocation invocation, Types types, SymbolTable symbolTable, BLangDiagnosticLog dlog) {
        boolean bl = this.isInvocation = invocation != null;
        if (this.isInvocation) {
            this.invocation = invocation;
            this.createParamMap(invocation);
        }
        this.typeEnv = typeEnv;
        this.types = types;
        this.symbolTable = symbolTable;
        this.dlog = dlog;
        BType newType = originalType.accept(this, expType);
        this.resetBuildArgs();
        return newType;
    }

    public BType build(Env typeEnv, BType originalType) {
        return this.build(typeEnv, originalType, null, null, null, null, null);
    }

    public void validate(Env typeEnv, BType returnType, BLangFunction function, SymbolTable symbolTable, SymbolEnv env, Types types, BLangDiagnosticLog dlog) {
        this.typeEnv = typeEnv;
        this.function = function;
        this.symbolTable = symbolTable;
        this.env = env;
        this.types = types;
        this.dlog = dlog;
        returnType.accept(this, null);
        this.resetValidateArgs();
    }

    @Override
    public BType visit(BType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BAnyType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BAnydataType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BMapType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expConstraint = matchingType == null ? null : ((BMapType)matchingType).constraint;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        if (this.isSameType(newConstraint, originalType.constraint)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint)) {
            return this.symbolTable.semanticError;
        }
        BMapType newMType = new BMapType(this.typeEnv, originalType.tag, newConstraint, null);
        this.setFlags(newMType, originalType.getFlags());
        return newMType;
    }

    @Override
    public BType visit(BXMLType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expConstraint = matchingType == null ? null : ((BXMLType)matchingType).constraint;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        if (this.isSameType(newConstraint, originalType.constraint)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint)) {
            return this.symbolTable.semanticError;
        }
        BXMLType newXMLType = new BXMLType(newConstraint, null);
        this.setFlags(newXMLType, originalType.getFlags());
        return newXMLType;
    }

    @Override
    public BType visit(BJSONType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BArrayType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expElemType = matchingType == null ? null : ((BArrayType)matchingType).eType;
        BType newElemType = originalType.eType.accept(this, expElemType);
        if (this.isSameType(newElemType, originalType.eType)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newElemType)) {
            return this.symbolTable.semanticError;
        }
        BArrayType newArrayType = new BArrayType(this.typeEnv, newElemType, null, originalType.getSize(), originalType.state);
        this.setFlags(newArrayType, originalType.getFlags());
        return newArrayType;
    }

    @Override
    public BType visit(BObjectType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BRecordType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BTupleType originalType, BType expType) {
        BTupleType expTupleType;
        if (!this.visitedTypes.add(originalType)) {
            return originalType;
        }
        boolean hasNewType = false;
        BTupleType matchingType = (BTupleType)this.getMatchingTypeForInferrableType(originalType, expType);
        boolean hasMatchedTupleType = matchingType != null;
        BTupleType bTupleType = expTupleType = hasMatchedTupleType ? matchingType : null;
        if (hasMatchedTupleType) {
            if (expTupleType.getMembers().size() != originalType.getMembers().size()) {
                hasMatchedTupleType = false;
            } else {
                BType expRestType = expTupleType.restType;
                BType originalRestType = originalType.restType;
                if ((expRestType == null || originalRestType == null) && expRestType != originalRestType) {
                    hasMatchedTupleType = false;
                }
            }
        }
        List<Object> expTupleTypes = hasMatchedTupleType ? List.copyOf(expTupleType.getTupleTypes()) : Collections.singletonList(null);
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
        int delta = hasMatchedTupleType ? 1 : 0;
        boolean errored = false;
        List<BType> tupleTypes = originalType.getTupleTypes();
        int i = 0;
        int j = 0;
        while (i < tupleTypes.size()) {
            if (!this.visitedTypes.contains(tupleTypes.get(i))) {
                BType member = tupleTypes.get(i);
                BType expMember = (BType)expTupleTypes.get(j);
                BType newMem = member.accept(this, expMember);
                BVarSymbol varSymbol = new BVarSymbol(newMem.getFlags(), null, null, newMem, null, null, null);
                members.add(new BTupleMember(newMem, varSymbol));
                if (this.isSemanticErrorInInvocation(newMem)) {
                    errored = true;
                } else if (!this.isSameType(newMem, member)) {
                    hasNewType = true;
                }
            }
            ++i;
            j += delta;
        }
        BType restType = originalType.restType;
        BType newRestType = null;
        if (restType != null) {
            BType expRestType = hasMatchedTupleType ? matchingType.restType : null;
            newRestType = restType.accept(this, expRestType);
            if (this.isSemanticErrorInInvocation(newRestType)) {
                errored = true;
            } else if (!this.isSameType(newRestType, restType)) {
                hasNewType = true;
            }
        }
        if (errored) {
            return expType;
        }
        if (!hasNewType) {
            return expType != null ? expType : originalType;
        }
        BTupleType type = new BTupleType(this.typeEnv, members);
        type.restType = newRestType;
        this.setFlags(type, originalType.getFlags());
        return type;
    }

    @Override
    public BType visit(BStreamType originalType, BType expType) {
        BStreamType matchingType = (BStreamType)this.getMatchingTypeForInferrableType(originalType, expType);
        boolean hasMatchedStreamType = matchingType != null;
        BStreamType expStreamType = hasMatchedStreamType ? matchingType : null;
        BType expConstraint = hasMatchedStreamType ? expStreamType.constraint : null;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        BType newError = null;
        if (originalType.completionType != null) {
            BType expError = hasMatchedStreamType ? matchingType.completionType : null;
            newError = originalType.completionType.accept(this, expError);
        }
        if (this.isSameType(newConstraint, originalType.constraint) && this.isSameType(newError, originalType.completionType)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint) || this.isSemanticErrorInInvocation(newError)) {
            return this.symbolTable.semanticError;
        }
        BStreamType type = new BStreamType(this.typeEnv, originalType.tag, newConstraint, newError, null);
        this.setFlags(type, originalType.getFlags());
        return type;
    }

    @Override
    public BType visit(BTableType originalType, BType expType) {
        BTableType matchingType = (BTableType)this.getMatchingTypeForInferrableType(originalType, expType);
        boolean hasMatchedTableType = matchingType != null;
        BType expConstraint = hasMatchedTableType ? matchingType.constraint : null;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        Object newKeyTypeConstraint = null;
        if (originalType.keyTypeConstraint != null) {
            BType expKeyConstraint = hasMatchedTableType ? matchingType.keyTypeConstraint : null;
            originalType.keyTypeConstraint.accept(this, expKeyConstraint);
        }
        if (this.isSameType(newConstraint, originalType.constraint) && this.isSameType(null, originalType.keyTypeConstraint)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint) || this.isSemanticErrorInInvocation(null)) {
            return this.symbolTable.semanticError;
        }
        BTableType newTableType = new BTableType(this.typeEnv, newConstraint, null);
        newTableType.keyTypeConstraint = null;
        newTableType.fieldNameList = originalType.fieldNameList;
        newTableType.constraintPos = originalType.constraintPos;
        newTableType.isTypeInlineDefined = originalType.isTypeInlineDefined;
        newTableType.keyPos = originalType.keyPos;
        this.setFlags(newTableType, originalType.getFlags());
        return newTableType;
    }

    @Override
    public BType visit(BInvokableType originalType, BType expType) {
        if (Symbols.isFlagOn(originalType.getFlags(), 0x8000000000L)) {
            return originalType;
        }
        boolean hasNewType = false;
        BInvokableType matchingType = (BInvokableType)this.getMatchingTypeForInferrableType(originalType, expType);
        boolean hasMatchingInvokableType = matchingType != null;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        List<BType> expParamTypes = hasMatchingInvokableType ? matchingType.paramTypes : Collections.singletonList(null);
        int delta = hasMatchingInvokableType ? 1 : 0;
        boolean errored = false;
        List<BType> bTypes = originalType.paramTypes;
        int i = 0;
        int j = 0;
        while (i < bTypes.size()) {
            BType type = bTypes.get(i);
            BType expParamType = expParamTypes.get(j);
            BType newT = type.accept(this, expParamType);
            paramTypes.add(newT);
            if (this.isSemanticErrorInInvocation(newT)) {
                errored = true;
            } else if (!this.isSameType(newT, type)) {
                hasNewType = true;
            }
            ++i;
            j += delta;
        }
        BType restType = originalType.restType;
        BType newRestType = null;
        if (restType != null) {
            BType expRestType = hasMatchingInvokableType ? matchingType.restType : null;
            newRestType = restType.accept(this, expRestType);
            if (this.isSemanticErrorInInvocation(newRestType)) {
                errored = true;
            } else if (!this.isSameType(newRestType, restType)) {
                hasNewType = true;
            }
        }
        BType expRetType = hasMatchingInvokableType ? matchingType.retType : null;
        BType retType = originalType.retType.accept(this, expRetType);
        if (errored) {
            return expType;
        }
        if (!hasNewType) {
            if (this.isSameType(retType, originalType.retType)) {
                return originalType;
            }
            if (this.isSemanticErrorInInvocation(retType)) {
                return this.symbolTable.semanticError;
            }
        }
        BInvokableType type = new BInvokableType(this.typeEnv, paramTypes, newRestType, retType, null);
        this.setFlags(type, originalType.getFlags());
        return type;
    }

    @Override
    public BType visit(BUnionType originalType, BType expType) {
        if (!this.visitedTypes.add(originalType)) {
            return originalType;
        }
        boolean hasNewType = false;
        LinkedHashSet<BType> newMemberTypes = new LinkedHashSet<BType>();
        for (BType member : originalType.getMemberTypes()) {
            BParameterizedType parameterizedType;
            BType paramConstraint;
            if (this.visitedTypes.contains(member)) continue;
            BType referredMember = Types.getImpliedType(member);
            if (this.function != null && referredMember.tag == 52 && (paramConstraint = this.getParamConstraintTypeIfInferred(this.function, parameterizedType = (BParameterizedType)referredMember)) != this.symbolTable.noType && !this.isDisjointMemberType(parameterizedType, originalType)) {
                this.dlog.error(this.function.returnTypeNode.pos, DiagnosticErrorCode.INVALID_DEPENDENTLY_TYPED_RETURN_TYPE_WITH_INFERRED_TYPEDESC_PARAM, new Object[0]);
                return originalType;
            }
            BType newMember = member.accept(this, this.getExpectedTypeForInferredTypedescMember(originalType, expType, member));
            if (this.isInvocation) {
                if (newMember == this.symbolTable.semanticError) {
                    return this.symbolTable.semanticError;
                }
                if (newMember == member && Symbols.isFlagOn(member.getFlags(), 0x4000000L)) {
                    return expType;
                }
            }
            newMemberTypes.add(newMember);
            if (this.isSameTypeOrError(newMember, member)) continue;
            hasNewType = true;
        }
        if (!hasNewType) {
            return originalType;
        }
        BUnionType type = BUnionType.create(originalType.env, null, newMemberTypes);
        this.setFlags(type, originalType.getFlags());
        return type;
    }

    @Override
    public BType visit(BIntersectionType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expEffectiveType = matchingType == null ? null : ((BIntersectionType)matchingType).effectiveType;
        BType newEffectiveType = originalType.effectiveType.accept(this, expEffectiveType);
        if (this.isSameType(newEffectiveType, originalType.effectiveType)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newEffectiveType)) {
            return this.symbolTable.semanticError;
        }
        BIntersectionType type = new BIntersectionType(null, (LinkedHashSet)originalType.getConstituentTypes(), newEffectiveType);
        this.setFlags(type, originalType.getFlags());
        return originalType;
    }

    @Override
    public BType visit(BErrorType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BFutureType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expConstraint = matchingType == null ? null : ((BFutureType)expType).constraint;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        if (this.isSameType(newConstraint, originalType.constraint)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint)) {
            return this.symbolTable.semanticError;
        }
        BFutureType newFutureType = new BFutureType(this.typeEnv, newConstraint, null, originalType.workerDerivative);
        this.setFlags(newFutureType, originalType.getFlags());
        return newFutureType;
    }

    @Override
    public BType visit(BFiniteType originalType, BType expType) {
        return originalType;
    }

    @Override
    public BType visit(BTypedescType originalType, BType expType) {
        BType matchingType = this.getMatchingTypeForInferrableType(originalType, expType);
        BType expConstraint = matchingType == null ? null : ((BTypedescType)expType).constraint;
        BType newConstraint = originalType.constraint.accept(this, expConstraint);
        if (this.isSameType(newConstraint, originalType.constraint)) {
            return originalType;
        }
        if (this.isSemanticErrorInInvocation(newConstraint)) {
            return this.symbolTable.semanticError;
        }
        BTypedescType newTypedescType = new BTypedescType(this.typeEnv, newConstraint, null);
        this.setFlags(newTypedescType, originalType.getFlags());
        return newTypedescType;
    }

    @Override
    public BType visit(BParameterizedType originalType, BType expType) {
        BType type;
        String paramVarName = originalType.paramSymbol.name.value;
        if (Symbols.isFlagOn(originalType.paramSymbol.flags, 0x10000000000L)) {
            BTypedescType paramSymbolTypedescType = (BTypedescType)this.getConstraintFromReferenceType(originalType.paramSymbol.type);
            BType paramSymbolType = paramSymbolTypedescType.constraint;
            if (expType != null) {
                if (expType == this.symbolTable.noType) {
                    if (!this.paramValueTypes.containsKey(paramVarName)) {
                        this.logCannotInferTypedescArgumentError(paramVarName);
                        return this.symbolTable.semanticError;
                    }
                    BType type2 = this.paramValueTypes.get(paramVarName);
                    return type2.tag == 28 ? expType : ((BTypedescType)Types.getImpliedType((BType)type2)).constraint;
                }
                if (!this.types.isAssignable(expType, paramSymbolType)) {
                    if (!this.paramValueTypes.containsKey(paramVarName)) {
                        this.dlog.error(this.invocation.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_FOR_INFERRED_TYPEDESC_VALUE, paramVarName, paramSymbolTypedescType, new BTypedescType(this.typeEnv, expType, null));
                        return this.symbolTable.semanticError;
                    }
                    BType type3 = this.paramValueTypes.get(paramVarName);
                    return type3 == this.symbolTable.semanticError ? expType : ((BTypedescType)type3).constraint;
                }
                BType type4 = this.getTypeAddingArgIfNotProvided(originalType, expType);
                return type4 == this.symbolTable.semanticError ? expType : type4;
            }
            if (this.isInvocation) {
                if (this.paramValueTypes.containsKey(paramVarName)) {
                    return this.getConstraintTypeIfNotError(this.paramValueTypes.get(paramVarName));
                }
                this.logCannotInferTypedescArgumentError(paramVarName);
                return this.symbolTable.semanticError;
            }
            return paramSymbolType;
        }
        if (this.isInvocation) {
            type = this.paramValueTypes.get(paramVarName);
            if (type == null) {
                return originalType.paramValueType;
            }
            if (type.tag == 28) {
                return type;
            }
            type = ((BTypedescType)this.getConstraintFromReferenceType((BType)type)).constraint;
        } else {
            type = ((BTypedescType)this.getConstraintFromReferenceType((BType)originalType.paramSymbol.type)).constraint;
        }
        return type;
    }

    private void logCannotInferTypedescArgumentError(String paramName) {
        if (this.invocation.expectedType == this.symbolTable.noType) {
            this.dlog.error(this.invocation.pos, DiagnosticErrorCode.CANNOT_INFER_TYPEDESC_ARGUMENT_WITHOUT_CET, paramName);
        } else {
            this.dlog.error(this.invocation.pos, DiagnosticErrorCode.CANNOT_INFER_TYPEDESC_ARGUMENT_FROM_CET, paramName, this.invocation.expectedType, ((BInvokableSymbol)this.invocation.symbol).retType);
        }
    }

    public BType visit(BTypeReferenceType t, BType s) {
        return this.visit(this.getConstraintFromReferenceType(t), s);
    }

    private BType getConstraintFromReferenceType(BType type) {
        BType constraint = type;
        if (type.tag == 14) {
            constraint = this.getConstraintFromReferenceType(((BTypeReferenceType)type).referredType);
        }
        return constraint;
    }

    private BType getTypeAddingArgIfNotProvided(BParameterizedType originalType, BType expType) {
        BVarSymbol paramSymbol = originalType.paramSymbol;
        String paramName = paramSymbol.name.value;
        List<BLangExpression> requiredArgs = this.invocation.requiredArgs;
        for (BLangExpression arg : requiredArgs) {
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            BLangNamedArgsExpression namedArgsExpression = (BLangNamedArgsExpression)arg;
            if (!namedArgsExpression.name.value.equals(paramName)) continue;
            return this.getConstraintTypeIfNotError(namedArgsExpression.expr.getBType());
        }
        int index = this.getParamPosition(paramSymbol);
        List<BLangExpression> restArgs = this.invocation.restArgs;
        int requiredArgCount = requiredArgs.size();
        if (index < requiredArgCount) {
            BLangExpression argAtIndex = requiredArgs.get(index);
            if (argAtIndex.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                return this.getConstraintTypeIfNotError(argAtIndex.getBType());
            }
        } else if (!restArgs.isEmpty()) {
            BType restArgType = Types.getImpliedType(restArgs.get(0).getBType());
            if (restArgType.tag == 12) {
                return this.getConstraintTypeIfNotError(((BField)((BRecordType)restArgType).fields.get((Object)paramName)).type);
            }
            return this.getConstraintTypeIfNotError(((BTupleType)restArgType).getTupleTypes().get(index - requiredArgCount));
        }
        BLangNamedArgsExpression namedArg = this.createTypedescExprNamedArg(expType, paramName);
        this.invocation.argExprs.add(namedArg);
        this.invocation.requiredArgs.add(namedArg);
        return expType;
    }

    private BType getConstraintTypeIfNotError(BType type) {
        if (type == this.symbolTable.semanticError) {
            return type;
        }
        if (type.getKind() == TypeKind.TYPEREFDESC) {
            return ((BTypedescType)Types.getImpliedType((BType)type)).constraint;
        }
        return ((BTypedescType)type).constraint;
    }

    private BLangNamedArgsExpression createTypedescExprNamedArg(BType expType, String name) {
        BLangTypedescExpr typedescExpr = (BLangTypedescExpr)TreeBuilder.createTypeAccessNode();
        typedescExpr.pos = this.symbolTable.builtinPos;
        typedescExpr.resolvedType = expType;
        typedescExpr.setBType(new BTypedescType(this.typeEnv, expType, null));
        BLangNamedArgsExpression namedArgsExpression = (BLangNamedArgsExpression)TreeBuilder.createNamedArgNode();
        BLangIdentifier identifierNode = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        identifierNode.value = name;
        namedArgsExpression.name = identifierNode;
        namedArgsExpression.expr = typedescExpr;
        namedArgsExpression.pos = this.symbolTable.builtinPos;
        return namedArgsExpression;
    }

    private void createParamMap(BLangInvocation invocation) {
        this.paramValueTypes = new LinkedHashMap<String, BType>();
        BInvokableSymbol symbol = (BInvokableSymbol)invocation.symbol;
        List<BLangExpression> requiredArgs = invocation.requiredArgs;
        List<BVarSymbol> params = symbol.params;
        int argIndex = 0;
        List<BLangExpression> restArgs = invocation.restArgs;
        boolean hasRestArg = !restArgs.isEmpty() && restArgs.get(restArgs.size() - 1).getKind() == NodeKind.REST_ARGS_EXPR;
        for (int paramIndex = 0; paramIndex < params.size(); ++paramIndex) {
            if (argIndex < requiredArgs.size()) {
                BLangExpression arg = requiredArgs.get(argIndex);
                if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                    this.paramValueTypes.put(params.get((int)paramIndex).name.value, arg.getBType());
                    ++argIndex;
                    continue;
                }
                this.populateParamMapFromNamedArgs(symbol, params, requiredArgs, paramIndex, argIndex);
                return;
            }
            if (hasRestArg) {
                this.populateParamMapFromRestArg(params, paramIndex, restArgs.get(restArgs.size() - 1));
                return;
            }
            BVarSymbol param = params.get(paramIndex);
            String paramName = param.name.value;
            if (!param.isDefaultable || Symbols.isFlagOn(param.flags, 0x10000000000L)) continue;
            this.paramValueTypes.put(paramName, symbol.paramDefaultValTypes.get(paramName));
        }
    }

    private void populateParamMapFromNamedArgs(BInvokableSymbol symbol, List<BVarSymbol> params, List<BLangExpression> requiredArgs, int currentParamIndex, int currentArgIndex) {
        for (int paramIndex = currentParamIndex; paramIndex < params.size(); ++paramIndex) {
            BVarSymbol param = params.get(paramIndex);
            if (Symbols.isFlagOn(param.flags, 0x400000000L)) continue;
            String name = param.name.value;
            boolean argProvided = false;
            for (int argIndex = currentArgIndex; argIndex < requiredArgs.size(); ++argIndex) {
                BLangNamedArgsExpression namedArg = (BLangNamedArgsExpression)requiredArgs.get(argIndex);
                if (!name.equals(namedArg.name.value)) continue;
                this.paramValueTypes.put(name, namedArg.getBType());
                argProvided = true;
                break;
            }
            if (argProvided || !param.isDefaultable || Symbols.isFlagOn(param.flags, 0x10000000000L)) continue;
            this.paramValueTypes.put(name, symbol.paramDefaultValTypes.get(name));
        }
    }

    private void populateParamMapFromRestArg(List<BVarSymbol> params, int currentParamIndex, BLangExpression restArg) {
        BType type = Types.getImpliedType(restArg.getBType());
        int tag = type.tag;
        if (tag == 12) {
            this.populateParamMapFromRecordRestArg(params, currentParamIndex, (BRecordType)type);
            return;
        }
        if (tag == 20) {
            this.populateParamMapFromArrayRestArg(params, currentParamIndex, (BArrayType)type);
            return;
        }
        this.populateParamMapFromTupleRestArg(params, currentParamIndex, (BTupleType)type);
    }

    private void populateParamMapFromRecordRestArg(List<BVarSymbol> params, int currentParamIndex, BRecordType recordType) {
        for (int i = currentParamIndex; i < params.size(); ++i) {
            String paramName = params.get((int)i).name.value;
            this.paramValueTypes.put(paramName, ((BField)recordType.fields.get((Object)paramName)).type);
        }
    }

    private void populateParamMapFromArrayRestArg(List<BVarSymbol> params, int currentParamIndex, BArrayType arrayType) {
        BType elementType = arrayType.eType;
        for (int i = currentParamIndex; i < params.size(); ++i) {
            this.paramValueTypes.put(params.get((int)i).name.value, elementType);
        }
    }

    private void populateParamMapFromTupleRestArg(List<BVarSymbol> params, int currentParamIndex, BTupleType tupleType) {
        int tupleIndex = 0;
        List<BType> tupleTypes = tupleType.getTupleTypes();
        for (int i = currentParamIndex; i < params.size(); ++i) {
            this.paramValueTypes.put(params.get((int)i).name.value, tupleTypes.get(tupleIndex++));
        }
    }

    private void setFlags(BType type, long originalFlags) {
        type.setFlags(originalFlags & 0xFFFFFFFFFBFFFFFFL);
    }

    private int getParamPosition(BVarSymbol sym) {
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.invocation.symbol;
        List<BVarSymbol> params = invokableSymbol.params;
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol param = params.get(i);
            if (!param.equals(sym)) continue;
            return i;
        }
        throw new IllegalStateException(String.format("Param '%s' not found in function '%s'", sym.name, invokableSymbol.name));
    }

    private BType getParamConstraintTypeIfInferred(BLangFunction function, BParameterizedType parameterizedType) {
        String paramName = parameterizedType.paramSymbol.name.value;
        for (BLangSimpleVariable requiredParam : function.requiredParams) {
            if (!requiredParam.name.value.equals(paramName)) continue;
            BLangExpression expr = requiredParam.expr;
            if (expr == null || expr.getKind() != NodeKind.INFER_TYPEDESC_EXPR) {
                return this.symbolTable.noType;
            }
            BType paramType = Types.getImpliedType(requiredParam.getBType());
            if (paramType.tag != 13) {
                return this.symbolTable.noType;
            }
            return ((BTypedescType)paramType).constraint;
        }
        return this.symbolTable.noType;
    }

    private boolean isDisjointMemberType(BParameterizedType parameterizedType, BUnionType unionType) {
        BType paramValueType = Types.getImpliedType(parameterizedType.paramValueType);
        if (paramValueType.tag == 21) {
            return this.isDisjoint((BUnionType)paramValueType, unionType, parameterizedType);
        }
        for (BType memberType : unionType.getMemberTypes()) {
            if (memberType == parameterizedType || !this.hasSameBasicType(paramValueType, memberType) && !this.hasIntersection(paramValueType, memberType)) continue;
            return false;
        }
        return true;
    }

    private boolean isDisjoint(BUnionType t1, BUnionType t2, BParameterizedType parameterizedType) {
        for (BType memType1 : t1.getMemberTypes()) {
            for (BType memType2 : t2.getMemberTypes()) {
                if (memType2 == parameterizedType || !this.hasSameBasicType(memType1, memType2) && !this.hasIntersection(memType1, memType2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasIntersection(BType t1, BType t2) {
        BType typeIntersection = this.types.getTypeIntersection(Types.IntersectionContext.compilerInternalIntersectionContext(), t1, t2, this.env);
        return typeIntersection != null && typeIntersection != this.symbolTable.semanticError;
    }

    private boolean hasSameBasicType(BType t1, BType t2) {
        int tag1 = Types.getImpliedType((BType)t1).tag;
        int tag2 = Types.getImpliedType((BType)t2).tag;
        if (tag1 == tag2) {
            return true;
        }
        if (TypeTags.isIntegerTypeTag(tag1) != TypeTags.isIntegerTypeTag(tag2)) {
            return false;
        }
        if (TypeTags.isStringTypeTag(tag1) != TypeTags.isStringTypeTag(tag2)) {
            return false;
        }
        if (TypeTags.isXMLTypeTag(tag1) != TypeTags.isXMLTypeTag(tag2)) {
            return false;
        }
        if (this.isMappingType(tag1) != this.isMappingType(tag2)) {
            return false;
        }
        return this.isListType(tag1) && this.isListType(tag2);
    }

    private boolean isMappingType(int tag) {
        return tag == 16 || tag == 12;
    }

    private boolean isListType(int tag) {
        return tag == 20 || tag == 31;
    }

    private BType getMatchingTypeForInferrableType(BType originalType, BType expType) {
        if (expType == null || !this.isInvocation) {
            return null;
        }
        List<String> paramsWithInferredTypedescDefault = this.getParamsWithInferredTypedescDefault(((BInvokableSymbol)this.invocation.symbol).params);
        if (paramsWithInferredTypedescDefault.isEmpty()) {
            return null;
        }
        ArrayList<BType> inferableTypes = new ArrayList<BType>();
        BType referredOriginalType = Types.getImpliedType(originalType);
        if (referredOriginalType.tag == 21) {
            for (BType memberType : ((BUnionType)referredOriginalType).getMemberTypes()) {
                if (!Symbols.isFlagOn(memberType.getFlags(), 0x4000000L) || !this.refersInferableParamName(paramsWithInferredTypedescDefault, memberType)) continue;
                inferableTypes.add(memberType);
            }
        } else if (this.refersInferableParamName(paramsWithInferredTypedescDefault, originalType)) {
            inferableTypes.add(originalType);
        }
        if (inferableTypes.isEmpty()) {
            return null;
        }
        expType = Types.getImpliedType(expType);
        Set expectedTypes = expType.tag == 21 ? ((BUnionType)expType).getMemberTypes() : Set.of(expType);
        LinkedHashSet<BType> matchedTypes = new LinkedHashSet<BType>();
        for (BType inferableType : inferableTypes) {
            for (BType expectedType : expectedTypes) {
                expectedType = Types.getImpliedType(expectedType);
                if (Types.getImpliedType((BType)inferableType).tag != expectedType.tag) continue;
                matchedTypes.add(expectedType);
            }
        }
        if (matchedTypes.size() == 1) {
            return (BType)matchedTypes.iterator().next();
        }
        return null;
    }

    public boolean refersInferableParamName(String paramWithInferredTypedescDefault, BType type) {
        return this.refersInferableParamName(List.of(paramWithInferredTypedescDefault), type, new HashSet<BType>());
    }

    private boolean refersInferableParamName(List<String> paramsWithInferredTypedescDefault, BType type) {
        return this.refersInferableParamName(paramsWithInferredTypedescDefault, type, new HashSet<BType>());
    }

    private boolean refersInferableParamName(List<String> paramsWithInferredTypedescDefault, BType type, Set<BType> unresolvedTypes) {
        if (!unresolvedTypes.add(type)) {
            return false;
        }
        type = Types.getReferredType(type);
        switch (type.tag) {
            case 52: {
                String paramName = ((BParameterizedType)type).paramSymbol.name.value;
                return paramsWithInferredTypedescDefault.contains(paramName);
            }
            case 8: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BXMLType)type).constraint, unresolvedTypes);
            }
            case 9: {
                BTableType tableType = (BTableType)type;
                if (this.refersInferableParamName(paramsWithInferredTypedescDefault, tableType.constraint, unresolvedTypes)) {
                    return true;
                }
                BType keyTypeConstraint = tableType.keyTypeConstraint;
                if (keyTypeConstraint == null) {
                    return false;
                }
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, keyTypeConstraint, unresolvedTypes);
            }
            case 13: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BTypedescType)type).constraint, unresolvedTypes);
            }
            case 15: {
                BStreamType streamType = (BStreamType)type;
                if (this.refersInferableParamName(paramsWithInferredTypedescDefault, streamType.constraint, unresolvedTypes)) {
                    return true;
                }
                BType completionType = streamType.completionType;
                if (completionType == null) {
                    return false;
                }
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, completionType, unresolvedTypes);
            }
            case 17: {
                if (Symbols.isFlagOn(type.getFlags(), 0x8000000000L)) {
                    return false;
                }
                BInvokableType invokableType = (BInvokableType)type;
                for (BType paramType : invokableType.paramTypes) {
                    if (!this.refersInferableParamName(paramsWithInferredTypedescDefault, paramType, unresolvedTypes)) continue;
                    return true;
                }
                BType funcRestType = invokableType.restType;
                if (funcRestType != null && this.refersInferableParamName(paramsWithInferredTypedescDefault, funcRestType, unresolvedTypes)) {
                    return true;
                }
                BType funcRetType = invokableType.retType;
                if (funcRetType == null) {
                    return false;
                }
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, funcRetType, unresolvedTypes);
            }
            case 20: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BArrayType)type).eType, unresolvedTypes);
            }
            case 21: {
                for (BType unionMemType : ((BUnionType)type).getMemberTypes()) {
                    if (!this.refersInferableParamName(paramsWithInferredTypedescDefault, unionMemType, unresolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 22: {
                for (BType intersectionMemType : ((BIntersectionType)type).getConstituentTypes()) {
                    if (!this.refersInferableParamName(paramsWithInferredTypedescDefault, intersectionMemType, unresolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 16: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BMapType)type).constraint, unresolvedTypes);
            }
            case 29: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BErrorType)type).detailType, unresolvedTypes);
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                for (BType tupleMember : tupleType.getTupleTypes()) {
                    if (!this.refersInferableParamName(paramsWithInferredTypedescDefault, tupleMember, unresolvedTypes)) continue;
                    return true;
                }
                BType tupleRestType = tupleType.restType;
                if (tupleRestType == null) {
                    return false;
                }
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, tupleRestType, unresolvedTypes);
            }
            case 32: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, ((BFutureType)type).constraint, unresolvedTypes);
            }
            case 14: {
                return this.refersInferableParamName(paramsWithInferredTypedescDefault, Types.getImpliedType(type), unresolvedTypes);
            }
        }
        return false;
    }

    private List<String> getParamsWithInferredTypedescDefault(List<BVarSymbol> params) {
        ArrayList<String> paramsWithInferredTypedescDefault = new ArrayList<String>();
        for (BVarSymbol param : params) {
            if (!Symbols.isFlagOn(param.flags, 0x10000000000L)) continue;
            paramsWithInferredTypedescDefault.add(param.name.value);
        }
        return paramsWithInferredTypedescDefault;
    }

    private BType getExpectedTypeForInferredTypedescMember(BUnionType originalType, BType expType, BType member) {
        if (expType == null || !this.isInvocation || !Symbols.isFlagOn(member.getFlags(), 0x4000000L)) {
            return null;
        }
        BType impliedExpType = Types.getImpliedType(expType);
        if (impliedExpType.tag != 21) {
            return expType;
        }
        BUnionType expUnionType = (BUnionType)impliedExpType;
        LinkedHashSet<BType> types = new LinkedHashSet<BType>();
        for (BType expMemType : expUnionType.getMemberTypes()) {
            boolean hasMatchWithOtherType = false;
            for (BType origMemType : originalType.getMemberTypes()) {
                if (origMemType == member || !this.hasSameBasicType(expMemType, origMemType)) continue;
                hasMatchWithOtherType = true;
                break;
            }
            if (hasMatchWithOtherType) continue;
            types.add(expMemType);
        }
        if (types.isEmpty()) {
            return null;
        }
        LinkedHashSet<BType> expectedTypesSet = new LinkedHashSet<BType>();
        for (BType originalMemberType : expUnionType.getOriginalMemberTypes()) {
            LinkedHashSet<BType> flatTypeSet = BUnionType.toFlatTypeSet(new LinkedHashSet<BType>(Set.of(originalMemberType)));
            Set typesToAdd = flatTypeSet.stream().filter(types::contains).collect(Collectors.toSet());
            if (typesToAdd.containsAll(flatTypeSet)) {
                expectedTypesSet.add(originalMemberType);
                continue;
            }
            expectedTypesSet.addAll(typesToAdd);
        }
        if (expectedTypesSet.size() == 1) {
            return (BType)expectedTypesSet.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, expectedTypesSet);
    }

    private boolean isSameTypeOrError(BType newType, BType originalType) {
        return this.isSameType(newType, originalType) || this.isSemanticErrorInInvocation(newType);
    }

    private boolean isSameType(BType newType, BType originalType) {
        return newType == originalType;
    }

    private boolean isSemanticErrorInInvocation(BType newType) {
        return this.isInvocation && newType == this.symbolTable.semanticError;
    }

    private void resetBuildArgs() {
        this.visitedTypes = new HashSet<BType>();
        this.paramValueTypes = null;
        this.isInvocation = false;
    }

    private void resetValidateArgs() {
        this.visitedTypes = new HashSet<BType>();
        this.function = null;
        this.env = null;
    }
}

