/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import io.ballerina.projects.Settings;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.SettingsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public final class RepoUtils {
    public static final String BALLERINA_INSTALL_DIR_PROP = "ballerina.home";
    public static final String COMPILE_BALLERINA_ORG_PROP = "BALLERINA_DEV_COMPILE_BALLERINA_ORG";
    public static final String LOAD_BUILTIN_FROM_SOURCE_PROP = "BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE";
    public static final boolean COMPILE_BALLERINA_ORG = RepoUtils.getBooleanProp("BALLERINA_DEV_COMPILE_BALLERINA_ORG");
    public static final boolean LOAD_BUILTIN_FROM_SOURCE = RepoUtils.getBooleanProp("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE");
    private static final String USER_HOME = "user.home";
    private static final String DEFAULT_TERMINAL_SIZE = "80";
    private static final String BALLERINA_CLI_WIDTH = "BALLERINA_CLI_WIDTH";
    private static final String PRODUCTION_URL = "https://api.central.ballerina.io/2.0/registry";
    private static final String STAGING_URL = "https://api.staging-central.ballerina.io/2.0/registry";
    private static final String DEV_URL = "https://api.dev-central.ballerina.io/2.0/registry";
    private static final String PRODUCTION_GRAPHQL_URL = "https://api.central.ballerina.io/2.0/graphql";
    private static final String STAGING_GRAPHQL_URL = "https://api.staging-central.ballerina.io/2.0/graphql";
    private static final String DEV_GRAPHQL_URL = "https://api.dev-central.ballerina.io/2.0/graphql";
    private static final String BALLERINA_ORG = "ballerina";
    private static final String BALLERINAX_ORG = "ballerinax";
    public static final String BALLERINA_STAGE_CENTRAL = "BALLERINA_STAGE_CENTRAL";
    public static final String BALLERINA_DEV_CENTRAL = "BALLERINA_DEV_CENTRAL";
    public static final boolean SET_BALLERINA_STAGE_CENTRAL = Boolean.parseBoolean(System.getenv("BALLERINA_STAGE_CENTRAL"));
    public static final boolean SET_BALLERINA_DEV_CENTRAL = Boolean.parseBoolean(System.getenv("BALLERINA_DEV_CENTRAL"));
    private static final String UNKNOWN = "unknown";

    private RepoUtils() {
    }

    public static Path createAndGetHomeReposPath() {
        Path homeRepoPath;
        String homeRepoDir = System.getenv("BALLERINA_HOME_DIR");
        if (homeRepoDir == null || homeRepoDir.isEmpty()) {
            String userHomeDir = System.getProperty(USER_HOME);
            if (userHomeDir == null || userHomeDir.isEmpty()) {
                throw new BLangCompilerException("Error creating home repository: unable to get user home directory");
            }
            homeRepoPath = Path.of(userHomeDir, ".ballerina");
        } else {
            homeRepoPath = Path.of(homeRepoDir, new String[0]);
        }
        homeRepoPath = homeRepoPath.toAbsolutePath();
        if (Files.exists(homeRepoPath, new LinkOption[0]) && !Files.isDirectory(homeRepoPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new BLangCompilerException("Home repository is not a directory: " + homeRepoPath.toString());
        }
        return homeRepoPath;
    }

    public static boolean isBallerinaProject(Path sourceRoot) {
        Path manifest = sourceRoot.resolve("Ballerina.toml");
        return Files.isDirectory(sourceRoot, new LinkOption[0]) && Files.exists(manifest, new LinkOption[0]) && Files.isRegularFile(manifest, new LinkOption[0]);
    }

    public static boolean isBallerinaStandaloneFile(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        if (!file.toString().endsWith(".bal")) {
            return false;
        }
        Path projectRoot = ProjectDirs.findProjectRoot(file.getParent());
        if (null != projectRoot) {
            Path src = projectRoot.resolve("src");
            for (Path parent = file.getParent(); parent != null; parent = parent.getParent()) {
                if (!src.equals(parent)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static String getRemoteRepoURL() {
        if (SET_BALLERINA_STAGE_CENTRAL) {
            return STAGING_URL;
        }
        if (SET_BALLERINA_DEV_CENTRAL) {
            return DEV_URL;
        }
        return PRODUCTION_URL;
    }

    public static String getRemoteRepoGraphQLURL() {
        if (SET_BALLERINA_STAGE_CENTRAL) {
            return STAGING_GRAPHQL_URL;
        }
        if (SET_BALLERINA_DEV_CENTRAL) {
            return DEV_GRAPHQL_URL;
        }
        return PRODUCTION_GRAPHQL_URL;
    }

    public static String getStagingURL() {
        return STAGING_URL;
    }

    public static Path getLibDir() {
        return Path.of(System.getProperty(BALLERINA_INSTALL_DIR_PROP, "."), new String[0]).resolve("lib");
    }

    public static String getTerminalWidth() {
        Map<String, String> envVariableMap = System.getenv();
        if (envVariableMap.containsKey(BALLERINA_CLI_WIDTH)) {
            return envVariableMap.get(BALLERINA_CLI_WIDTH);
        }
        return DEFAULT_TERMINAL_SIZE;
    }

    public static Path createAndGetLibsRepoPath() {
        String ballerinaHome = System.getProperty(BALLERINA_INSTALL_DIR_PROP);
        if (ballerinaHome == null || ballerinaHome.isEmpty()) {
            return null;
        }
        return Path.of(ballerinaHome, new String[0]).resolve("lib");
    }

    private static boolean getBooleanProp(String key) {
        return Boolean.parseBoolean(System.getProperty(key));
    }

    public static String getBallerinaVersion() {
        String string;
        block8: {
            InputStream inputStream = RepoUtils.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("ballerina.version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return UNKNOWN;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String getBallerinaPackVersion() {
        String string;
        block8: {
            InputStream inputStream = RepoUtils.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("ballerina.packVersion");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return UNKNOWN;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String getBallerinaShortVersion() {
        String string;
        block8: {
            InputStream inputStream = RepoUtils.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("ballerina.version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return UNKNOWN;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String getBallerinaSpecVersion() {
        String string;
        block8: {
            InputStream inputStream = RepoUtils.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("spec.version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return UNKNOWN;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static boolean validateOrg(String orgName) {
        String validRegex = "^[a-z0-9_]*$";
        return Pattern.matches(validRegex, orgName);
    }

    public static boolean validatePkg(String pkgName) {
        String validRegex = "^[a-zA-Z0-9_.]*$";
        return Pattern.matches(validRegex, pkgName);
    }

    public static boolean validateModuleName(String pkgName) {
        String validRegex = "^[a-zA-Z0-9_.]*$";
        return Pattern.matches(validRegex, pkgName);
    }

    public static boolean isReservedOrgName(String orgName) {
        return orgName.equals(BALLERINA_ORG) || orgName.equals(BALLERINAX_ORG);
    }

    public static boolean isANightlyBuild() {
        return RepoUtils.getBallerinaPackVersion().contains("SNAPSHOT");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifestFromBala(Path balaPath) {
        try (JarFile jar = new JarFile(balaPath.toString());){
            Manifest manifest;
            JarEntry file;
            Enumeration<JarEntry> enumEntries = jar.entries();
            do {
                if (!enumEntries.hasMoreElements()) throw new BLangCompilerException("unable to find '/metadata/Ballerina.toml' file in bala file: " + String.valueOf(balaPath));
            } while (!(file = enumEntries.nextElement()).getName().contains("Ballerina.toml") || file.isDirectory());
            try (InputStream is = jar.getInputStream(file);){
                manifest = ManifestProcessor.parseTomlContentAsStream(is);
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException e) {
            throw new BLangCompilerException("unable to read bala file: " + String.valueOf(balaPath) + ". bala file seems to be corrupted.");
        }
        catch (TomlException e) {
            throw new BLangCompilerException("unable to read bala file: " + String.valueOf(balaPath) + ". bala file seems to be corrupted: " + e.getMessage());
        }
    }

    public static Settings readSettings() {
        Path settingsFilePath = RepoUtils.createAndGetHomeReposPath().resolve("Settings.toml");
        try {
            TomlDocument settingsTomlDocument = TomlDocument.from(String.valueOf(settingsFilePath.getFileName()), Files.readString(settingsFilePath));
            SettingsBuilder settingsBuilder = SettingsBuilder.from(settingsTomlDocument);
            return settingsBuilder.settings();
        }
        catch (IOException e) {
            return Settings.from();
        }
    }
}

