/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.compiler;

import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.constraint.compiler.ConstraintCompilerPluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;
import java.util.Optional;

public class RecordFieldConstraintValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        boolean erroneousCompilation = diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (erroneousCompilation) {
            return;
        }
        RecordFieldNode recordFieldNode = (RecordFieldNode)syntaxNodeAnalysisContext.node();
        this.validateRecordFieldConstraints(syntaxNodeAnalysisContext, recordFieldNode);
    }

    private void validateRecordFieldConstraints(SyntaxNodeAnalysisContext ctx, RecordFieldNode recordFieldNode) {
        Optional optionalMetadataNode = recordFieldNode.metadata();
        if (optionalMetadataNode.isEmpty()) {
            return;
        }
        NodeList annotationNodes = ((MetadataNode)optionalMetadataNode.get()).annotations();
        Optional optionalTypeSymbol = ctx.semanticModel().symbol((Node)recordFieldNode);
        if (optionalTypeSymbol.isEmpty() || !(optionalTypeSymbol.get() instanceof RecordFieldSymbol)) {
            return;
        }
        RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)optionalTypeSymbol.get();
        TypeSymbol fieldTypeSymbol = recordFieldSymbol.typeDescriptor();
        Node typeNode = recordFieldNode.typeName();
        String fieldType = typeNode.kind().equals((Object)SyntaxKind.RECORD_TYPE_DESC) ? "record" : typeNode.toString().trim();
        ConstraintCompilerPluginUtils.validateConstraints(ctx, (NodeList<AnnotationNode>)annotationNodes, fieldType, fieldTypeSymbol);
    }
}

