/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.InlineTableNode;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.LiteralStringLiteralNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Arrays;
import java.util.function.Function;

public abstract class TreeModifier
extends NodeTransformer<Node> {
    @Override
    public DocumentNode transform(DocumentNode documentNode) {
        NodeList<DocumentMemberDeclarationNode> members = this.modifyNodeList(documentNode.members());
        Token eofToken = this.modifyToken(documentNode.eofToken());
        return documentNode.modify(members, eofToken);
    }

    @Override
    public TableNode transform(TableNode tableNode) {
        Token openBracket = this.modifyToken(tableNode.openBracket());
        KeyNode identifier = this.modifyNode(tableNode.identifier());
        Token closeBracket = this.modifyToken(tableNode.closeBracket());
        NodeList<KeyValueNode> fields = this.modifyNodeList(tableNode.fields());
        return tableNode.modify(openBracket, identifier, closeBracket, fields);
    }

    @Override
    public TableArrayNode transform(TableArrayNode tableArrayNode) {
        Token firstOpenBracket = this.modifyToken(tableArrayNode.firstOpenBracket());
        Token secondOpenBracket = this.modifyToken(tableArrayNode.secondOpenBracket());
        KeyNode identifier = this.modifyNode(tableArrayNode.identifier());
        Token firstCloseBracket = this.modifyToken(tableArrayNode.firstCloseBracket());
        Token secondCloseBracket = this.modifyToken(tableArrayNode.secondCloseBracket());
        NodeList<KeyValueNode> fields = this.modifyNodeList(tableArrayNode.fields());
        return tableArrayNode.modify(firstOpenBracket, secondOpenBracket, identifier, firstCloseBracket, secondCloseBracket, fields);
    }

    @Override
    public KeyValueNode transform(KeyValueNode keyValueNode) {
        KeyNode identifier = this.modifyNode(keyValueNode.identifier());
        Token assign = this.modifyToken(keyValueNode.assign());
        ValueNode value = this.modifyNode(keyValueNode.value());
        return keyValueNode.modify(identifier, assign, value);
    }

    @Override
    public ArrayNode transform(ArrayNode arrayNode) {
        Token openBracket = this.modifyToken(arrayNode.openBracket());
        SeparatedNodeList<ValueNode> value = this.modifySeparatedNodeList(arrayNode.value());
        Token closeBracket = this.modifyToken(arrayNode.closeBracket());
        return arrayNode.modify(openBracket, value, closeBracket);
    }

    @Override
    public InlineTableNode transform(InlineTableNode inlineTableNode) {
        Token openBrace = this.modifyToken(inlineTableNode.openBrace());
        SeparatedNodeList<KeyValueNode> values = this.modifySeparatedNodeList(inlineTableNode.values());
        Token closeBrace = this.modifyToken(inlineTableNode.closeBrace());
        return inlineTableNode.modify(openBrace, values, closeBrace);
    }

    @Override
    public StringLiteralNode transform(StringLiteralNode stringLiteralNode) {
        Token startDoubleQuote = this.modifyToken(stringLiteralNode.startDoubleQuote());
        Token content = this.modifyToken(stringLiteralNode.content().orElse(null));
        Token endDoubleQuote = this.modifyToken(stringLiteralNode.endDoubleQuote());
        return stringLiteralNode.modify(startDoubleQuote, content, endDoubleQuote);
    }

    @Override
    public LiteralStringLiteralNode transform(LiteralStringLiteralNode literalStringLiteralNode) {
        Token startSingleQuote = this.modifyToken(literalStringLiteralNode.startSingleQuote());
        Token content = this.modifyToken(literalStringLiteralNode.content().orElse(null));
        Token endSingleQuote = this.modifyToken(literalStringLiteralNode.endSingleQuote());
        return literalStringLiteralNode.modify(startSingleQuote, content, endSingleQuote);
    }

    @Override
    public NumericLiteralNode transform(NumericLiteralNode numericLiteralNode) {
        Token sign = this.modifyToken(numericLiteralNode.sign().orElse(null));
        Token value = this.modifyToken(numericLiteralNode.value());
        return numericLiteralNode.modify(numericLiteralNode.kind(), sign, value);
    }

    @Override
    public BoolLiteralNode transform(BoolLiteralNode boolLiteralNode) {
        Token value = this.modifyToken(boolLiteralNode.value());
        return boolLiteralNode.modify(value);
    }

    @Override
    public IdentifierLiteralNode transform(IdentifierLiteralNode identifierLiteralNode) {
        IdentifierToken value = this.modifyNode(identifierLiteralNode.value());
        return identifierLiteralNode.modify(value);
    }

    @Override
    public KeyNode transform(KeyNode keyNode) {
        SeparatedNodeList<ValueNode> value = this.modifySeparatedNodeList(keyNode.value());
        return keyNode.modify(value);
    }

    @Override
    public Token transform(Token token) {
        return token;
    }

    @Override
    public IdentifierToken transform(IdentifierToken identifier) {
        return identifier;
    }

    @Override
    protected Node transformSyntaxNode(Node node) {
        return node;
    }

    protected <T extends Node> NodeList<T> modifyNodeList(NodeList<T> nodeList) {
        return this.modifyGenericNodeList(nodeList, NodeList::new);
    }

    protected <T extends Node> SeparatedNodeList<T> modifySeparatedNodeList(SeparatedNodeList<T> nodeList) {
        Function<NonTerminalNode, SeparatedNodeList> nodeListCreator = SeparatedNodeList::new;
        if (nodeList.isEmpty()) {
            return nodeList;
        }
        boolean nodeModified = false;
        STNode[] newSTNodes = new STNode[nodeList.internalListNode.size()];
        for (int index = 0; index < nodeList.size(); ++index) {
            Token newSeperator;
            T newNode;
            T oldNode = nodeList.get(index);
            if (oldNode != (newNode = this.modifyNode(oldNode))) {
                nodeModified = true;
            }
            newSTNodes[2 * index] = ((Node)newNode).internalNode();
            if (index == nodeList.size() - 1) break;
            Token oldSeperator = nodeList.getSeparator(index);
            if (oldSeperator != (newSeperator = this.modifyToken(oldSeperator))) {
                nodeModified = true;
            }
            newSTNodes[2 * index + 1] = newSeperator.internalNode();
        }
        if (!nodeModified) {
            return nodeList;
        }
        STNode stNodeList = STNodeFactory.createNodeList(Arrays.asList(newSTNodes));
        return nodeListCreator.apply((NonTerminalNode)stNodeList.createUnlinkedFacade());
    }

    private <T extends Node, N extends NodeList<T>> N modifyGenericNodeList(N nodeList, Function<NonTerminalNode, N> nodeListCreator) {
        if (nodeList.isEmpty()) {
            return nodeList;
        }
        boolean nodeModified = false;
        STNode[] newSTNodes = new STNode[nodeList.size()];
        for (int index = 0; index < nodeList.size(); ++index) {
            T newNode;
            T oldNode = nodeList.get(index);
            if (oldNode != (newNode = this.modifyNode(oldNode))) {
                nodeModified = true;
            }
            newSTNodes[index] = ((Node)newNode).internalNode();
        }
        if (!nodeModified) {
            return nodeList;
        }
        STNode stNodeList = STNodeFactory.createNodeList(Arrays.asList(newSTNodes));
        return (N)((NodeList)nodeListCreator.apply((NonTerminalNode)stNodeList.createUnlinkedFacade()));
    }

    protected <T extends Token> T modifyToken(T token) {
        if (token == null) {
            return null;
        }
        return (T)((Token)((Token)token).apply(this));
    }

    protected <T extends Node> T modifyNode(T node) {
        if (node == null) {
            return null;
        }
        return (T)node.apply(this);
    }
}

