/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.PrimitiveValueSchema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BooleanSchema
extends PrimitiveValueSchema<Boolean> {
    public BooleanSchema(Type type, Map<String, String> message, Boolean defaultValue, CompositionSchema comps, String description) {
        super(type, message, defaultValue, comps, description);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        if (givenValueNode.kind() != TomlType.BOOLEAN && !givenValueNode.isMissingNode()) {
            TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, ValidationUtil.getTypeErrorMessage(this, givenValueNode.kind(), key));
            return Collections.singletonList(diagnostic);
        }
        return super.validate(givenValueNode, key);
    }
}

