/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.SchemaDeserializer;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Schema
extends AbstractSchema {
    private final String schema;
    private final String title;
    private final boolean hasAdditionalProperties;
    private final Map<String, AbstractSchema> properties;
    private final List<String> required;
    private static final String PROPERTY_HOLDER = "${property}";

    public Schema(String schema, String title, Type type, Map<String, String> message, String description, boolean hasAdditionalProperties, Map<String, AbstractSchema> properties, List<String> required, CompositionSchema compositionSchemas) {
        super(type, message, compositionSchemas, description);
        this.schema = schema;
        this.title = title;
        this.hasAdditionalProperties = hasAdditionalProperties;
        this.properties = properties;
        this.required = required;
    }

    public static Schema from(Path jsonPath) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractSchema.class, (Object)new SchemaDeserializer()).create();
        BufferedReader reader = Files.newBufferedReader(jsonPath);
        return (Schema)gson.fromJson((Reader)reader, AbstractSchema.class);
    }

    public static Schema from(String jsonContent) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractSchema.class, (Object)new SchemaDeserializer()).create();
        return (Schema)gson.fromJson(jsonContent, AbstractSchema.class);
    }

    public boolean hasAdditionalProperties() {
        return this.hasAdditionalProperties;
    }

    public Map<String, AbstractSchema> properties() {
        return this.properties;
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    public List<String> required() {
        return this.required;
    }

    public String title() {
        return this.title;
    }

    public String schema() {
        return this.schema;
    }

    @Override
    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (givenValueNode.kind() == TomlType.INLINE_TABLE) {
            TomlInlineTableValueNode tomlInlineTableValueNode = (TomlInlineTableValueNode)givenValueNode;
            Map<String, AbstractSchema> properties = this.properties();
            List<String> requiredFields = this.getRequiredFields(this);
            for (TopLevelNode topLevelNode : tomlInlineTableValueNode.elements()) {
                String newKey = topLevelNode.key().name();
                AbstractSchema abstractSchema = properties.get(newKey);
                requiredFields.remove(newKey);
                if (abstractSchema != null || this.hasAdditionalProperties()) continue;
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TVE0001", "error.unexpected.property", DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(topLevelNode.location(), diagnosticInfo, this.getUnexpectedPropertyErrorMessage(newKey, key));
                diagnostics.add(diagnostic);
            }
            for (String field : requiredFields) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TVE0006", "error.required.field.missing", DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(tomlInlineTableValueNode.location(), diagnosticInfo, this.getRequiredErrorMessage(field));
                diagnostics.add(diagnostic);
            }
        } else if (givenValueNode.kind() == TomlType.TABLE) {
            TomlTableNode tomlTableNode = (TomlTableNode)givenValueNode;
            Map<String, AbstractSchema> properties = this.properties();
            List<String> requiredFields = this.getRequiredFields(this);
            Map<String, TopLevelNode> tableEntries = tomlTableNode.entries();
            for (Map.Entry<String, TopLevelNode> tableEntry : tableEntries.entrySet()) {
                String newKey = tableEntry.getKey();
                requiredFields.remove(newKey);
                TopLevelNode value = tableEntry.getValue();
                AbstractSchema schema = properties.get(newKey);
                if (schema != null || this.hasAdditionalProperties()) continue;
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TVE0001", "error.unexpected.property", DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(value.location(), diagnosticInfo, this.getUnexpectedPropertyErrorMessage(newKey, key));
                diagnostics.add(diagnostic);
            }
            for (String field : requiredFields) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TVE0006", "error.required.field.missing", DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(tomlTableNode.location(), diagnosticInfo, this.getRequiredErrorMessage(field));
                diagnostics.add(diagnostic);
            }
        } else {
            if (!givenValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, ValidationUtil.getTypeErrorMessage(this, givenValueNode.kind(), key));
                return Collections.singletonList(diagnostic);
            }
            return Collections.emptyList();
        }
        diagnostics.addAll(super.validate(givenValueNode, key));
        return diagnostics;
    }

    private List<String> getRequiredFields(Schema objectSchema) {
        if (objectSchema.required() == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(objectSchema.required());
    }

    private String getUnexpectedPropertyErrorMessage(String key, String parent) {
        Map<String, String> message = this.message();
        String typeCustomMessage = message.get("additionalProperties");
        if (parent == null) {
            parent = this.title();
        }
        if (typeCustomMessage == null) {
            return String.format("key '%s' not supported in schema '%s'", key, parent);
        }
        return typeCustomMessage.replace(PROPERTY_HOLDER, key);
    }

    private String getRequiredErrorMessage(String field) {
        Map<String, String> message = this.message();
        String typeCustomMessage = message.get("required");
        if (typeCustomMessage == null) {
            return "missing required field '" + field + "'";
        }
        return typeCustomMessage.replace(PROPERTY_HOLDER, field);
    }
}

