/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.extension;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.graphqlmodelgenerator.core.ModelGenerator;
import io.ballerina.graphqlmodelgenerator.core.exception.GraphqlModelGenerationException;
import io.ballerina.graphqlmodelgenerator.core.model.GraphqlModel;
import io.ballerina.graphqlmodelgenerator.extension.GraphqlDesignServiceRequest;
import io.ballerina.graphqlmodelgenerator.extension.GraphqlDesignServiceResponse;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="graphqlDesignService")
public class GraphqlModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<GraphqlDesignServiceResponse> getGraphqlModel(GraphqlDesignServiceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GraphqlDesignServiceResponse response = new GraphqlDesignServiceResponse();
            try {
                Path filePath = Path.of(request.getFilePath(), new String[0]);
                Project project = this.getCurrentProject(filePath);
                if (this.workspaceManager.semanticModel(filePath).isEmpty()) {
                    throw new GraphqlModelGenerationException("Provided Ballerina file path doesn't contain a valid semantic model");
                }
                SemanticModel semanticModel = (SemanticModel)this.workspaceManager.semanticModel(filePath).get();
                ModelGenerator modelGenerator = new ModelGenerator();
                GraphqlModel generatedModel = modelGenerator.getGraphqlModel(project, request.getLineRange(), semanticModel);
                Gson gson = new GsonBuilder().serializeNulls().create();
                JsonElement graphqlModelJson = gson.toJsonTree((Object)generatedModel);
                response.setGraphqlDesignModel(graphqlModelJson);
            }
            catch (GraphqlModelGenerationException | EventSyncException | WorkspaceDocumentException e) {
                response.setIncompleteModel(true);
                response.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                response.setIncompleteModel(true);
                response.setErrorMsg(String.format("Unexpected error occurred while generating GraphQL model : %s", e.getMessage()));
            }
            return response;
        });
    }

    private Project getCurrentProject(Path path) throws WorkspaceDocumentException, EventSyncException {
        Optional project = this.workspaceManager.project(path);
        if (project.isEmpty()) {
            return this.workspaceManager.loadProject(path);
        }
        return (Project)project.get();
    }
}

