/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.EnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.ObjectKind;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Type
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TypeKind kind;
    private final String description;
    private final Position position;
    private final Map<String, Field> fields;
    private final List<EnumValue> enumValues;
    private final List<Type> possibleTypes;
    private final List<Type> interfaces;
    private final List<InputValue> inputFields;
    private final Type ofType;
    private final ObjectKind objectKind;

    public Type(TypeKind kind, Type ofType) {
        this(null, kind, null, null, ofType);
    }

    public Type(String name, TypeKind kind) {
        this(name, kind, null);
    }

    public Type(String name, TypeKind kind, String description) {
        this(name, kind, description, null, (Type)null);
    }

    public Type(String name, TypeKind kind, String description, Position position) {
        this(name, kind, description, position, (Type)null);
    }

    public Type(String name, TypeKind kind, String description, Position position, ObjectKind objectKind) {
        this(name, kind, description, position, null, objectKind);
    }

    public Type(String name, TypeKind kind, String description, Position position, Type ofType) {
        this(name, kind, description, position, ofType, null);
    }

    private Type(String name, TypeKind kind, String description, Position position, Type ofType, ObjectKind objectKind) {
        this.name = TypeUtils.removeEscapeCharacter(name);
        this.kind = kind;
        this.description = description;
        this.position = position;
        this.fields = kind == TypeKind.OBJECT || kind == TypeKind.INTERFACE ? new LinkedHashMap<String, Field>() : null;
        this.enumValues = kind == TypeKind.ENUM ? new ArrayList() : null;
        this.possibleTypes = kind == TypeKind.INTERFACE || kind == TypeKind.UNION ? new ArrayList<Type>() : null;
        this.interfaces = kind == TypeKind.OBJECT || kind == TypeKind.INTERFACE ? new ArrayList<Type>() : null;
        this.inputFields = kind == TypeKind.INPUT_OBJECT ? new ArrayList() : null;
        this.ofType = ofType;
        this.objectKind = objectKind;
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public void addEnumValue(EnumValue enumValue) {
        this.enumValues.add(enumValue);
    }

    public void addPossibleType(Type type) {
        if (this.possibleTypes.contains(type)) {
            return;
        }
        this.possibleTypes.add(type);
    }

    public void addInterface(Type type) {
        if (this.interfaces.contains(type)) {
            return;
        }
        this.interfaces.add(type);
    }

    public void addInputField(InputValue inputValue) {
        this.inputFields.add(inputValue);
    }

    public String getName() {
        return this.name;
    }

    public TypeKind getKind() {
        return this.kind;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EnumValue> getEnumValues() {
        return this.enumValues;
    }

    public List<Type> getPossibleTypes() {
        return this.possibleTypes;
    }

    public List<Type> getInterfaces() {
        return this.interfaces;
    }

    public List<InputValue> getInputFields() {
        return this.inputFields;
    }

    public Type getOfType() {
        return this.ofType;
    }

    public ObjectKind getObjectKind() {
        return this.objectKind;
    }

    public Position getPosition() {
        return this.position;
    }
}

