/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.schema.generator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Annotatable;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Project;
import io.ballerina.stdlib.graphql.commons.types.DefaultDirective;
import io.ballerina.stdlib.graphql.commons.types.Description;
import io.ballerina.stdlib.graphql.commons.types.Directive;
import io.ballerina.stdlib.graphql.commons.types.EnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.ObjectKind;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.commons.utils.KeyDirectivesArgumentHolder;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GeneratorUtils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.IntrospectionTypeCreator;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class SchemaGenerator {
    private static final String IF_ARG_NAME = "if";
    private static final String ID_ANNOT_NAME = "ID";
    private static final String REASON_ARG_NAME = "reason";
    private static final String DEFAULT_VALUE = "\"\"";
    private static final String RESOLVE_REFERENCE = "resolveReference";
    private static final String KEY = "key";
    private static final String LIST_OPEN_BRACKET = "[";
    private static final String LIST_CLOSE_BRACKET = "]";
    private static final String INPUT_OBJECT_OPEN_BRACKET = "{";
    private static final String INPUT_OBJECT_CLOSE_BRACKET = "}";
    private static final String COMMA_SEPARATOR = ", ";
    private static final String COLON_SEPARATOR = " : ";
    private final Node serviceNode;
    private final InterfaceEntityFinder interfaceEntityFinder;
    private final Schema schema;
    private final SemanticModel semanticModel;
    private final FinderContext context;
    private final List<Type> visitedInterfaces;
    private final Project project;

    public SchemaGenerator(Node serviceNode, InterfaceEntityFinder interfaceEntityFinder, FinderContext context, String description, boolean isSubgraph) {
        this.serviceNode = serviceNode;
        this.interfaceEntityFinder = interfaceEntityFinder;
        this.schema = new Schema(description, isSubgraph);
        this.semanticModel = context.semanticModel();
        this.visitedInterfaces = new ArrayList<Type>();
        this.project = context.project();
        this.context = context;
    }

    public Schema generate() {
        this.findRootTypes(this.serviceNode);
        this.findIntrospectionTypes();
        this.addEntityKeyDirectives();
        this.addEntityTypes();
        return this.schema;
    }

    private void addEntityKeyDirectives() {
        if (!this.schema.isSubgraph()) {
            return;
        }
        for (Map.Entry<String, Symbol> entry : this.interfaceEntityFinder.getEntities().entrySet()) {
            AnnotationNode entityAnnotation;
            AnnotationSymbol entityAnnotationSymbol = Utils.getEntityAnnotationSymbol(entry.getValue());
            if (entityAnnotationSymbol == null || (entityAnnotation = Utils.getEntityAnnotationNode(entityAnnotationSymbol, entry.getKey(), this.context)) == null) continue;
            this.addKeyDirectiveArguments(entityAnnotation, entry.getKey());
        }
    }

    private void addKeyDirectiveArguments(AnnotationNode entityAnnotation, String entityName) {
        if (entityAnnotation.annotValue().isEmpty()) {
            return;
        }
        boolean isResolvable = false;
        ArrayList<String> keys = new ArrayList<String>();
        for (MappingFieldNode fieldNode : ((MappingConstructorExpressionNode)entityAnnotation.annotValue().get()).fields()) {
            SpecificFieldNode specificFieldNode;
            Node fieldNameNode;
            if (fieldNode.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldNameNode = (specificFieldNode = (SpecificFieldNode)fieldNode).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN) continue;
            IdentifierToken fieldNameToken = (IdentifierToken)fieldNameNode;
            String fieldName = fieldNameToken.text().trim();
            if (fieldName.equals(KEY)) {
                keys = this.getEntityKeys(specificFieldNode);
                continue;
            }
            if (!fieldName.equals(RESOLVE_REFERENCE)) continue;
            ExpressionNode expressionNode = (ExpressionNode)specificFieldNode.valueExpr().get();
            isResolvable = expressionNode.kind() != SyntaxKind.NIL_LITERAL;
        }
        KeyDirectivesArgumentHolder arguments = new KeyDirectivesArgumentHolder(keys, isResolvable);
        this.schema.addEntityKeyDirectiveArguments(entityName, arguments);
    }

    private ArrayList<String> getEntityKeys(SpecificFieldNode specificFieldNode) {
        ArrayList<String> keys = new ArrayList<String>();
        if (specificFieldNode.valueExpr().isEmpty()) {
            return keys;
        }
        ExpressionNode keyFieldExpression = (ExpressionNode)specificFieldNode.valueExpr().get();
        if (keyFieldExpression.kind() == SyntaxKind.STRING_LITERAL) {
            keys.add(Utils.getStringValue((BasicLiteralNode)keyFieldExpression));
            return keys;
        }
        if (keyFieldExpression.kind() == SyntaxKind.LIST_CONSTRUCTOR) {
            for (Node expression : ((ListConstructorExpressionNode)keyFieldExpression).expressions()) {
                if (expression.kind() != SyntaxKind.STRING_LITERAL) continue;
                keys.add(Utils.getStringValue((BasicLiteralNode)expression));
            }
        }
        return keys;
    }

    private void addEntityTypes() {
        if (!this.schema.isSubgraph()) {
            return;
        }
        for (Map.Entry<String, Symbol> entry : this.interfaceEntityFinder.getEntities().entrySet()) {
            String entityName = entry.getKey();
            Symbol symbol = entry.getValue();
            if (symbol.kind() == SymbolKind.TYPE_DEFINITION) {
                this.schema.addEntity(this.getType(entityName, (TypeDefinitionSymbol)symbol));
                continue;
            }
            if (symbol.kind() != SymbolKind.CLASS) continue;
            this.schema.addEntity(this.getType(entityName, (ClassSymbol)symbol));
        }
    }

    private void findIntrospectionTypes() {
        IntrospectionTypeCreator introspectionTypeCreator = new IntrospectionTypeCreator(this.schema);
        introspectionTypeCreator.addIntrospectionTypes();
        this.addDefaultDirectives();
    }

    private void findRootTypes(Node serviceNode) {
        Type queryType = this.addType(TypeName.QUERY);
        for (MethodSymbol methodSymbol : this.getMethods(serviceNode)) {
            if (Utils.isResourceMethod(methodSymbol)) {
                ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)methodSymbol;
                String accessor = Utils.getAccessor(resourceMethodSymbol);
                if ("get".equals(accessor)) {
                    queryType.addField(this.getField(resourceMethodSymbol));
                    continue;
                }
                Type subscriptionType = this.addType(TypeName.SUBSCRIPTION);
                subscriptionType.addField(this.getField(resourceMethodSymbol));
                continue;
            }
            if (!Utils.isRemoteMethod(methodSymbol)) continue;
            Type mutationType = this.addType(TypeName.MUTATION);
            mutationType.addField(this.getField(methodSymbol));
        }
        this.schema.setQueryType(queryType);
        if (this.schema.containsType(TypeName.MUTATION.getName())) {
            this.schema.setMutationType(this.schema.getType(TypeName.MUTATION.getName()));
        }
        if (this.schema.containsType(TypeName.SUBSCRIPTION.getName())) {
            this.schema.setSubscriptionType(this.schema.getType(TypeName.SUBSCRIPTION.getName()));
        }
    }

    private Collection<? extends MethodSymbol> getMethods(Node node) {
        if (node.kind() == SyntaxKind.SERVICE_DECLARATION) {
            return this.getMethods((ServiceDeclarationNode)node);
        }
        if (node.kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            return this.getMethods((ObjectConstructorExpressionNode)node);
        }
        return new ArrayList();
    }

    private Collection<? extends MethodSymbol> getMethods(ObjectConstructorExpressionNode objectConstructorExpressionNode) {
        return objectConstructorExpressionNode.members().stream().filter(member -> Utils.isFunctionDefinition(member) && this.semanticModel.symbol(member).isPresent()).map(methodNode -> (MethodSymbol)this.semanticModel.symbol(methodNode).get()).collect(Collectors.toList());
    }

    private Collection<? extends MethodSymbol> getMethods(ServiceDeclarationNode serviceDeclarationNode) {
        ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)this.semanticModel.symbol((Node)serviceDeclarationNode).get();
        return serviceDeclarationSymbol.methods().values();
    }

    private Field getField(ResourceMethodSymbol methodSymbol) {
        return this.getField(methodSymbol, ((PathSegmentList)methodSymbol.resourcePath()).list());
    }

    private Field getField(ResourceMethodSymbol methodSymbol, List<PathSegment> list) {
        if (list.size() == 1) {
            boolean isDeprecated = methodSymbol.deprecated();
            String deprecationReason = GeneratorUtils.getDeprecationReason((Documentable)methodSymbol, isDeprecated);
            Type fieldType = this.getType((MethodSymbol)methodSymbol);
            Position position = GeneratorUtils.getTypePosition(methodSymbol.getLocation(), (Symbol)methodSymbol, this.project);
            Field field = new Field(list.get(0).signature(), GeneratorUtils.getDescription((Documentable)methodSymbol), fieldType, isDeprecated, deprecationReason, position);
            this.addArgs(field, (MethodSymbol)methodSymbol);
            return field;
        }
        PathSegment pathSegment = list.get(0);
        Type type = this.getType(methodSymbol, pathSegment, list);
        return new Field(pathSegment.signature(), GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL));
    }

    private Type getType(ResourceMethodSymbol methodSymbol, PathSegment pathSegment, List<PathSegment> list) {
        Type type = this.addType(pathSegment.signature(), TypeKind.OBJECT, Description.GENERATED_TYPE.getDescription());
        List<PathSegment> remainingPathList = list.subList(1, list.size());
        type.addField(this.getField(methodSymbol, remainingPathList));
        return type;
    }

    private Field getField(MethodSymbol methodSymbol) {
        boolean isDeprecated = methodSymbol.deprecated();
        String deprecationReason = GeneratorUtils.getDeprecationReason((Documentable)methodSymbol, isDeprecated);
        if (methodSymbol.getName().isEmpty()) {
            return null;
        }
        Type fieldType = this.getType(methodSymbol);
        Position position = GeneratorUtils.getTypePosition(methodSymbol.getLocation(), (Symbol)methodSymbol, this.project);
        Field field = new Field((String)methodSymbol.getName().get(), GeneratorUtils.getDescription((Documentable)methodSymbol), fieldType, isDeprecated, deprecationReason, position);
        this.addArgs(field, methodSymbol);
        return field;
    }

    private void addArgs(Field field, MethodSymbol methodSymbol) {
        if (methodSymbol.typeDescriptor().params().isEmpty()) {
            return;
        }
        for (ParameterSymbol parameterSymbol : (List)methodSymbol.typeDescriptor().params().get()) {
            if (Utils.isValidGraphqlParameter(parameterSymbol.typeDescriptor()) || parameterSymbol.getName().isEmpty()) continue;
            String parameterName = (String)parameterSymbol.getName().get();
            String description = SchemaGenerator.getParameterDescription(parameterName, methodSymbol);
            field.addArg(this.getArg(parameterName, description, parameterSymbol, methodSymbol));
        }
    }

    private InputValue getArg(String parameterName, String description, ParameterSymbol parameterSymbol, MethodSymbol methodSymbol) {
        Type type = this.getInputTypeForID(parameterSymbol);
        if (type == null) {
            type = this.getInputFieldType(parameterSymbol.typeDescriptor());
        }
        String defaultValue = this.getDefaultValue(methodSymbol, parameterSymbol);
        return new InputValue(parameterName, type, description, defaultValue);
    }

    private Type getInputTypeForID(ParameterSymbol parameterSymbol) {
        List annotationSymbols = parameterSymbol.annotations();
        if (annotationSymbols.isEmpty()) {
            return null;
        }
        for (AnnotationSymbol annotationSymbol : annotationSymbols) {
            if (!annotationSymbol.getName().isPresent() || !((String)annotationSymbol.getName().get()).equals(ID_ANNOT_NAME)) continue;
            return this.getTypeForID(parameterSymbol.typeDescriptor());
        }
        return null;
    }

    private Type getType(MethodSymbol methodSymbol) {
        if (methodSymbol.typeDescriptor().returnTypeDescriptor().isEmpty()) {
            return null;
        }
        TypeSymbol typeSymbol = (TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get();
        if (methodSymbol.typeDescriptor().returnTypeAnnotations().isPresent() && this.isIdAnnotation((Annotatable)methodSymbol.typeDescriptor().returnTypeAnnotations().get())) {
            return this.getTypeForID((TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get());
        }
        return this.getFieldType(typeSymbol);
    }

    private boolean isIdAnnotation(Annotatable annotatable) {
        List annotationSymbols = annotatable.annotations();
        for (AnnotationSymbol annotationSymbol : annotationSymbols) {
            if (!annotationSymbol.getName().isPresent() || !((String)annotationSymbol.getName().get()).equals(ID_ANNOT_NAME) || !annotationSymbol.getModule().isPresent() || !io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)annotationSymbol.getModule().get())) continue;
            return true;
        }
        return false;
    }

    private Type getTypeForID(TypeSymbol typeSymbol) {
        Type type;
        if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            return this.getTypeForIdArray(typeSymbol);
        }
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            for (TypeSymbol typeSymbolMember : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                if (typeSymbolMember.typeKind() != TypeDescKind.ARRAY) continue;
                Type memberType = this.getTypeForID(((ArrayTypeSymbol)typeSymbolMember).memberTypeDescriptor());
                Type arrayType = GeneratorUtils.getWrapperType(memberType, TypeKind.LIST);
                arrayType = SchemaGenerator.isNilable(typeSymbol) ? arrayType : GeneratorUtils.getWrapperType(arrayType, TypeKind.NON_NULL);
                return arrayType;
            }
        }
        if (this.schema.containsType(ScalarType.ID.getName())) {
            type = this.schema.getType(ScalarType.ID.getName());
            return SchemaGenerator.isNilable(typeSymbol) ? type : GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
        }
        type = this.addType(ScalarType.ID);
        return SchemaGenerator.isNilable(typeSymbol) ? type : GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
    }

    private Type getTypeForIdArray(TypeSymbol typeSymbol) {
        Type memberType = this.getTypeForID(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
        Type arrayType = GeneratorUtils.getWrapperType(memberType, TypeKind.LIST);
        arrayType = SchemaGenerator.isNilable(typeSymbol) ? arrayType : GeneratorUtils.getWrapperType(arrayType, TypeKind.NON_NULL);
        return arrayType;
    }

    private Type getType(TypeSymbol typeSymbol) {
        String typeName = GeneratorUtils.getTypeName(typeSymbol);
        if (this.schema.containsType(typeName)) {
            return this.schema.getType(typeName);
        }
        switch (typeSymbol.typeKind()) {
            case STRING: 
            case STRING_CHAR: {
                return this.addType(ScalarType.STRING);
            }
            case INT: {
                return this.addType(ScalarType.INT);
            }
            case FLOAT: {
                return this.addType(ScalarType.FLOAT);
            }
            case BOOLEAN: {
                return this.addType(ScalarType.BOOLEAN);
            }
            case DECIMAL: {
                return this.addType(ScalarType.DECIMAL);
            }
            case TYPE_REFERENCE: {
                return this.getType((TypeReferenceTypeSymbol)typeSymbol, typeName);
            }
            case ARRAY: {
                return this.getType((ArrayTypeSymbol)typeSymbol);
            }
            case UNION: {
                return this.getType(typeName, null, null, (UnionTypeSymbol)typeSymbol);
            }
            case INTERSECTION: {
                return this.getType(null, null, null, null, (IntersectionTypeSymbol)typeSymbol);
            }
            case STREAM: {
                return this.getType(((StreamTypeSymbol)typeSymbol).typeParameter());
            }
            case TABLE: {
                return this.getType((TableTypeSymbol)typeSymbol);
            }
        }
        return null;
    }

    private static boolean isNilable(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() != TypeDescKind.UNION) {
            return false;
        }
        UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
        for (TypeSymbol memberType : unionTypeSymbol.memberTypeDescriptors()) {
            if (memberType.typeKind() != TypeDescKind.NIL) continue;
            return true;
        }
        return false;
    }

    private Type addType(ScalarType scalarType) {
        return this.schema.addType(scalarType);
    }

    private Type addType(TypeName typeName) {
        return this.addType(typeName.getName(), TypeKind.OBJECT, null);
    }

    private Type addType(String name, TypeKind kind, String description) {
        return this.schema.addType(name, kind, description);
    }

    private Type addType(String name, TypeKind kind, String description, Position position) {
        return this.schema.addType(name, kind, description, position);
    }

    private Type addType(String name, TypeKind kind, String description, Position position, ObjectKind objectKind) {
        return this.schema.addType(name, kind, description, position, objectKind);
    }

    private Type getType(TypeReferenceTypeSymbol typeSymbol, String name) {
        if (typeSymbol.getName().isEmpty()) {
            return null;
        }
        Symbol definitionSymbol = typeSymbol.definition();
        if (definitionSymbol.kind() == SymbolKind.TYPE_DEFINITION) {
            return this.getType(name, (TypeDefinitionSymbol)definitionSymbol);
        }
        if (definitionSymbol.kind() == SymbolKind.CLASS) {
            return this.getType(name, (ClassSymbol)definitionSymbol);
        }
        if (definitionSymbol.kind() == SymbolKind.ENUM) {
            return this.getType(name, (EnumSymbol)definitionSymbol);
        }
        return null;
    }

    private Type getType(ArrayTypeSymbol arrayTypeSymbol) {
        TypeSymbol memberTypeSymbol = arrayTypeSymbol.memberTypeDescriptor();
        return GeneratorUtils.getWrapperType(this.getFieldType(memberTypeSymbol), TypeKind.LIST);
    }

    private Type getType(String name, TypeDefinitionSymbol typeDefinitionSymbol) {
        String description = GeneratorUtils.getDescription((Documentable)typeDefinitionSymbol);
        Map parameterMap = typeDefinitionSymbol.documentation().isEmpty() ? new HashMap() : ((Documentation)typeDefinitionSymbol.documentation().get()).parameterMap();
        if (typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.RECORD) {
            Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
            RecordTypeSymbol recordType = (RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            return this.getType(name, description, position, parameterMap, recordType);
        }
        if (typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.UNION) {
            Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
            return this.getType(name, description, position, (UnionTypeSymbol)typeDefinitionSymbol.typeDescriptor());
        }
        if (typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
            IntersectionTypeSymbol intersectionType = (IntersectionTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
            return this.getType(name, description, position, parameterMap, intersectionType);
        }
        if (typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.TABLE) {
            return this.getType((TableTypeSymbol)typeDefinitionSymbol.typeDescriptor());
        }
        if (typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.OBJECT) {
            ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
            return this.getType(name, description, position, objectTypeSymbol);
        }
        return null;
    }

    private Type getType(String name, String description, Position position, ObjectTypeSymbol objectTypeSymbol) {
        Type objectType = this.addType(name, TypeKind.INTERFACE, description, position);
        this.getTypesFromInterface(name, objectType);
        for (MethodSymbol methodSymbol : objectTypeSymbol.methods().values()) {
            if (!Utils.isResourceMethod(methodSymbol)) continue;
            objectType.addField(this.getField((ResourceMethodSymbol)methodSymbol));
        }
        return objectType;
    }

    private Type getType(String name, ClassSymbol classSymbol) {
        String description = GeneratorUtils.getDescription((Documentable)classSymbol);
        Position position = GeneratorUtils.getTypePosition(classSymbol.getLocation(), (Symbol)classSymbol, this.project);
        Type objectType = this.addType(name, TypeKind.OBJECT, description, position, ObjectKind.CLASS);
        for (MethodSymbol methodSymbol : classSymbol.methods().values()) {
            if (!Utils.isResourceMethod(methodSymbol)) continue;
            objectType.addField(this.getField((ResourceMethodSymbol)methodSymbol));
        }
        return objectType;
    }

    private void getTypesFromInterface(String typeName, Type interfaceType) {
        List<Symbol> implementations = this.interfaceEntityFinder.getImplementations(typeName);
        this.visitedInterfaces.add(interfaceType);
        for (Symbol implementation : implementations) {
            Type implementedType;
            String implementationName = (String)implementation.getName().get();
            if (implementation.kind() == SymbolKind.CLASS) {
                implementedType = this.getType(implementationName, (ClassSymbol)implementation);
            } else {
                TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)implementation;
                String description = GeneratorUtils.getDescription((Documentable)typeDefinitionSymbol);
                ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)typeDefinitionSymbol.typeDescriptor();
                Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
                implementedType = this.getType(implementationName, description, position, objectTypeSymbol);
            }
            interfaceType.addPossibleType(implementedType);
            this.addTransitiveImplementationsToInterface(interfaceType, implementedType);
            this.addSuperInterfacesToImplementation(implementedType);
        }
        this.visitedInterfaces.remove(interfaceType);
    }

    private void addTransitiveImplementationsToInterface(Type interfaceType, Type implementedType) {
        if (implementedType.getPossibleTypes() == null) {
            return;
        }
        for (Type transitiveImplementation : implementedType.getPossibleTypes()) {
            interfaceType.addPossibleType(transitiveImplementation);
        }
    }

    private void addSuperInterfacesToImplementation(Type implementedType) {
        for (Type superInterface : this.visitedInterfaces) {
            implementedType.addInterface(superInterface);
        }
    }

    private Type getType(String name, EnumSymbol enumSymbol) {
        String description = GeneratorUtils.getDescription((Documentable)enumSymbol);
        Position position = GeneratorUtils.getTypePosition(enumSymbol.getLocation(), (Symbol)enumSymbol, this.project);
        Type enumType = this.addType(name, TypeKind.ENUM, description, position);
        for (ConstantSymbol enumMember : enumSymbol.members()) {
            this.addEnumValueToType(enumType, enumMember);
        }
        return enumType;
    }

    private Type getType(String name, String description, Position position, Map<String, String> fieldMap, RecordTypeSymbol recordTypeSymbol) {
        Type objectType = this.addType(name, TypeKind.OBJECT, description, position, ObjectKind.RECORD);
        for (RecordFieldSymbol recordFieldSymbol : recordTypeSymbol.fieldDescriptors().values()) {
            if (recordFieldSymbol.getName().isEmpty()) continue;
            String fieldDescription = fieldMap.get(TypeUtils.removeEscapeCharacter((String)recordFieldSymbol.getName().get()));
            objectType.addField(this.getField(recordFieldSymbol, fieldDescription));
        }
        return objectType;
    }

    private Field getField(RecordFieldSymbol recordFieldSymbol, String description) {
        boolean isId = false;
        if (recordFieldSymbol.getName().isEmpty()) {
            return null;
        }
        String name = (String)recordFieldSymbol.getName().get();
        boolean isDeprecated = recordFieldSymbol.deprecated();
        String deprecationReason = GeneratorUtils.getDeprecationReason((Documentable)recordFieldSymbol, isDeprecated);
        Field field = new Field(name, description, isDeprecated, deprecationReason);
        TypeSymbol typeSymbol = recordFieldSymbol.typeDescriptor();
        Type type = null;
        if (typeSymbol.typeKind() == TypeDescKind.MAP) {
            type = this.getType(((MapTypeSymbol)typeSymbol).typeParam());
            Type argType = GeneratorUtils.getWrapperType(this.addType(ScalarType.STRING), TypeKind.NON_NULL);
            field.addArg(new InputValue(KEY, argType, "[auto-generated]: The key of the value required from a map", null));
        } else if (!recordFieldSymbol.annotations().isEmpty()) {
            for (AnnotationSymbol annotationSymbol : recordFieldSymbol.annotations()) {
                if (!annotationSymbol.getName().isPresent() || !((String)annotationSymbol.getName().get()).equals(ID_ANNOT_NAME) || !annotationSymbol.getModule().isPresent() || !io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)annotationSymbol.getModule().get())) continue;
                type = this.getTypeForID(recordFieldSymbol.typeDescriptor());
                isId = true;
                break;
            }
            if (type == null) {
                type = this.getType(typeSymbol);
            }
        } else {
            type = this.getType(typeSymbol);
        }
        if (!(SchemaGenerator.isNilable(typeSymbol) || recordFieldSymbol.isOptional() || isId)) {
            type = GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
        }
        field.setType(type);
        return field;
    }

    private Type getType(String name, String description, Position position, UnionTypeSymbol unionTypeSymbol) {
        List<TypeSymbol> effectiveTypes = Utils.getEffectiveTypes(unionTypeSymbol);
        if (effectiveTypes.size() == 1) {
            return this.getType(effectiveTypes.get(0));
        }
        String typeName = name == null ? GeneratorUtils.getTypeName(effectiveTypes) : name;
        String typeDescription = description == null ? Description.GENERATED_UNION_TYPE.getDescription() : description;
        Type unionType = this.addType(typeName, TypeKind.UNION, typeDescription, position);
        for (TypeSymbol typeSymbol : effectiveTypes) {
            Type possibleType = this.getType(typeSymbol);
            String memberTypeName = GeneratorUtils.getTypeName(typeSymbol);
            if (memberTypeName == null) continue;
            unionType.addPossibleType(possibleType);
        }
        return unionType;
    }

    private Type getType(String name, String description, Position position, Map<String, String> parameterMap, IntersectionTypeSymbol intersectionTypeSymbol) {
        TypeSymbol effectiveType = Utils.getEffectiveType(intersectionTypeSymbol);
        if (name == null) {
            return this.getType(effectiveType);
        }
        if (parameterMap == null) {
            parameterMap = new HashMap<String, String>();
        }
        return this.getType(name, description, position, parameterMap, (RecordTypeSymbol)effectiveType);
    }

    private Type getType(TableTypeSymbol tableTypeSymbol) {
        TypeSymbol typeSymbol = tableTypeSymbol.rowTypeParameter();
        Type type = this.getType(typeSymbol);
        return GeneratorUtils.getWrapperType(GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL), TypeKind.LIST);
    }

    private static String getParameterDescription(String parameterName, MethodSymbol methodSymbol) {
        if (methodSymbol.documentation().isEmpty()) {
            return null;
        }
        return (String)((Documentation)methodSymbol.documentation().get()).parameterMap().get(parameterName);
    }

    private Type getInputType(TypeSymbol typeSymbol) {
        String typeName = GeneratorUtils.getTypeName(typeSymbol);
        if (this.schema.containsType(typeName)) {
            return this.schema.getType(typeName);
        }
        switch (typeSymbol.typeKind()) {
            case STRING: 
            case STRING_CHAR: {
                return this.addType(ScalarType.STRING);
            }
            case INT: {
                return this.addType(ScalarType.INT);
            }
            case FLOAT: {
                return this.addType(ScalarType.FLOAT);
            }
            case BOOLEAN: {
                return this.addType(ScalarType.BOOLEAN);
            }
            case DECIMAL: {
                return this.addType(ScalarType.DECIMAL);
            }
            case TYPE_REFERENCE: {
                return this.getInputType((TypeReferenceTypeSymbol)typeSymbol, typeName);
            }
            case ARRAY: {
                return this.getInputType((ArrayTypeSymbol)typeSymbol);
            }
            case UNION: {
                return this.getInputType((UnionTypeSymbol)typeSymbol);
            }
            case INTERSECTION: {
                return this.getInputType(null, null, (IntersectionTypeSymbol)typeSymbol, null);
            }
        }
        return null;
    }

    private Type getInputType(TypeReferenceTypeSymbol typeReferenceTypeSymbol, String typeName) {
        if (Utils.isFileUploadParameter((TypeSymbol)typeReferenceTypeSymbol)) {
            return this.addType(ScalarType.UPLOAD);
        }
        if (typeReferenceTypeSymbol.getName().isEmpty()) {
            return null;
        }
        Symbol definitionSymbol = typeReferenceTypeSymbol.definition();
        if (definitionSymbol.kind() == SymbolKind.TYPE_DEFINITION) {
            return this.getInputType(typeName, (TypeDefinitionSymbol)definitionSymbol);
        }
        if (definitionSymbol.kind() == SymbolKind.ENUM) {
            return this.getType(typeName, (EnumSymbol)definitionSymbol);
        }
        return null;
    }

    private Type getInputType(ArrayTypeSymbol arrayTypeSymbol) {
        TypeSymbol memberTypeSymbol = arrayTypeSymbol.memberTypeDescriptor();
        return GeneratorUtils.getWrapperType(this.getInputFieldType(memberTypeSymbol), TypeKind.LIST);
    }

    private Type getInputType(String typeName, TypeDefinitionSymbol typeDefinitionSymbol) {
        TypeSymbol typeDescriptor = typeDefinitionSymbol.typeDescriptor();
        String description = GeneratorUtils.getDescription((Documentable)typeDefinitionSymbol);
        Position position = GeneratorUtils.getTypePosition(typeDefinitionSymbol.getLocation(), (Symbol)typeDefinitionSymbol, this.project);
        switch (typeDescriptor.typeKind()) {
            case RECORD: {
                return this.getInputType(typeName, description, (RecordTypeSymbol)typeDescriptor, position);
            }
            case UNION: {
                return this.getInputType((UnionTypeSymbol)typeDescriptor);
            }
            case INTERSECTION: {
                return this.getInputType(typeName, description, (IntersectionTypeSymbol)typeDescriptor, position);
            }
        }
        return null;
    }

    private Type getInputType(String name, String description, RecordTypeSymbol recordTypeSymbol, Position position) {
        Type objectType = this.addType(name, TypeKind.INPUT_OBJECT, description, position);
        for (RecordFieldSymbol recordFieldSymbol : recordTypeSymbol.fieldDescriptors().values()) {
            objectType.addInputField(this.getInputField(recordFieldSymbol, recordTypeSymbol, name));
        }
        return objectType;
    }

    private Type getInputType(UnionTypeSymbol unionTypeSymbol) {
        List<TypeSymbol> effectiveTypes = Utils.getEffectiveTypes(unionTypeSymbol);
        Iterator<TypeSymbol> iterator = effectiveTypes.iterator();
        if (iterator.hasNext()) {
            TypeSymbol typeSymbol = iterator.next();
            return this.getInputType(typeSymbol);
        }
        return null;
    }

    private Type getInputType(String typeName, String description, IntersectionTypeSymbol intersectionTypeSymbol, Position position) {
        TypeSymbol effectiveType = Utils.getEffectiveType(intersectionTypeSymbol);
        if (typeName == null) {
            return this.getInputType(effectiveType);
        }
        return this.getInputType(typeName, description, (RecordTypeSymbol)effectiveType, position);
    }

    private InputValue getInputField(RecordFieldSymbol recordFieldSymbol, RecordTypeSymbol recordTypeSymbol, String typeName) {
        boolean isId = false;
        if (recordFieldSymbol.getName().isEmpty()) {
            return null;
        }
        String name = (String)recordFieldSymbol.getName().get();
        String description = GeneratorUtils.getDescription((Documentable)recordFieldSymbol);
        Type type = null;
        for (AnnotationSymbol annotationSymbol : recordFieldSymbol.annotations()) {
            if (!annotationSymbol.getName().isPresent() || !((String)annotationSymbol.getName().get()).equals(ID_ANNOT_NAME) || !annotationSymbol.getModule().isPresent() || !io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)annotationSymbol.getModule().get())) continue;
            type = this.getTypeForID(recordFieldSymbol.typeDescriptor());
            isId = true;
            break;
        }
        if (type == null) {
            type = this.getInputType(recordFieldSymbol.typeDescriptor());
        }
        if (!(SchemaGenerator.isNilable(recordFieldSymbol.typeDescriptor()) || recordFieldSymbol.isOptional() || isId)) {
            type = GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
        }
        String defaultValue = this.getDefaultValue(recordFieldSymbol, recordTypeSymbol, typeName);
        return new InputValue(name, type, description, defaultValue);
    }

    private void addEnumValueToType(Type type, ConstantSymbol enumMember) {
        if (enumMember.getName().isEmpty()) {
            return;
        }
        String memberDescription = GeneratorUtils.getDescription((Documentable)enumMember);
        String name = (String)enumMember.getName().get();
        boolean isDeprecated = enumMember.deprecated();
        String deprecationReason = GeneratorUtils.getDeprecationReason((Documentable)enumMember, isDeprecated);
        EnumValue enumValue = new EnumValue(name, memberDescription, isDeprecated, deprecationReason);
        type.addEnumValue(enumValue);
    }

    private Type getFieldType(TypeSymbol typeSymbol) {
        Type type = this.getType(typeSymbol);
        if (SchemaGenerator.isNilable(typeSymbol)) {
            return type;
        }
        return GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
    }

    private Type getInputFieldType(TypeSymbol typeSymbol) {
        Type type = this.getInputType(typeSymbol);
        if (SchemaGenerator.isNilable(typeSymbol)) {
            return type;
        }
        return GeneratorUtils.getWrapperType(type, TypeKind.NON_NULL);
    }

    private void addDefaultDirectives() {
        Directive include = new Directive(DefaultDirective.INCLUDE);
        include.addArg(this.getIfInputValue(Description.INCLUDE_IF));
        this.schema.addDirective(include);
        Directive skip = new Directive(DefaultDirective.SKIP);
        skip.addArg(this.getIfInputValue(Description.SKIP_IF));
        this.schema.addDirective(skip);
        Directive deprecated = new Directive(DefaultDirective.DEPRECATED);
        InputValue reason = new InputValue(REASON_ARG_NAME, this.addType(ScalarType.STRING), Description.DEPRECATED_REASON.getDescription(), null);
        deprecated.addArg(reason);
        this.schema.addDirective(deprecated);
    }

    private InputValue getIfInputValue(Description description) {
        Type type = GeneratorUtils.getWrapperType(this.addType(ScalarType.BOOLEAN), TypeKind.NON_NULL);
        return new InputValue(IF_ARG_NAME, type, description.getDescription(), null);
    }

    private String getDefaultValue(RecordFieldSymbol recordFieldSymbol, RecordTypeSymbol recordTypeSymbol, String typeName) {
        if (recordFieldSymbol.hasDefaultValue()) {
            TypeDefinitionNode recordTypeDefNode = Utils.getRecordTypeDefinitionNode(recordTypeSymbol, typeName, this.context);
            if (recordTypeDefNode == null) {
                return DEFAULT_VALUE;
            }
            RecordFieldWithDefaultValueNode defaultField = Utils.getRecordFieldWithDefaultValueNode((String)recordFieldSymbol.getName().get(), recordTypeDefNode, this.semanticModel);
            if (defaultField == null) {
                return this.getDefaultValueFromTypeInclusions(Utils.getTypeInclusions((TypeSymbol)recordTypeSymbol), recordFieldSymbol);
            }
            return this.getDefaultValue((Node)defaultField.expression());
        }
        return null;
    }

    private String getDefaultValueFromTypeInclusions(List<TypeSymbol> typeInclusions, RecordFieldSymbol recordFieldSymbol) {
        ArrayList<TypeSymbol> recordTypeSymbols = new ArrayList<TypeSymbol>(typeInclusions);
        while (!recordTypeSymbols.isEmpty()) {
            TypeSymbol includedTypeSymbol = recordTypeSymbols.remove(0);
            if (includedTypeSymbol.getName().isEmpty()) continue;
            RecordFieldWithDefaultValueNode defaultField = this.getRecordFieldFromIncludedType(recordFieldSymbol, includedTypeSymbol);
            if (defaultField != null) {
                return this.getDefaultValue((Node)defaultField.expression());
            }
            recordTypeSymbols.addAll(Utils.getTypeInclusions(includedTypeSymbol));
        }
        return DEFAULT_VALUE;
    }

    private RecordFieldWithDefaultValueNode getRecordFieldFromIncludedType(RecordFieldSymbol recordFieldSymbol, TypeSymbol includedTypeSymbol) {
        TypeDefinitionNode recordTypeDefNode;
        TypeSymbol descriptor;
        if (recordFieldSymbol.getName().isEmpty()) {
            return null;
        }
        if (includedTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && (descriptor = ((TypeReferenceTypeSymbol)includedTypeSymbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD && (recordTypeDefNode = Utils.getRecordTypeDefinitionNode((RecordTypeSymbol)descriptor, (String)includedTypeSymbol.getName().get(), this.context)) != null) {
            return Utils.getRecordFieldWithDefaultValueNode((String)recordFieldSymbol.getName().get(), recordTypeDefNode, this.semanticModel);
        }
        return null;
    }

    private String getDefaultValue(MethodSymbol methodSymbol, ParameterSymbol parameterSymbol) {
        if (parameterSymbol.paramKind() == ParameterKind.DEFAULTABLE) {
            DefaultableParameterNode parameterNode = Utils.getDefaultableParameterNode(methodSymbol, parameterSymbol, this.context);
            return parameterNode == null ? DEFAULT_VALUE : this.getDefaultValue(parameterNode.expression());
        }
        return null;
    }

    private String getDefaultValue(Node expression) {
        switch (expression.kind()) {
            case NIL_LITERAL: {
                return null;
            }
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: {
                return this.getDefaultValue((BasicLiteralNode)expression);
            }
            case MAPPING_CONSTRUCTOR: {
                return this.getDefaultValue((MappingConstructorExpressionNode)expression);
            }
            case LIST_CONSTRUCTOR: {
                return this.getDefaultValue((ListConstructorExpressionNode)expression);
            }
            case SIMPLE_NAME_REFERENCE: {
                return this.getDefaultValue((SimpleNameReferenceNode)expression);
            }
        }
        return DEFAULT_VALUE;
    }

    private String getDefaultValue(BasicLiteralNode expressionNode) {
        return expressionNode.literalToken().text();
    }

    private String getDefaultValue(MappingConstructorExpressionNode expressionNode) {
        StringJoiner joiner = new StringJoiner(COMMA_SEPARATOR, INPUT_OBJECT_OPEN_BRACKET, INPUT_OBJECT_CLOSE_BRACKET);
        for (Node field : expressionNode.fields()) {
            SpecificFieldNode specificFieldNode;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (specificFieldNode = (SpecificFieldNode)field).fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN) continue;
            IdentifierToken identifierToken = (IdentifierToken)specificFieldNode.fieldName();
            String value = specificFieldNode.valueExpr().isEmpty() ? DEFAULT_VALUE : this.getDefaultValue((Node)specificFieldNode.valueExpr().get());
            joiner.add(identifierToken.text().trim() + COLON_SEPARATOR + value);
        }
        return joiner.toString();
    }

    private String getDefaultValue(ListConstructorExpressionNode expressionNode) {
        StringJoiner joiner = new StringJoiner(COMMA_SEPARATOR, LIST_OPEN_BRACKET, LIST_CLOSE_BRACKET);
        for (Node member : expressionNode.expressions()) {
            joiner.add(this.getDefaultValue(member));
        }
        return joiner.toString();
    }

    private String getDefaultValue(SimpleNameReferenceNode expressionNode) {
        if (this.semanticModel.symbol((Node)expressionNode).isEmpty()) {
            return DEFAULT_VALUE;
        }
        Symbol defaultValueSymbol = (Symbol)this.semanticModel.symbol((Node)expressionNode).get();
        if (defaultValueSymbol.kind() == SymbolKind.CONSTANT) {
            return ((ConstantSymbol)this.semanticModel.symbol((Node)expressionNode).get()).constValue().toString();
        }
        if (defaultValueSymbol.kind() == SymbolKind.ENUM_MEMBER) {
            return expressionNode.name().text();
        }
        return DEFAULT_VALUE;
    }
}

