/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.service.validator.MethodDefinitionNodeVisitor;
import java.util.ArrayList;
import java.util.Optional;

public class DefaultableParameterNodeFinder {
    private final MethodSymbol methodSymbol;
    private final ParameterSymbol parameterSymbol;
    private final FinderContext context;

    public DefaultableParameterNodeFinder(FinderContext context, MethodSymbol methodSymbol, ParameterSymbol parameterSymbol) {
        this.context = context;
        this.methodSymbol = methodSymbol;
        this.parameterSymbol = parameterSymbol;
    }

    public Optional<DefaultableParameterNode> getDeflatableParameterNode() {
        if (this.parameterSymbol.paramKind() != ParameterKind.DEFAULTABLE) {
            return Optional.empty();
        }
        Module currentModule = this.context.project().currentPackage().module(this.context.moduleId());
        ArrayList documentIds = new ArrayList(currentModule.documentIds());
        documentIds.addAll(currentModule.testDocumentIds());
        MethodDefinitionNodeVisitor visitor = new MethodDefinitionNodeVisitor(this.context.semanticModel(), this.methodSymbol, this.parameterSymbol);
        for (DocumentId documentId : documentIds) {
            Node rootNode = currentModule.document(documentId).syntaxTree().rootNode();
            rootNode.accept((NodeVisitor)visitor);
            Optional<ParameterNode> parameterNode = visitor.getParameterNode();
            if (!parameterNode.isPresent()) continue;
            return parameterNode.map(node -> (DefaultableParameterNode)node);
        }
        return Optional.empty();
    }
}

