/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.Optional;

public class RecordTypeDefinitionNodeVisitor
extends NodeVisitor {
    private final RecordTypeSymbol recordTypeSymbol;
    private final SemanticModel semanticModel;
    private final String recordTypeName;
    private TypeDefinitionNode typeDefinitionNode;

    public RecordTypeDefinitionNodeVisitor(SemanticModel semanticModel, RecordTypeSymbol recordTypeSymbol, String recordTypeName) {
        this.semanticModel = semanticModel;
        this.recordTypeSymbol = recordTypeSymbol;
        this.recordTypeName = recordTypeName;
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        if (this.typeDefinitionNode != null) {
            return;
        }
        Optional recordTypeDefSymbol = this.semanticModel.symbol((Node)typeDefinitionNode);
        if (recordTypeDefSymbol.isEmpty()) {
            return;
        }
        TypeDefinitionSymbol recordTypeDef = (TypeDefinitionSymbol)recordTypeDefSymbol.get();
        if (recordTypeDef.getName().isEmpty() || !this.recordTypeName.equals(recordTypeDef.getName().get())) {
            return;
        }
        if (recordTypeDef.typeDescriptor().equals((Object)this.recordTypeSymbol)) {
            this.typeDefinitionNode = typeDefinitionNode;
        }
    }

    public Optional<TypeDefinitionNode> getRecordTypeDefinitionNode() {
        return Optional.ofNullable(this.typeDefinitionNode);
    }
}

