/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;

public final class ValidatorUtils {
    public static final String DOUBLE_UNDERSCORES = "__";
    public static final String RESOURCE_FUNCTION_GET = "get";
    public static final String RESOURCE_FUNCTION_SUBSCRIBE = "subscribe";
    public static final String GRAPHQL_INTERCEPTOR = "Interceptor";
    public static final String INTERCEPTOR_EXECUTE = "execute";

    private ValidatorUtils() {
    }

    public static void updateContext(SyntaxNodeAnalysisContext context, CompilationDiagnostic errorCode, Location location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.getDiagnosticCode(), errorCode.getDiagnostic(), errorCode.getDiagnosticSeverity());
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
        context.reportDiagnostic(diagnostic);
    }

    public static void updateContext(SyntaxNodeAnalysisContext context, CompilationDiagnostic diagnosticCode, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode.getDiagnosticCode(), diagnosticCode.getDiagnostic(), diagnosticCode.getDiagnosticSeverity());
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        context.reportDiagnostic(diagnostic);
    }

    static Location getLocation(Symbol typeSymbol, Location alternateLocation) {
        if (typeSymbol.getLocation().isPresent()) {
            return (Location)typeSymbol.getLocation().get();
        }
        return alternateLocation;
    }

    public static boolean isInvalidFieldName(String fieldName) {
        return fieldName.startsWith(DOUBLE_UNDERSCORES);
    }

    public static boolean isReservedFederatedResolverName(String methodName) {
        return methodName.equals("_entities") || methodName.equals("_service");
    }

    public static boolean isReservedFederatedTypeName(String typeName) {
        List<String> reservedTypes = List.of(TypeName.ANY.getName(), TypeName.FIELD_SET.getName(), TypeName.LINK_IMPORT.getName(), TypeName.LINK_PURPOSE.getName(), TypeName.SERVICE.getName());
        return reservedTypes.contains(typeName);
    }
}

