/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsondata;

import io.ballerina.lib.data.jsondata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.jsondata.utils.DiagnosticLog;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FromString {
    private static final List<Integer> TYPE_PRIORITY_ORDER = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(14), Integer.valueOf(6), Integer.valueOf(15), Integer.valueOf(5));
    private static final List<Type> BASIC_JSON_MEMBER_TYPES = List.of(PredefinedTypes.TYPE_NULL, PredefinedTypes.TYPE_BOOLEAN, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_FLOAT, PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_STRING);
    private static final UnionType JSON_TYPE_WITH_BASIC_TYPES = TypeCreator.createUnionType(BASIC_JSON_MEMBER_TYPES);
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;

    public static Object fromStringWithType(BString string, Type expType) {
        String value = string.getValue();
        try {
            switch (expType.getTag()) {
                case 1: {
                    return FromString.stringToInt(value);
                }
                case 2: {
                    return FromString.stringToByte(value);
                }
                case 7: {
                    return FromString.stringToSigned8Int(value);
                }
                case 9: {
                    return FromString.stringToSigned16Int(value);
                }
                case 11: {
                    return FromString.stringToSigned32Int(value);
                }
                case 8: {
                    return FromString.stringToUnsigned8Int(value);
                }
                case 10: {
                    return FromString.stringToUnsigned16Int(value);
                }
                case 12: {
                    return FromString.stringToUnsigned32Int(value);
                }
                case 3: {
                    return FromString.stringToFloat(value);
                }
                case 4: {
                    return FromString.stringToDecimal(value);
                }
                case 13: {
                    return FromString.stringToChar(value);
                }
                case 5: {
                    return string;
                }
                case 6: {
                    return FromString.stringToBoolean(value);
                }
                case 14: {
                    return FromString.stringToNull(value);
                }
                case 46: {
                    return FromString.stringToFiniteType(value, (FiniteType)expType);
                }
                case 33: {
                    return FromString.stringToUnion(string, (UnionType)expType);
                }
                case 15: 
                case 23: {
                    return FromString.stringToUnion(string, JSON_TYPE_WITH_BASIC_TYPES);
                }
                case 53: {
                    return FromString.fromStringWithType(string, ((ReferenceType)expType).getReferredType());
                }
                case 34: {
                    return FromString.fromStringWithType(string, ((IntersectionType)expType).getEffectiveType());
                }
            }
            return FromString.returnError(value, expType.toString());
        }
        catch (NumberFormatException e) {
            return FromString.returnError(value, expType.toString());
        }
    }

    private static Object stringToFiniteType(String value, FiniteType finiteType) {
        return finiteType.getValueSpace().stream().filter(finiteValue -> !(FromString.convertToSingletonValue(value, finiteValue) instanceof BError)).findFirst().orElseGet(() -> FromString.returnError(value, finiteType.toString()));
    }

    private static Object convertToSingletonValue(String str, Object singletonValue) {
        String singletonStr = String.valueOf(singletonValue);
        if (str.equals(singletonStr)) {
            return FromString.fromStringWithType(StringUtils.fromString((String)str), TypeUtils.getType((Object)singletonValue));
        }
        return FromString.returnError(str, singletonStr);
    }

    private static Long stringToInt(String value) throws NumberFormatException {
        return Long.parseLong(value);
    }

    private static int stringToByte(String value) throws NumberFormatException {
        int intValue = Integer.parseInt(value);
        if (!FromString.isByteLiteral(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_BYTE, value);
        }
        return intValue;
    }

    private static long stringToSigned8Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isSigned8LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_8, value);
        }
        return intValue;
    }

    private static long stringToSigned16Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isSigned16LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_16, value);
        }
        return intValue;
    }

    private static long stringToSigned32Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isSigned32LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_32, value);
        }
        return intValue;
    }

    private static long stringToUnsigned8Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isUnsigned8LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_8, value);
        }
        return intValue;
    }

    private static long stringToUnsigned16Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isUnsigned16LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_16, value);
        }
        return intValue;
    }

    private static long stringToUnsigned32Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!FromString.isUnsigned32LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_32, value);
        }
        return intValue;
    }

    private static BString stringToChar(String value) throws NumberFormatException {
        if (!FromString.isCharLiteralValue(value)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_STRING_CHAR, value);
        }
        return StringUtils.fromString((String)value);
    }

    private static Double stringToFloat(String value) throws NumberFormatException {
        if (FromString.hasFloatOrDecimalLiteralSuffix(value)) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(value);
    }

    private static BDecimal stringToDecimal(String value) throws NumberFormatException {
        return ValueCreator.createDecimalValue((String)value);
    }

    private static Object stringToBoolean(String value) throws NumberFormatException {
        if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        return FromString.returnError(value, "boolean");
    }

    private static Object stringToNull(String value) throws NumberFormatException {
        if ("null".equalsIgnoreCase(value) || "()".equalsIgnoreCase(value)) {
            return null;
        }
        return FromString.returnError(value, "()");
    }

    private static Object stringToUnion(BString string, UnionType expType) throws NumberFormatException {
        ArrayList<Type> memberTypes = new ArrayList<Type>(expType.getMemberTypes());
        memberTypes.sort(Comparator.comparingInt(t -> {
            int index = TYPE_PRIORITY_ORDER.indexOf(TypeUtils.getReferredType((Type)t).getTag());
            return index == -1 ? Integer.MAX_VALUE : index;
        }));
        for (Type memberType : memberTypes) {
            try {
                Object result = FromString.fromStringWithType(string, memberType);
                if (result instanceof BError) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return FromString.returnError(string.getValue(), expType.toString());
    }

    private static boolean hasFloatOrDecimalLiteralSuffix(String value) {
        int length = value.length();
        if (length == 0) {
            return false;
        }
        switch (value.charAt(length - 1)) {
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)BBYTE_MIN_VALUE.intValue() && longValue <= (long)BBYTE_MAX_VALUE.intValue();
    }

    private static boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)SIGNED32_MIN_VALUE.intValue() && longObject <= (long)SIGNED32_MAX_VALUE.intValue();
    }

    private static boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED16_MIN_VALUE && longObject.intValue() <= SIGNED16_MAX_VALUE;
    }

    private static boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED8_MIN_VALUE && longObject.intValue() <= SIGNED8_MAX_VALUE;
    }

    private static boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= UNSIGNED32_MAX_VALUE;
    }

    private static boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED16_MAX_VALUE;
    }

    private static boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED8_MAX_VALUE;
    }

    private static boolean isCharLiteralValue(String value) {
        return value.codePoints().count() == 1L;
    }

    private static BError returnError(String string, String expType) {
        return DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_TO_EXPECTED_TYPE, PredefinedTypes.TYPE_STRING.getName(), string, expType);
    }
}

