/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsondata.json;

import io.ballerina.lib.data.jsondata.json.JsonCreator;
import io.ballerina.lib.data.jsondata.json.JsonTraverse;
import io.ballerina.lib.data.jsondata.utils.Constants;
import io.ballerina.lib.data.jsondata.utils.DataUtils;
import io.ballerina.lib.data.jsondata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.jsondata.utils.DiagnosticLog;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StringType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.langlib.value.CloneReadOnly;

public class JsonParser {
    private static final ThreadLocal<StateMachine> tlStateMachine = ThreadLocal.withInitial(StateMachine::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(Reader reader, BMap<BString, Object> options, Type type) throws BError {
        StateMachine sm = tlStateMachine.get();
        try {
            Object object = sm.execute(reader, options, type);
            return object;
        }
        finally {
            sm.reset();
        }
    }

    public static Object parse(Reader reader, BMap<BString, Object> options, BTypedesc typed) throws BError {
        Object convertedValue = JsonParser.parse(reader, options, typed.getDescribingType());
        if (convertedValue instanceof BError) {
            return convertedValue;
        }
        return DataUtils.validateConstraints(convertedValue, typed, (Boolean)options.get((Object)Constants.ENABLE_CONSTRAINT_VALIDATION));
    }

    static class StateMachine {
        private static final char CR = '\r';
        private static final char NEWLINE = '\n';
        private static final char HZ_TAB = '\t';
        private static final char SPACE = ' ';
        private static final char BACKSPACE = '\b';
        private static final char FORMFEED = '\f';
        private static final char QUOTES = '\"';
        private static final char REV_SOL = '\\';
        private static final char SOL = '/';
        private static final char EOF = '\uffff';
        private static final State DOC_START_STATE = new DocumentStartState();
        private static final State DOC_END_STATE = new DocumentEndState();
        static final State FIRST_FIELD_READY_STATE = new FirstFieldReadyState();
        private static final State NON_FIRST_FIELD_READY_STATE = new NonFirstFieldReadyState();
        private static final State FIELD_NAME_STATE = new FieldNameState();
        private static final State END_FIELD_NAME_STATE = new EndFieldNameState();
        private static final State FIELD_VALUE_READY_STATE = new FieldValueReadyState();
        private static final State STRING_FIELD_VALUE_STATE = new StringFieldValueState();
        private static final State NON_STRING_FIELD_VALUE_STATE = new NonStringFieldValueState();
        private static final State NON_STRING_VALUE_STATE = new NonStringValueState();
        private static final State STRING_VALUE_STATE = new StringValueState();
        private static final State FIELD_END_STATE = new FieldEndState();
        private static final State STRING_AE_ESC_CHAR_PROCESSING_STATE = new StringAEEscapedCharacterProcessingState();
        private static final State STRING_AE_PROCESSING_STATE = new StringAEProcessingState();
        private static final State FIELD_NAME_UNICODE_HEX_PROCESSING_STATE = new FieldNameUnicodeHexProcessingState();
        static final State FIRST_ARRAY_ELEMENT_READY_STATE = new FirstArrayElementReadyState();
        private static final State NON_FIRST_ARRAY_ELEMENT_READY_STATE = new NonFirstArrayElementReadyState();
        private static final State STRING_ARRAY_ELEMENT_STATE = new StringArrayElementState();
        private static final State NON_STRING_ARRAY_ELEMENT_STATE = new NonStringArrayElementState();
        private static final State ARRAY_ELEMENT_END_STATE = new ArrayElementEndState();
        private static final State STRING_FIELD_ESC_CHAR_PROCESSING_STATE = new StringFieldEscapedCharacterProcessingState();
        private static final State STRING_VAL_ESC_CHAR_PROCESSING_STATE = new StringValueEscapedCharacterProcessingState();
        private static final State FIELD_NAME_ESC_CHAR_PROCESSING_STATE = new FieldNameEscapedCharacterProcessingState();
        private static final State STRING_FIELD_UNICODE_HEX_PROCESSING_STATE = new StringFieldUnicodeHexProcessingState();
        private static final State STRING_VALUE_UNICODE_HEX_PROCESSING_STATE = new StringValueUnicodeHexProcessingState();
        Object currentJsonNode;
        Deque<Object> nodesStack;
        private StringBuilder hexBuilder = new StringBuilder(4);
        private char[] charBuff = new char[1024];
        private int charBuffIndex;
        private int index;
        private int line;
        private int column;
        private char currentQuoteChar;
        boolean allowDataProjection = false;
        boolean nilAsOptionalField = false;
        boolean absentAsNilableType = false;
        Field currentField;
        Stack<Map<String, Field>> fieldHierarchy = new Stack();
        Stack<Map<String, Field>> visitedFieldHierarchy = new Stack();
        Stack<Type> restType = new Stack();
        Stack<Type> expectedTypes = new Stack();
        Stack<Stack<String>> fieldNameHierarchy = new Stack();
        int jsonFieldDepth = 0;
        Stack<Integer> arrayIndexes = new Stack();
        Stack<ParserContext> parserContexts = new Stack();
        int unionDepth = 0;

        StateMachine() {
            this.reset();
        }

        public void reset() {
            this.index = 0;
            this.currentJsonNode = null;
            this.line = 1;
            this.column = 0;
            this.nodesStack = new ArrayDeque<Object>();
            this.fieldNameHierarchy.clear();
            this.fieldHierarchy.clear();
            this.visitedFieldHierarchy.clear();
            this.currentField = null;
            this.restType.clear();
            this.expectedTypes.clear();
            this.jsonFieldDepth = 0;
            this.arrayIndexes.clear();
            this.parserContexts.clear();
            this.allowDataProjection = false;
            this.nilAsOptionalField = false;
            this.absentAsNilableType = false;
            this.unionDepth = 0;
        }

        private static boolean isWhitespace(char ch) {
            return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
        }

        private static void throwExpected(String ... chars) throws JsonParserException {
            throw new JsonParserException("expected '" + String.join((CharSequence)"' or '", chars) + "'");
        }

        private void processLocation(char ch) {
            if (ch == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
        }

        public Object execute(Reader reader, BMap<BString, Object> options, Type type) throws BError {
            switch (type.getTag()) {
                case 24: {
                    RecordType recordType = (RecordType)type;
                    this.expectedTypes.push((Type)recordType);
                    this.updateExpectedType(JsonCreator.getAllFieldsInRecord(recordType), recordType.getRestFieldType());
                    break;
                }
                case 32: 
                case 44: {
                    this.expectedTypes.push(type);
                    this.arrayIndexes.push(0);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 33: 
                case 46: {
                    this.expectedTypes.push(type);
                    break;
                }
                case 15: 
                case 23: {
                    this.expectedTypes.push(type);
                    this.updateExpectedType(new HashMap<String, Field>(), type);
                    break;
                }
                case 27: {
                    this.expectedTypes.push(type);
                    this.updateExpectedType(new HashMap<String, Field>(), ((MapType)type).getConstrainedType());
                    break;
                }
                case 34: {
                    Type effectiveType = ((IntersectionType)type).getEffectiveType();
                    if (!effectiveType.isReadOnly()) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
                    }
                    Object jsonValue = null;
                    for (Type constituentType : ((IntersectionType)type).getConstituentTypes()) {
                        if (constituentType.getTag() == 51) continue;
                        jsonValue = this.execute(reader, options, TypeUtils.getReferredType((Type)constituentType));
                        break;
                    }
                    return JsonCreator.constructReadOnlyValue(jsonValue);
                }
                case 53: {
                    return this.execute(reader, options, TypeUtils.getReferredType((Type)type));
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
                }
            }
            Object allowDataProjection = options.get((Object)Constants.ALLOW_DATA_PROJECTION);
            if (allowDataProjection instanceof Boolean) {
                this.allowDataProjection = false;
            } else if (allowDataProjection instanceof BMap) {
                this.allowDataProjection = true;
                this.absentAsNilableType = (Boolean)((BMap)allowDataProjection).get((Object)Constants.ABSENT_AS_NILABLE_TYPE);
                this.nilAsOptionalField = (Boolean)((BMap)allowDataProjection).get((Object)Constants.NIL_AS_OPTIONAL_FIELD);
            }
            State currentState = DOC_START_STATE;
            try {
                int count;
                char[] buff = new char[1024];
                while ((count = reader.read(buff)) > 0) {
                    this.index = 0;
                    while (this.index < count) {
                        currentState = currentState.transition(this, buff, this.index, count);
                    }
                }
                if ((currentState = currentState.transition(this, new char[]{'\uffff'}, 0, 1)) != DOC_END_STATE) {
                    throw ErrorCreator.createError((BString)StringUtils.fromString((String)"invalid JSON document"));
                }
                return this.currentJsonNode;
            }
            catch (IOException e) {
                throw DiagnosticLog.error(DiagnosticErrorCode.JSON_READER_FAILURE, e.getMessage());
            }
            catch (JsonParserException e) {
                throw DiagnosticLog.error(DiagnosticErrorCode.JSON_PARSER_EXCEPTION, e.getMessage(), this.line, this.column);
            }
        }

        private void append(char ch) {
            try {
                this.charBuff[this.charBuffIndex] = ch;
                ++this.charBuffIndex;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.growCharBuff();
                this.charBuff[this.charBuffIndex++] = ch;
            }
        }

        private void growCharBuff() {
            char[] newBuff = new char[this.charBuff.length * 2];
            System.arraycopy(this.charBuff, 0, newBuff, 0, this.charBuff.length);
            this.charBuff = newBuff;
        }

        private State finalizeNonArrayObjectAndRemoveExpectedType() {
            State state = this.finalizeNonArrayObject();
            this.expectedTypes.pop();
            return state;
        }

        private State checkUnionAndFinalizeNonArrayObject() {
            if (this.unionDepth > 0) {
                this.fieldNameHierarchy.pop();
                return this.finalizeObject();
            }
            return this.finalizeNonArrayObjectAndRemoveExpectedType();
        }

        private State finalizeNonArrayObject() {
            if (this.jsonFieldDepth > 0) {
                --this.jsonFieldDepth;
            }
            if (!this.expectedTypes.isEmpty() && this.expectedTypes.peek() == null) {
                this.parserContexts.pop();
                this.fieldNameHierarchy.pop();
                if (this.parserContexts.peek() == ParserContext.MAP) {
                    return FIELD_END_STATE;
                }
                return ARRAY_ELEMENT_END_STATE;
            }
            Map<String, Field> remainingFields = this.fieldHierarchy.pop();
            this.visitedFieldHierarchy.pop();
            this.fieldNameHierarchy.pop();
            this.restType.pop();
            for (Field field : remainingFields.values()) {
                if (this.absentAsNilableType && field.getFieldType().isNilable() || !SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
                throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_FIELD_NOT_PRESENT, field.getFieldName());
            }
            return this.finalizeObject();
        }

        private Object verifyAndConvertToUnion(Object json) {
            if (this.unionDepth > 0) {
                return json;
            }
            BMap options = ValueCreator.createMapValue();
            BMap allowDataProjectionMap = ValueCreator.createMapValue();
            if (!this.allowDataProjection) {
                options.put((Object)Constants.ALLOW_DATA_PROJECTION, (Object)false);
            } else {
                allowDataProjectionMap.put((Object)Constants.NIL_AS_OPTIONAL_FIELD, (Object)this.nilAsOptionalField);
                allowDataProjectionMap.put((Object)Constants.ABSENT_AS_NILABLE_TYPE, (Object)this.absentAsNilableType);
                options.put((Object)Constants.ALLOW_DATA_PROJECTION, (Object)allowDataProjectionMap);
            }
            return JsonTraverse.traverse(json, (BMap<BString, Object>)options, this.expectedTypes.peek());
        }

        private State finalizeObject() {
            Object parentNode;
            Type parentNodeType;
            int parentNodeTypeTag;
            this.parserContexts.pop();
            if (this.unionDepth > 0) {
                --this.unionDepth;
                this.currentJsonNode = this.verifyAndConvertToUnion(this.currentJsonNode);
            }
            if (!this.expectedTypes.isEmpty() && this.expectedTypes.peek() == null) {
                if (this.parserContexts.peek() == ParserContext.MAP) {
                    return FIELD_END_STATE;
                }
                return ARRAY_ELEMENT_END_STATE;
            }
            if (this.nodesStack.isEmpty()) {
                return DOC_END_STATE;
            }
            if (this.expectedTypes.peek().isReadOnly()) {
                this.currentJsonNode = CloneReadOnly.cloneReadOnly((Object)this.currentJsonNode);
            }
            if ((parentNodeTypeTag = TypeUtils.getReferredType((Type)(parentNodeType = TypeUtils.getType((Object)(parentNode = this.nodesStack.pop())))).getTag()) == 24 || parentNodeTypeTag == 27) {
                ((BMap)parentNode).put((Object)StringUtils.fromString((String)this.fieldNameHierarchy.peek().pop()), this.currentJsonNode);
                this.currentJsonNode = parentNode;
                return FIELD_END_STATE;
            }
            switch (TypeUtils.getType((Object)parentNode).getTag()) {
                case 32: {
                    ArrayType arrayType = (ArrayType)parentNodeType;
                    if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= this.arrayIndexes.peek()) break;
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentJsonNode);
                    break;
                }
                case 44: {
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentJsonNode);
                    break;
                }
            }
            this.currentJsonNode = parentNode;
            return ARRAY_ELEMENT_END_STATE;
        }

        private void updateIndexOfArrayElement() {
            int arrayIndex = this.arrayIndexes.pop();
            this.arrayIndexes.push(arrayIndex + 1);
        }

        public void updateExpectedType(Map<String, Field> fields, Type restType) {
            this.fieldHierarchy.push(new HashMap<String, Field>(fields));
            this.visitedFieldHierarchy.push(new HashMap());
            this.restType.push(restType);
            this.fieldNameHierarchy.push(new Stack());
        }

        private State finalizeArrayObjectAndRemoveExpectedType() {
            State state = this.finalizeObject();
            this.expectedTypes.pop();
            return state;
        }

        private State checkUnionAndFinalizeArrayObject() {
            this.arrayIndexes.pop();
            if (this.unionDepth > 0) {
                return this.finalizeObject();
            }
            return this.finalizeArrayObjectAndRemoveExpectedType();
        }

        void handleFieldName(String jsonFieldName) {
            if (this.jsonFieldDepth == 0 && this.unionDepth == 0) {
                Type fieldType;
                this.currentField = this.visitedFieldHierarchy.peek().get(jsonFieldName);
                if (this.currentField == null) {
                    this.currentField = this.fieldHierarchy.peek().remove(jsonFieldName);
                }
                if (this.currentField == null) {
                    fieldType = this.restType.peek();
                } else {
                    jsonFieldName = this.currentField.getFieldName();
                    fieldType = this.currentField.getFieldType();
                    this.visitedFieldHierarchy.peek().put(jsonFieldName, this.currentField);
                }
                this.expectedTypes.push(fieldType);
                if (!this.allowDataProjection && fieldType == null) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, jsonFieldName);
                }
            } else if (this.expectedTypes.peek() == null) {
                this.expectedTypes.push(null);
            }
            this.fieldNameHierarchy.peek().push(jsonFieldName);
        }

        private String value() {
            String result = new String(this.charBuff, 0, this.charBuffIndex);
            this.charBuffIndex = 0;
            return result;
        }

        private String processFieldName() {
            return this.value();
        }

        private void processValue(boolean isStringElement) {
            StringType expType;
            String value = this.value();
            if (this.unionDepth > 0) {
                expType = isStringElement ? PredefinedTypes.TYPE_STRING : PredefinedTypes.TYPE_JSON;
            } else {
                expType = this.expectedTypes.pop();
                if (expType == null) {
                    return;
                }
            }
            JsonCreator.checkNullAndUpdateCurrentJson(this, JsonCreator.convertAndUpdateCurrentJsonNode(this, value, (Type)expType, isStringElement));
        }

        static interface State {
            public State transition(StateMachine var1, char[] var2, int var3, int var4) throws JsonParserException;
        }

        public static enum ParserContext {
            MAP,
            ARRAY;

        }

        private static class DocumentStartState
        implements State {
            private DocumentStartState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        sm.currentJsonNode = JsonCreator.initRootMapValue(sm);
                        state = FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (ch == '[') {
                        sm.currentJsonNode = JsonCreator.initRootArrayValue(sm);
                        state = FIRST_ARRAY_ELEMENT_READY_STATE;
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"') {
                            sm.currentQuoteChar = ch;
                            state = STRING_VALUE_STATE;
                            break;
                        }
                        if (ch == '\uffff') {
                            throw new JsonParserException("empty JSON document");
                        }
                        state = NON_STRING_VALUE_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_VALUE_STATE ? i : i + 1;
                return state;
            }
        }

        private static class DocumentEndState
        implements State {
            private DocumentEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                DocumentEndState state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch) && ch != '\uffff') {
                        throw new JsonParserException("JSON document has already ended");
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                if (sm.unionDepth > 0) {
                    sm.currentJsonNode = sm.verifyAndConvertToUnion(sm.currentJsonNode);
                }
                return state;
            }
        }

        private static class FirstFieldReadyState
        implements State {
            private FirstFieldReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\"') {
                        state = FIELD_NAME_STATE;
                        sm.currentQuoteChar = ch;
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '}') {
                            state = sm.checkUnionAndFinalizeNonArrayObject();
                            break;
                        }
                        StateMachine.throwExpected("\"", "}");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonFirstFieldReadyState
        implements State {
            private NonFirstFieldReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\"') {
                        sm.currentQuoteChar = ch;
                        state = FIELD_NAME_STATE;
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        StateMachine.throwExpected("\"");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldNameState
        implements State {
            private FieldNameState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        String jsonFieldName = sm.processFieldName();
                        sm.handleFieldName(jsonFieldName);
                        state = END_FIELD_NAME_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = FIELD_NAME_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class EndFieldNameState
        implements State {
            private EndFieldNameState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ':') {
                            state = FIELD_VALUE_READY_STATE;
                            break;
                        }
                        StateMachine.throwExpected(":");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldValueReadyState
        implements State {
            private FieldValueReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"') {
                            state = STRING_FIELD_VALUE_STATE;
                            sm.currentQuoteChar = ch;
                            break;
                        }
                        if (ch == '{') {
                            JsonCreator.updateNextMapValue(sm);
                            state = FIRST_FIELD_READY_STATE;
                            break;
                        }
                        if (ch == '[') {
                            JsonCreator.updateNextArrayValue(sm);
                            state = FIRST_ARRAY_ELEMENT_READY_STATE;
                            break;
                        }
                        state = NON_STRING_FIELD_VALUE_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_FIELD_VALUE_STATE ? i : i + 1;
                return state;
            }
        }

        private static class StringFieldValueState
        implements State {
            private StringFieldValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        sm.processValue(true);
                        state = FIELD_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_FIELD_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringFieldValueState
        implements State {
            private NonStringFieldValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        JsonCreator.updateNextMapValue(sm);
                        state = FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (ch == '[') {
                        state = FIRST_ARRAY_ELEMENT_READY_STATE;
                        JsonCreator.updateNextArrayValueBasedOnExpType(sm);
                        break;
                    }
                    if (ch == '}') {
                        sm.processValue(false);
                        state = sm.checkUnionAndFinalizeNonArrayObject();
                        break;
                    }
                    if (ch == ']') {
                        sm.processValue(false);
                        state = sm.checkUnionAndFinalizeArrayObject();
                        break;
                    }
                    if (ch == ',') {
                        sm.processValue(false);
                        state = NON_FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (StateMachine.isWhitespace(ch)) {
                        sm.processValue(false);
                        state = FIELD_END_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringValueState
        implements State {
            private NonStringValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (StateMachine.isWhitespace(ch) || ch == '\uffff') {
                        sm.currentJsonNode = null;
                        sm.processValue(false);
                        state = DOC_END_STATE;
                        break;
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class StringValueState
        implements State {
            private StringValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        String value = sm.value();
                        Object expType = sm.unionDepth > 0 ? PredefinedTypes.TYPE_STRING : sm.expectedTypes.peek();
                        JsonCreator.checkNullAndUpdateCurrentJson(sm, JsonCreator.convertAndUpdateCurrentJsonNode(sm, value, (Type)expType, true));
                        state = DOC_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_VAL_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldEndState
        implements State {
            private FieldEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ',') {
                            state = NON_FIRST_FIELD_READY_STATE;
                            break;
                        }
                        if (ch == '}') {
                            state = sm.checkUnionAndFinalizeNonArrayObject();
                            break;
                        }
                        StateMachine.throwExpected(",", "}");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class StringAEEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringAEEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_ARRAY_ELEMENT_STATE;
            }
        }

        private static class StringAEProcessingState
        extends UnicodeHexProcessingState {
            private StringAEProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_ARRAY_ELEMENT_STATE;
            }
        }

        private static class FieldNameUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private FieldNameUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return FIELD_NAME_STATE;
            }
        }

        private static class FirstArrayElementReadyState
        implements State {
            private FirstArrayElementReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"') {
                            state = STRING_ARRAY_ELEMENT_STATE;
                            sm.currentQuoteChar = ch;
                            JsonCreator.updateExpectedType(sm);
                            break;
                        }
                        if (ch == '{') {
                            JsonCreator.updateNextMapValueBasedOnExpType(sm);
                            state = FIRST_FIELD_READY_STATE;
                            break;
                        }
                        if (ch == '[') {
                            JsonCreator.updateNextArrayValueBasedOnExpType(sm);
                            state = FIRST_ARRAY_ELEMENT_READY_STATE;
                            break;
                        }
                        if (ch == ']') {
                            state = sm.checkUnionAndFinalizeArrayObject();
                            break;
                        }
                        state = NON_STRING_ARRAY_ELEMENT_STATE;
                        JsonCreator.updateExpectedType(sm);
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
                return state;
            }
        }

        private static class NonFirstArrayElementReadyState
        implements State {
            private NonFirstArrayElementReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"') {
                            state = STRING_ARRAY_ELEMENT_STATE;
                            sm.currentQuoteChar = ch;
                            JsonCreator.updateExpectedType(sm);
                            break;
                        }
                        if (ch == '{') {
                            JsonCreator.updateNextMapValueBasedOnExpType(sm);
                            state = FIRST_FIELD_READY_STATE;
                            break;
                        }
                        if (ch == '[') {
                            JsonCreator.updateNextArrayValueBasedOnExpType(sm);
                            state = FIRST_ARRAY_ELEMENT_READY_STATE;
                            break;
                        }
                        JsonCreator.updateExpectedType(sm);
                        state = NON_STRING_ARRAY_ELEMENT_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
                return state;
            }
        }

        private static class StringArrayElementState
        implements State {
            private StringArrayElementState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        sm.processValue(true);
                        state = ARRAY_ELEMENT_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_AE_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringArrayElementState
        implements State {
            private NonStringArrayElementState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        JsonCreator.updateNextMapValue(sm);
                        state = FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (ch == '[') {
                        JsonCreator.updateNextArrayValueBasedOnExpType(sm);
                        state = FIRST_ARRAY_ELEMENT_READY_STATE;
                        break;
                    }
                    if (ch == ']') {
                        sm.processValue(false);
                        state = sm.checkUnionAndFinalizeArrayObject();
                        break;
                    }
                    if (ch == ',') {
                        sm.processValue(false);
                        state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                        sm.updateIndexOfArrayElement();
                        break;
                    }
                    if (StateMachine.isWhitespace(ch)) {
                        sm.processValue(false);
                        state = ARRAY_ELEMENT_END_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class ArrayElementEndState
        implements State {
            private ArrayElementEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ',') {
                            sm.updateIndexOfArrayElement();
                            state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                            break;
                        }
                        if (ch == ']') {
                            state = sm.checkUnionAndFinalizeArrayObject();
                            break;
                        }
                        StateMachine.throwExpected(",", "]");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class StringFieldEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringFieldEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_FIELD_VALUE_STATE;
            }
        }

        private static class StringValueEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringValueEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_VALUE_STATE;
            }
        }

        private static class FieldNameEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private FieldNameEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return FIELD_NAME_STATE;
            }
        }

        private static class StringFieldUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private StringFieldUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_FIELD_VALUE_STATE;
            }
        }

        private static class StringValueUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private StringValueUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_VALUE_STATE;
            }
        }

        private static abstract class EscapedCharacterProcessingState
        implements State {
            private EscapedCharacterProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                if (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    switch (ch) {
                        case '\"': {
                            sm.append('\"');
                            state = this.getSourceState();
                            break;
                        }
                        case '\\': {
                            sm.append('\\');
                            state = this.getSourceState();
                            break;
                        }
                        case '/': {
                            sm.append('/');
                            state = this.getSourceState();
                            break;
                        }
                        case 'b': {
                            sm.append('\b');
                            state = this.getSourceState();
                            break;
                        }
                        case 'f': {
                            sm.append('\f');
                            state = this.getSourceState();
                            break;
                        }
                        case 'n': {
                            sm.append('\n');
                            state = this.getSourceState();
                            break;
                        }
                        case 'r': {
                            sm.append('\r');
                            state = this.getSourceState();
                            break;
                        }
                        case 't': {
                            sm.append('\t');
                            state = this.getSourceState();
                            break;
                        }
                        case 'u': {
                            if (this.getSourceState() == STRING_FIELD_VALUE_STATE) {
                                state = STRING_FIELD_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == STRING_VALUE_STATE) {
                                state = STRING_VALUE_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == FIELD_NAME_STATE) {
                                state = FIELD_NAME_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == STRING_ARRAY_ELEMENT_STATE) {
                                state = STRING_AE_PROCESSING_STATE;
                                break;
                            }
                            throw new JsonParserException("unknown source '" + String.valueOf(this.getSourceState()) + "' in escape char processing state");
                        }
                        default: {
                            StateMachine.throwExpected("escaped characters");
                        }
                    }
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static abstract class UnicodeHexProcessingState
        implements State {
            private UnicodeHexProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                        sm.hexBuilder.append(ch);
                        if (sm.hexBuilder.length() >= 4) {
                            sm.append(this.extractUnicodeChar(sm));
                            this.reset(sm);
                            state = this.getSourceState();
                            break;
                        }
                    } else {
                        this.reset(sm);
                        StateMachine.throwExpected("hexadecimal value of an unicode character");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private void reset(StateMachine sm) {
                sm.hexBuilder.setLength(0);
            }

            private char extractUnicodeChar(StateMachine sm) {
                return StringEscapeUtils.unescapeJava((String)("\\u" + sm.hexBuilder.toString())).charAt(0);
            }
        }
    }

    public static class JsonParserException
    extends Exception {
        public JsonParserException(String msg) {
            super(msg);
        }
    }
}

