/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsonpath;

import io.ballerina.lib.data.ModuleUtils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;

public class Utils {
    public static final String ERROR = "Error";

    public static BError createError(String message, BError cause) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR, (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public static BError createError(String message) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static String getCannotExecuteQueryErrorMessage(BString query) {
        return "Unable to execute query '" + query.getValue() + "' on the provided JSON value";
    }

    public static String convertRawTemplateToString(BObject rawTemplate) {
        BArray insertionsArray = rawTemplate.getArrayValue(StringUtils.fromString((String)"insertions"));
        BArray stringsArray = rawTemplate.getArrayValue(StringUtils.fromString((String)"strings"));
        int stringArraySize = stringsArray.size();
        if (stringArraySize == 0) {
            return "";
        }
        long insertionLength = insertionsArray.getLength();
        Object query = stringsArray.getBString(0L).getValue();
        for (int i = 1; i < stringArraySize; ++i) {
            String templatedString = "";
            if ((long)(i - 1) < insertionLength) {
                templatedString = StringUtils.getStringValue((Object)insertionsArray.get((long)(i - 1)));
            }
            query = (String)query + templatedString + stringsArray.getBString((long)i).getValue();
        }
        return query;
    }
}

