/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.schema.generator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.graphql.schema.diagnostic.DiagnosticMessages;
import io.ballerina.graphql.schema.exception.SchemaFileGenerationException;
import io.ballerina.graphql.schema.generator.SdlSchema;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.utils.SdlSchemaStringGenerator;
import io.ballerina.stdlib.graphql.commons.utils.Utils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SdlSchemaGenerator {
    private SdlSchemaGenerator() {
    }

    public static void generate(Path filePath, Path outPath, String serviceBasePath, PrintStream outStream) throws SchemaFileGenerationException {
        Document doc;
        DocumentId docId;
        Project project = ProjectLoader.loadProject((Path)filePath);
        PackageCompilation compilation = SdlSchemaGenerator.getPackageCompilation(project);
        Package packageName = project.currentPackage();
        if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            docId = project.documentId(filePath);
            ModuleId moduleId = docId.moduleId();
            doc = project.currentPackage().module(moduleId).document(docId);
        } else {
            Module currentModule = packageName.getDefaultModule();
            docId = (DocumentId)currentModule.documentIds().iterator().next();
            doc = currentModule.document(docId);
        }
        SyntaxTree syntaxTree = doc.syntaxTree();
        SemanticModel semanticModel = compilation.getSemanticModel(docId.moduleId());
        List<SdlSchema> schemaDefinitions = SdlSchemaGenerator.generateSdlSchema(syntaxTree, semanticModel, serviceBasePath);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (SdlSchema definition : schemaDefinitions) {
            String fileName = io.ballerina.graphql.schema.utils.Utils.resolveSchemaFileName(outPath, definition.getName());
            io.ballerina.graphql.schema.utils.Utils.createOutputDirectory(outPath);
            io.ballerina.graphql.schema.utils.Utils.writeFile(outPath.resolve(fileName), definition.getSchema());
            fileNames.add(fileName);
        }
        if (fileNames.isEmpty()) {
            outStream.println("Given Ballerina file does not contain any GraphQL services");
            return;
        }
        outStream.println("SDL Schema(s) generated successfully and copied to :");
        Iterator iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            outStream.println("-- " + (String)iterator.next());
        }
    }

    private static List<SdlSchema> generateSdlSchema(SyntaxTree syntaxTree, SemanticModel semanticModel, String serviceBasePath) throws SchemaFileGenerationException {
        HashMap<String, String> servicesToGenerate = new HashMap<String, String>();
        ArrayList<String> availableServices = new ArrayList<String>();
        ArrayList<SdlSchema> outputs = new ArrayList<SdlSchema>();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        SdlSchemaGenerator.extractSchemaStringsFromServices(serviceBasePath, modulePartNode, semanticModel, availableServices, servicesToGenerate);
        if (serviceBasePath != null && servicesToGenerate.isEmpty()) {
            throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_101, null, serviceBasePath, ((Object)availableServices).toString());
        }
        for (Map.Entry schema : servicesToGenerate.entrySet()) {
            String sdlFileName = io.ballerina.graphql.schema.utils.Utils.getSdlFileName(syntaxTree.filePath(), (String)schema.getKey());
            Schema schemaObject = io.ballerina.graphql.schema.utils.Utils.getDecodedSchema((String)schema.getValue());
            String sdlSchemaString = SdlSchemaStringGenerator.generate((Schema)schemaObject);
            SdlSchema sdlSchema = new SdlSchema(sdlFileName, sdlSchemaString);
            outputs.add(sdlSchema);
        }
        return outputs;
    }

    public static void extractSchemaStringsFromServices(String serviceBasePath, ModulePartNode modulePartNode, SemanticModel semanticModel, List<String> availableServices, Map<String, String> schemasToGenerate) throws SchemaFileGenerationException {
        int duplicateCount = 0;
        for (Node node : modulePartNode.members()) {
            ExpressionNode expressionNode;
            ModuleVariableDeclarationNode moduleVariableNode;
            SyntaxKind syntaxKind = node.kind();
            if (syntaxKind == SyntaxKind.SERVICE_DECLARATION) {
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)node;
                if (!io.ballerina.graphql.schema.utils.Utils.isGraphqlService(serviceNode, semanticModel)) continue;
                String actualBasePath = io.ballerina.graphql.schema.utils.Utils.getServiceBasePath(serviceNode);
                String schema = io.ballerina.graphql.schema.utils.Utils.getSchemaString(serviceNode);
                String updatedServiceName = actualBasePath;
                if (schemasToGenerate.containsKey(actualBasePath)) {
                    updatedServiceName = SdlSchemaGenerator.getUpdatedServiceName(actualBasePath, ++duplicateCount);
                }
                SdlSchemaGenerator.addToList(serviceBasePath, actualBasePath, updatedServiceName, schema, availableServices, schemasToGenerate);
                continue;
            }
            if (syntaxKind != SyntaxKind.MODULE_VAR_DECL || serviceBasePath != null || !Utils.isGraphQLServiceObjectDeclaration((ModuleVariableDeclarationNode)(moduleVariableNode = (ModuleVariableDeclarationNode)node)) || moduleVariableNode.initializer().isEmpty() || (expressionNode = (ExpressionNode)moduleVariableNode.initializer().get()).kind() != SyntaxKind.OBJECT_CONSTRUCTOR) continue;
            ObjectConstructorExpressionNode graphqlServiceObject = (ObjectConstructorExpressionNode)moduleVariableNode.initializer().get();
            String schema = io.ballerina.graphql.schema.utils.Utils.getSchemaString(graphqlServiceObject);
            String service = "";
            if (schemasToGenerate.containsKey(service)) {
                service = SdlSchemaGenerator.getUpdatedServiceName(service, ++duplicateCount);
            }
            schemasToGenerate.put(service, schema);
        }
    }

    private static void addToList(String serviceBasePath, String actualPath, String updateServiceName, String schema, List<String> availableServices, Map<String, String> schemasToGenerate) {
        if (serviceBasePath != null) {
            availableServices.add(actualPath);
            if (io.ballerina.graphql.schema.utils.Utils.formatBasePath(serviceBasePath).equals(actualPath)) {
                schemasToGenerate.put(updateServiceName, schema);
            }
        } else {
            schemasToGenerate.put(updateServiceName, schema);
        }
    }

    private static String getUpdatedServiceName(String serviceName, int duplicateCount) {
        if (serviceName.isBlank()) {
            return "." + duplicateCount;
        }
        return serviceName + "." + duplicateCount;
    }

    private static PackageCompilation getPackageCompilation(Project project) throws SchemaFileGenerationException {
        PackageCompilation compilation;
        DiagnosticResult diagnosticResult = project.currentPackage().runCodeGenAndModifyPlugins();
        boolean hasErrors = diagnosticResult.diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (!hasErrors && !(hasErrors = (compilation = project.currentPackage().getCompilation()).diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity())))) {
            return compilation;
        }
        throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_100, null);
    }
}

