/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.compiler;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.CodeAnalysisContext;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Arrays;

public class TesterinaCodeAnalyzer
extends CodeAnalyzer {
    private static final String INVALID_USAGE_ERROR_CODE = "TEST_101";
    private static final String INVALID_USAGE_ERROR_MESSAGE = "invalid usage of test annotation";

    public void init(CodeAnalysisContext analysisContext) {
        analysisContext.addSyntaxNodeAnalysisTask(syntaxNodeAnalysisContext -> {
            Node patt0$temp = syntaxNodeAnalysisContext.node();
            if (patt0$temp instanceof ClassDefinitionNode) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)patt0$temp;
                classDefinitionNode.members().forEach(member -> TesterinaCodeAnalyzer.validateTestAnnotation(syntaxNodeAnalysisContext, member));
            } else {
                Node patt1$temp = syntaxNodeAnalysisContext.node();
                if (patt1$temp instanceof ServiceDeclarationNode) {
                    ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)patt1$temp;
                    serviceDeclarationNode.members().forEach(member -> TesterinaCodeAnalyzer.validateTestAnnotation(syntaxNodeAnalysisContext, member));
                }
            }
        }, Arrays.asList(SyntaxKind.CLASS_DEFINITION, SyntaxKind.SERVICE_DECLARATION));
    }

    private static void validateTestAnnotation(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, Node member) {
        if (member instanceof FunctionDefinitionNode) {
            FunctionDefinitionNode funcDefNode = (FunctionDefinitionNode)member;
            funcDefNode.metadata().ifPresent(metadata -> metadata.annotations().forEach(annotation -> {
                QualifiedNameReferenceNode qualifiedNameReferenceNode;
                String modulePrefix;
                if (annotation.annotReference().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && "test".equals(modulePrefix = (qualifiedNameReferenceNode = (QualifiedNameReferenceNode)annotation.annotReference()).modulePrefix().text())) {
                    Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)new DiagnosticInfo(INVALID_USAGE_ERROR_CODE, INVALID_USAGE_ERROR_MESSAGE, DiagnosticSeverity.ERROR), (Location)annotation.location(), (Object[])new Object[0]);
                    syntaxNodeAnalysisContext.reportDiagnostic(diagnostic);
                }
            }));
        }
    }
}

