/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.stdlib.websub.task.AnalyserUtils;
import java.util.Optional;

public final class CommonUtil {
    private CommonUtil() {
    }

    public static Optional<AnnotationSymbol> extractSubscriberServiceConfig(ServiceDeclarationSymbol service) {
        return service.annotations().stream().filter(annotationSymbol -> {
            String moduleName = annotationSymbol.getModule().flatMap(Symbol::getName).orElse("");
            String type = annotationSymbol.getName().orElse("");
            String annotationName = AnalyserUtils.getQualifiedType(type, moduleName);
            return annotationName.equals("websub:SubscriberServiceConfig");
        }).findFirst();
    }
}

