/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.action;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.stdlib.websub.action.api.Function;
import io.ballerina.stdlib.websub.action.api.Type;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.List;

public final class CodeActionUtil {
    private CodeActionUtil() {
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static List<Function> constructMandatoryFunctions() {
        List<Function.FunctionArg> functionArgs = CodeActionUtil.constructFunctionArgs();
        Type error = Type.from("annotations", "error");
        List<Type> returnTypes = List.of(error);
        Function onEventNotificationFunction = Function.remoteFunctionWithOptionalReturnTypes("onEventNotification", functionArgs, returnTypes);
        return List.of(onEventNotificationFunction);
    }

    private static List<Function.FunctionArg> constructFunctionArgs() {
        Type contentDistributionMessage = Type.from("websub", "ContentDistributionMessage");
        Function.FunctionArg message = new Function.FunctionArg(contentDistributionMessage, "message");
        return List.of(message);
    }
}

