/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.action;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.websub.Constants;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.stdlib.websub.action.CodeActionUtil;
import io.ballerina.stdlib.websub.action.api.Function;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MandatoryFunctionsGenerationAction
implements CodeAction {
    private final List<Function> mandatoryFunctions = CodeActionUtil.constructMandatoryFunctions();

    public List<String> supportedDiagnosticCodes() {
        return List.of(WebSubDiagnosticCodes.WEBSUB_202.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        return Optional.ofNullable(context.diagnostic()).filter(d -> Objects.nonNull(d.location())).map(this::constructCodeActionInfo);
    }

    private CodeActionInfo constructCodeActionInfo(Diagnostic diagnostic) {
        CodeActionArgument locationArg = CodeActionArgument.from((String)"node.location", (Object)diagnostic.location().lineRange());
        return CodeActionInfo.from((String)"Add mandatory function", List.of(locationArg));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext executionContext) {
        Optional<LineRange> lineRangeOpt = executionContext.arguments().stream().filter(arg -> "node.location".equals(arg.key())).map(arg -> (LineRange)arg.valueAs(LineRange.class)).findFirst();
        if (lineRangeOpt.isEmpty()) {
            return Collections.emptyList();
        }
        LineRange lineRange = lineRangeOpt.get();
        SyntaxTree syntaxTree = executionContext.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, lineRange);
        if (!(node instanceof ServiceDeclarationNode)) {
            return Collections.emptyList();
        }
        List<TextEdit> textEdits = this.retrieveRequiredTextEdits((ServiceDeclarationNode)node);
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        return Collections.singletonList(new DocumentEdit(executionContext.fileUri(), SyntaxTree.from((SyntaxTree)syntaxTree, (TextDocumentChange)change)));
    }

    private List<TextEdit> retrieveRequiredTextEdits(ServiceDeclarationNode serviceNode) {
        TextRange functionTextRange = this.getTextRange(serviceNode);
        String functionCodeSnippet = this.mandatoryFunctions.stream().map(Function::snippetAsAString).collect(Collectors.joining(Constants.LS));
        TextEdit functionsEdit = TextEdit.from((TextRange)functionTextRange, (String)String.format("%s%s%s", Constants.LS, functionCodeSnippet, Constants.LS));
        return List.of(functionsEdit);
    }

    private TextRange getTextRange(ServiceDeclarationNode serviceNode) {
        if (serviceNode.members().isEmpty()) {
            int length = serviceNode.closeBraceToken().textRange().startOffset() - serviceNode.openBraceToken().textRange().endOffset();
            return TextRange.from((int)serviceNode.openBraceToken().textRange().endOffset(), (int)length);
        }
        Node lastMember = serviceNode.members().get(serviceNode.members().size() - 1);
        int length = serviceNode.closeBraceToken().textRange().startOffset() - lastMember.textRange().endOffset();
        return TextRange.from((int)lastMember.textRange().endOffset(), (int)length);
    }

    public String name() {
        return "ADD_MANDATORY_FUNCTION_CODE_SNIPPET";
    }
}

