/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task.service.path;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServicePathContext {
    private final ModuleId moduleId;
    private final DocumentId documentId;
    private final List<ServicePathInformation> servicePathDetails;

    public ServicePathContext(ModuleId moduleId, DocumentId documentId) {
        this.moduleId = moduleId;
        this.documentId = documentId;
        this.servicePathDetails = new ArrayList<ServicePathInformation>();
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public DocumentId getDocumentId() {
        return this.documentId;
    }

    public List<ServicePathInformation> getServicePathDetails() {
        return Collections.unmodifiableList(this.servicePathDetails);
    }

    void updateServicePathDetails(ServicePathInformation servicePathDetails) {
        this.servicePathDetails.add(servicePathDetails);
    }

    public static class ServicePathInformation {
        private final int serviceId;
        private final String servicePath;

        public ServicePathInformation(int serviceId, String servicePath) {
            this.serviceId = serviceId;
            this.servicePath = servicePath;
        }

        public int getServiceId() {
            return this.serviceId;
        }

        public String getServicePath() {
            return this.servicePath;
        }
    }
}

