/*
 * Decompiled with CFR 0.152.
 */
package org.wssec;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import org.wssec.Utils;
import org.wssec.WsSecurityUtils;

public class Encryption {
    private String encryptionAlgorithm;
    private byte[] encryptedData;

    public static void setEncryptionAlgorithm(BObject encrypt, BString encryptionAlgorithm) {
        BHandle handle = (BHandle)encrypt.get(StringUtils.fromString((String)"nativeEncryption"));
        Encryption encryption = (Encryption)handle.getValue();
        encryption.setEncryptionAlgorithm(encryptionAlgorithm.getValue());
    }

    public static void setEncryptedData(BObject encrypt, BArray encryptedData) {
        BHandle handle = (BHandle)encrypt.get(StringUtils.fromString((String)"nativeEncryption"));
        Encryption encryption = (Encryption)handle.getValue();
        encryption.setEncryptedData(encryptedData.getByteArray());
    }

    public static BArray getEncryptedData(BObject encrypt) {
        BHandle handle = (BHandle)encrypt.get(StringUtils.fromString((String)"nativeEncryption"));
        Encryption encryption = (Encryption)handle.getValue();
        return ValueCreator.createArrayValue((byte[])encryption.getEncryptedData());
    }

    public static Object getEncryptedKeyElements(BArray encryptedData) {
        try {
            return WsSecurityUtils.getEncryptedKeyElement(encryptedData.getByteArray());
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    protected String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    protected byte[] getEncryptedData() {
        return this.encryptedData;
    }

    protected void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    protected void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }
}

