/*
 * Decompiled with CFR 0.152.
 */
package org.wssec;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wssec.Encryption;
import org.wssec.Signature;
import org.wssec.Utils;
import org.wssec.WsSecurityHeader;
import org.wssec.WsSecurityUtils;

public final class WsSecurity {
    private WsSecurity() {
    }

    public static Object applyUsernameTokenPolicy(BObject wsSecHeader, BString username, BString password, BString passwordType) {
        BHandle handle = (BHandle)wsSecHeader.get(StringUtils.fromString((String)"nativeSecHeader"));
        WsSecurityHeader wsSecurityHeader = (WsSecurityHeader)handle.getValue();
        WSSecUsernameToken usernameToken = new WSSecUsernameToken(wsSecurityHeader.getWsSecHeader());
        WsSecurityUtils.setUTChildElements(usernameToken, passwordType.getValue(), username.getValue(), password.getValue());
        Document xmlDocument = switch (passwordType.getValue()) {
            case "DERIVED_KEY_TEXT", "DERIVED_KEY_DIGEST" -> {
                usernameToken.addDerivedKey(1000);
                yield usernameToken.build(UsernameTokenUtil.generateSalt((boolean)true));
            }
            default -> usernameToken.build();
        };
        try {
            return WsSecurityUtils.convertDocumentToString(xmlDocument);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object applyTimestampPolicy(BObject wsSecHeader, int timeToLive) {
        BHandle handle = (BHandle)wsSecHeader.get(StringUtils.fromString((String)"nativeSecHeader"));
        WsSecurityHeader wsSecurityHeader = (WsSecurityHeader)handle.getValue();
        WSSecTimestamp timestamp = new WSSecTimestamp(wsSecurityHeader.getWsSecHeader());
        timestamp.setTimeToLive(timeToLive);
        try {
            return WsSecurityUtils.convertDocumentToString(timestamp.build());
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object applySignatureOnlyPolicy(BObject wsSecHeader, BObject balSignature, Object x509FilePath) {
        BHandle handle = (BHandle)wsSecHeader.get(StringUtils.fromString((String)"nativeSecHeader"));
        WsSecurityHeader wsSecurityHeader = (WsSecurityHeader)handle.getValue();
        handle = (BHandle)balSignature.get(StringUtils.fromString((String)"nativeSignature"));
        Signature signature = (Signature)handle.getValue();
        try {
            Document xmlDocument = WsSecurity.createSignatureTags(wsSecurityHeader, x509FilePath);
            WsSecurityUtils.setSignatureValue(xmlDocument, signature.getSignatureValue(), signature.getSignatureAlgorithm());
            return WsSecurityUtils.convertDocumentToString(xmlDocument);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object applyEncryptionOnlyPolicy(BObject wsSecHeader, BObject balEncryption) {
        BHandle handle = (BHandle)wsSecHeader.get(StringUtils.fromString((String)"nativeSecHeader"));
        WsSecurityHeader wsSecurityHeader = (WsSecurityHeader)handle.getValue();
        handle = (BHandle)balEncryption.get(StringUtils.fromString((String)"nativeEncryption"));
        Encryption encryption = (Encryption)handle.getValue();
        try {
            byte[] key = UsernameTokenUtil.generateDerivedKey((String)"password", (byte[])UsernameTokenUtil.generateSalt((boolean)true), (int)1000);
            Document xmlDocument = WsSecurity.encryptEnvelope(wsSecurityHeader, key);
            WsSecurityUtils.setEncryptedData(xmlDocument, encryption.getEncryptedData(), encryption.getEncryptionAlgorithm());
            return WsSecurityUtils.convertDocumentToString(xmlDocument);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Document encryptEnvelope(WsSecurityHeader wsSecurityHeader, byte[] rawKey) throws WSSecurityException {
        Init.init();
        JCEMapper.registerDefaultAlgorithms();
        WSSecDKEncrypt encryptionBuilder = new WSSecDKEncrypt(wsSecurityHeader.getWsSecHeader());
        encryptionBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2009/xmlenc11#aes128-gcm");
        return encryptionBuilder.build(rawKey);
    }

    public static Document createSignatureTags(WsSecurityHeader wsSecurityHeader, Object x509FilePath) throws Exception {
        RequestData reqData = new RequestData();
        reqData.setSecHeader(wsSecurityHeader.getWsSecHeader());
        reqData.setWssConfig(WSSConfig.getNewInstance());
        reqData.setWsDocInfo(new WSDocInfo(wsSecurityHeader.getDocument()));
        WSSecSignature wsSecSignature = WsSecurity.prepareSignature(reqData, x509FilePath);
        WsSecurityUtils.buildSignature(reqData, wsSecSignature);
        return wsSecSignature.build(null);
    }

    public static WSSecSignature prepareSignature(RequestData reqData, Object x509FilePath) {
        WSSecSignature sign = new WSSecSignature(reqData.getSecHeader());
        try {
            byte[] key = UsernameTokenUtil.generateDerivedKey((String)"password", (byte[])UsernameTokenUtil.generateSalt((boolean)true), (int)1000);
            sign.setSecretKey(key);
            sign.setWsDocInfo(reqData.getWsDocInfo());
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sign.setKeyIdentifierType(12);
            if (x509FilePath != null) {
                FileInputStream fis = new FileInputStream(x509FilePath.toString());
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fis);
                sign.setKeyIdentifierType(3);
                sign.setX509Certificate(x509Certificate);
                fis.close();
            }
            sign.prepare(null);
        }
        catch (IOException | CertificateException | WSSecurityException e) {
            throw Utils.createError(e.getMessage());
        }
        return sign;
    }

    public static BMap getReadOnlyClientConfig(BMap securityConfig) {
        securityConfig.freezeDirect();
        return securityConfig;
    }

    public static Object applySignatureOnly(BObject documentBuilder, Boolean soap12, BMap<BString, Object> signatureConfig) {
        Document document = (Document)documentBuilder.getNativeData("nativeDocumentBuilder");
        BMap keyStore = signatureConfig.getMapValue(StringUtils.fromString((String)"keystore"));
        String path = ((BString)keyStore.get((Object)StringUtils.fromString((String)"path"))).toString();
        String password = ((BString)keyStore.get((Object)StringUtils.fromString((String)"password"))).toString();
        String digestAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"digestAlgorithm")).toString();
        String canonicalizationAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"canonicalizationAlgorithm")).toString();
        String signatureAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"signatureAlgorithm")).toString();
        String privateKeyPassword = signatureConfig.get((Object)StringUtils.fromString((String)"privateKeyPassword")).toString();
        String privateKeyAlias = signatureConfig.get((Object)StringUtils.fromString((String)"privateKeyAlias")).toString();
        try {
            WsSecurity.validateSoapHeader(soap12, document);
            WSSecHeader secHeader = new WSSecHeader(document);
            secHeader.insertSecurityHeader();
            Crypto crypto = WsSecurity.getCryptoInstance(path, password);
            WsSecurity.generateSignature(privateKeyPassword, privateKeyAlias, digestAlgorithm, canonicalizationAlgorithm, signatureAlgorithm, crypto, secHeader);
            return WsSecurityUtils.convertDocumentToString(document);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    private static Crypto getCryptoInstance(String path, String password) throws WSSecurityException {
        Properties properties = new Properties();
        properties.put("org.apache.ws.security.crypto.provider", "org.apache.wss4j.common.crypto.Merlin");
        properties.put("org.apache.ws.security.crypto.merlin.keystore.file", path);
        properties.put("org.apache.ws.security.crypto.merlin.keystore.password", password);
        return CryptoFactory.getInstance((Properties)properties);
    }

    private static void validateSoapHeader(Boolean soap12, Document document) {
        Init.init();
        String namespace = soap12 != false ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
        Element header = (Element)document.getElementsByTagNameNS(namespace, "Header").item(0);
        if (header == null) {
            throw new IllegalStateException("SOAP Envelope must have a Header");
        }
    }

    public static Object verifySignature(BObject documentBuilder, BMap<BString, Object> config) {
        Document document = (Document)documentBuilder.getNativeData("nativeDocumentBuilder");
        BMap keyStore = config.getMapValue(StringUtils.fromString((String)"signatureKeystore"));
        String path = ((BString)keyStore.get((Object)StringUtils.fromString((String)"path"))).toString();
        String password = ((BString)keyStore.get((Object)StringUtils.fromString((String)"password"))).toString();
        try {
            WSSecurityEngine secEngine = new WSSecurityEngine();
            RequestData requestData = new RequestData();
            Crypto crypto = WsSecurity.getCryptoInstance(path, password);
            requestData.setSigVerCrypto(crypto);
            CallbackHandler passwordCallbackHandler = callbacks -> {
                for (Callback callback : callbacks) {
                    ((WSPasswordCallback)callback).setPassword("password");
                }
            };
            requestData.setCallbackHandler(passwordCallbackHandler);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            secEngine.setWssConfig(wssConfig);
            Processor processor = (elem, data) -> {
                if ("EncryptedKey".equals(elem.getLocalName())) {
                    return new ArrayList();
                }
                return new EncryptedKeyProcessor().handleToken(elem, data);
            };
            wssConfig.setProcessor(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), processor);
            secEngine.processSecurityHeader(document, requestData);
            return true;
        }
        catch (WSSecurityException e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object decryptEnvelope(BObject documentBuilder, BMap<BString, Object> config) {
        Document encryptedDocument = (Document)documentBuilder.getNativeData("nativeDocumentBuilder");
        BMap keyStore = config.getMapValue(StringUtils.fromString((String)"decryptKeystore"));
        String path = ((BString)keyStore.get((Object)StringUtils.fromString((String)"path"))).toString();
        String password = ((BString)keyStore.get((Object)StringUtils.fromString((String)"password"))).toString();
        WSSecHeader secHeader = new WSSecHeader(encryptedDocument);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        try {
            Crypto crypto = WsSecurity.getCryptoInstance(path, password);
            requestData.setSigVerCrypto(crypto);
            requestData.setDecCrypto(crypto);
            requestData.setSecHeader(secHeader);
            CallbackHandler passwordCallbackHandler = callbacks -> {
                for (Callback callback : callbacks) {
                    ((WSPasswordCallback)callback).setPassword(password);
                }
            };
            requestData.setCallbackHandler(passwordCallbackHandler);
            secEngine.processSecurityHeader(encryptedDocument, requestData);
            documentBuilder.addNativeData("nativeDocumentBuilder", (Object)encryptedDocument);
            return documentBuilder;
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object applyEncryptionOnly(BObject documentBuilder, Boolean soap12, BMap<BString, Object> config) {
        try {
            Document document = (Document)documentBuilder.getNativeData("nativeDocumentBuilder");
            BMap keyStore = config.getMapValue(StringUtils.fromString((String)"keystore"));
            String path = ((BString)keyStore.get((Object)StringUtils.fromString((String)"path"))).toString();
            String password = ((BString)keyStore.get((Object)StringUtils.fromString((String)"password"))).toString();
            String publicKeyAlias = config.get((Object)StringUtils.fromString((String)"publicKeyAlias")).toString();
            String encryptionAlgorithm = config.get((Object)StringUtils.fromString((String)"encryptionAlgorithm")).toString();
            WsSecurity.validateSoapHeader(soap12, document);
            Crypto crypto = WsSecurity.getCryptoInstance(path, password);
            WSSecHeader secHeader = new WSSecHeader(document);
            secHeader.insertSecurityHeader();
            WsSecurity.generateEncryption(publicKeyAlias, crypto, secHeader, encryptionAlgorithm);
            return WsSecurityUtils.convertDocumentToString(document);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static Object applySignatureAndEncryption(BObject documentBuilder, Boolean soap12, BMap<BString, Object> signatureConfig, BMap<BString, Object> encryptionConfig) {
        try {
            Document document = (Document)documentBuilder.getNativeData("nativeDocumentBuilder");
            BMap keyStore = signatureConfig.getMapValue(StringUtils.fromString((String)"keystore"));
            String path = ((BString)keyStore.get((Object)StringUtils.fromString((String)"path"))).toString();
            String password = ((BString)keyStore.get((Object)StringUtils.fromString((String)"password"))).toString();
            String publicKeyAlias = encryptionConfig.get((Object)StringUtils.fromString((String)"publicKeyAlias")).toString();
            String privateKeyPassword = signatureConfig.get((Object)StringUtils.fromString((String)"privateKeyPassword")).toString();
            String privateKeyAlias = signatureConfig.get((Object)StringUtils.fromString((String)"privateKeyAlias")).toString();
            String digestAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"digestAlgorithm")).toString();
            String canonicalizationAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"canonicalizationAlgorithm")).toString();
            String signatureAlgorithm = signatureConfig.get((Object)StringUtils.fromString((String)"signatureAlgorithm")).toString();
            String encryptionAlgorithm = encryptionConfig.get((Object)StringUtils.fromString((String)"encryptionAlgorithm")).toString();
            WsSecurity.validateSoapHeader(soap12, document);
            Crypto crypto = WsSecurity.getCryptoInstance(path, password);
            WSSecHeader secHeader = new WSSecHeader(document);
            secHeader.insertSecurityHeader();
            WsSecurity.generateSignature(privateKeyPassword, privateKeyAlias, digestAlgorithm, canonicalizationAlgorithm, signatureAlgorithm, crypto, secHeader);
            WsSecurity.generateEncryption(publicKeyAlias, crypto, secHeader, encryptionAlgorithm);
            return WsSecurityUtils.convertDocumentToString(document);
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    private static void generateEncryption(String publicKeyAlias, Crypto crypto, WSSecHeader secHeader, String encryptionAlgorithm) throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo(publicKeyAlias);
        encrypt.setKeyIdentifierType(3);
        encrypt.setSymmetricEncAlgorithm(encryptionAlgorithm);
        encrypt.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        SecretKey symmetricKey = WsSecurity.generateSymmetricKey();
        encrypt.build(crypto, symmetricKey);
    }

    private static void generateSignature(String privateKeyPassword, String privateKeyAlias, String digestAlgorithm, String canonicalizationAlgorithm, String signatureAlgorithm, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        WSSecSignature signature = new WSSecSignature(secHeader);
        signature.setUserInfo(privateKeyAlias, privateKeyPassword);
        signature.setKeyIdentifierType(3);
        signature.setSigCanonicalization(canonicalizationAlgorithm);
        signature.setDigestAlgo(digestAlgorithm);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.build(crypto);
    }

    public static SecretKey generateSymmetricKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        return keyGen.generateKey();
    }
}

