/*
 * Decompiled with CFR 0.152.
 */
package org.wssec;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BObject;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.w3c.dom.Document;
import org.wssec.Utils;

public class WsSecurityHeader {
    private final WSSecHeader wsSecHeader;
    private final Document document;

    public WsSecurityHeader(BObject documentBuilder) {
        Document document = (Document)documentBuilder.getNativeData().get("nativeDocumentBuilder");
        this.wsSecHeader = new WSSecHeader(document);
        this.document = document;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected WSSecHeader getWsSecHeader() {
        return this.wsSecHeader;
    }

    public static BError insertSecHeader(BObject secHeader) {
        BHandle handle = (BHandle)secHeader.get(StringUtils.fromString((String)"nativeSecHeader"));
        WsSecurityHeader wsSecurityHeader = (WsSecurityHeader)handle.getValue();
        try {
            wsSecurityHeader.getWsSecHeader().insertSecurityHeader();
        }
        catch (WSSecurityException e) {
            return Utils.createError(e.getMessage());
        }
        return null;
    }
}

