/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.emitter;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.common.YamlEvent;
import io.ballerina.lib.data.yaml.utils.Constants;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.List;

public class Emitter {
    private Emitter() {
    }

    public static List<BString> emit(EmitterState state, boolean isStream) {
        if (isStream) {
            ArrayList<BString> output = new ArrayList<BString>();
            boolean isFirstEvent = true;
            while (!state.events.isEmpty()) {
                Emitter.write(state);
                output.addAll(state.getDocument(!isFirstEvent));
                isFirstEvent = false;
            }
            return output;
        }
        Emitter.write(state);
        return state.getDocument();
    }

    private static void write(EmitterState state) {
        YamlEvent event = Emitter.getEvent(state);
        if (event.getKind() == YamlEvent.EventKind.START_EVENT) {
            YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
            Types.Collection startType = startEvent.getStartType();
            if (startType == Types.Collection.SEQUENCE) {
                if (startEvent.isFlowStyle()) {
                    state.addLine(Emitter.writeFlowSequence(state, event.getTag()));
                } else {
                    Emitter.writeBlockSequence(state, "", event.getTag());
                }
                return;
            }
            if (startType == Types.Collection.MAPPING) {
                if (startEvent.isFlowStyle()) {
                    state.addLine(Emitter.writeFlowMapping(state, event.getTag()));
                } else {
                    Emitter.writeBlockMapping(state, "");
                }
                return;
            }
        }
        if (event.getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
            YamlEvent.ScalarEvent scalarEvent = (YamlEvent.ScalarEvent)event;
            state.addLine(Emitter.writeNode(state, scalarEvent.getValue(), event.getTag()));
        }
    }

    private static String writeNode(EmitterState state, String value, String tag) {
        return Emitter.writeNode(state, value, tag, false);
    }

    private static String writeNode(EmitterState state, String value, String tag, boolean tagAsSuffix) {
        if (tag == null) {
            return value;
        }
        if (tag.startsWith("tag:yaml.org,2002:")) {
            return state.canonical ? Emitter.appendTagToValue(tagAsSuffix, "!!" + tag.substring("tag:yaml.org,2002:".length()), value) : value;
        }
        return "";
    }

    private static void writeBlockMapping(EmitterState state, String whitespace) {
        YamlEvent event = Emitter.getEvent(state);
        while (true) {
            YamlEvent.ScalarEvent scalarEvent;
            Object line = "";
            if (event.getKind() == YamlEvent.EventKind.END_EVENT) break;
            if (event.getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                scalarEvent = (YamlEvent.ScalarEvent)event;
                line = (String)line + whitespace + Emitter.writeNode(state, scalarEvent.getValue(), event.getTag()) + ": ";
            }
            if ((event = Emitter.getEvent(state)).getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                scalarEvent = (YamlEvent.ScalarEvent)event;
                line = (String)line + Emitter.writeNode(state, scalarEvent.getValue(), event.getTag());
                state.addLine((String)line);
            }
            if (event.getKind() == YamlEvent.EventKind.START_EVENT) {
                YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
                if (startEvent.getStartType() == Types.Collection.SEQUENCE) {
                    if (startEvent.isFlowStyle()) {
                        state.addLine((String)line + Emitter.writeFlowSequence(state, event.getTag()));
                    } else {
                        state.addLine(Emitter.writeNode(state, ((String)line).substring(0, ((String)line).length() - 1), event.getTag(), true));
                        Emitter.writeBlockSequence(state, whitespace, event.getTag());
                    }
                } else if (startEvent.getStartType() == Types.Collection.MAPPING) {
                    if (startEvent.isFlowStyle()) {
                        state.addLine((String)line + Emitter.writeFlowMapping(state, event.getTag()));
                    } else {
                        state.addLine(Emitter.writeNode(state, ((String)line).substring(0, ((String)line).length() - 1), event.getTag(), true));
                        Emitter.writeBlockMapping(state, whitespace + state.indent);
                    }
                }
            }
            event = Emitter.getEvent(state);
        }
    }

    private static String writeFlowMapping(EmitterState state, String tag) {
        StringBuilder line = new StringBuilder(Emitter.writeNode(state, "{", tag));
        YamlEvent event = Emitter.getEvent(state);
        boolean isFirstValue = true;
        while (event.getKind() != YamlEvent.EventKind.END_EVENT) {
            YamlEvent.ScalarEvent scalarEvent;
            if (!isFirstValue) {
                line.append(", ");
            }
            if (event.getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                scalarEvent = (YamlEvent.ScalarEvent)event;
                line.append(Emitter.writeNode(state, scalarEvent.getValue(), event.getTag())).append(": ");
            }
            if ((event = Emitter.getEvent(state)).getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                scalarEvent = (YamlEvent.ScalarEvent)event;
                line.append(Emitter.writeNode(state, scalarEvent.getValue(), event.getTag()));
            }
            if (event.getKind() == YamlEvent.EventKind.START_EVENT) {
                YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
                if (startEvent.getStartType() == Types.Collection.SEQUENCE) {
                    line.append(Emitter.writeFlowSequence(state, event.getTag()));
                } else if (startEvent.getStartType() == Types.Collection.MAPPING) {
                    line.append(Emitter.writeFlowMapping(state, event.getTag()));
                }
            }
            event = Emitter.getEvent(state);
            isFirstValue = false;
        }
        line.append("}");
        return line.toString();
    }

    private static void writeBlockSequence(EmitterState state, String whitespace, String tag) {
        YamlEvent event = Emitter.getEvent(state);
        boolean emptySequence = true;
        while (true) {
            if (event.getKind() == YamlEvent.EventKind.END_EVENT) {
                if (!emptySequence) break;
                state.addLine(whitespace + Emitter.writeNode(state, "-", tag, true));
                break;
            }
            if (event.getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                YamlEvent.ScalarEvent scalarEvent = (YamlEvent.ScalarEvent)event;
                state.addLine(whitespace + "- " + Emitter.writeNode(state, scalarEvent.getValue(), event.getTag()));
            }
            if (event.getKind() == YamlEvent.EventKind.START_EVENT) {
                YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
                if (startEvent.getStartType() == Types.Collection.SEQUENCE) {
                    if (startEvent.isFlowStyle()) {
                        state.addLine(whitespace + "- " + Emitter.writeFlowSequence(state, event.getTag()));
                    } else {
                        state.addLine(whitespace + Emitter.writeNode(state, "-", event.getTag(), true));
                        Emitter.writeBlockSequence(state, whitespace + state.indent, event.getTag());
                    }
                } else if (startEvent.getStartType() == Types.Collection.MAPPING) {
                    if (startEvent.isFlowStyle()) {
                        state.addLine(whitespace + "- " + Emitter.writeFlowMapping(state, event.getTag()));
                    } else {
                        state.addLine(whitespace + "-");
                        Emitter.writeBlockMapping(state, whitespace + state.indent);
                    }
                }
            }
            event = Emitter.getEvent(state);
            emptySequence = false;
        }
    }

    private static String writeFlowSequence(EmitterState state, String tag) {
        StringBuilder line = new StringBuilder(Emitter.writeNode(state, "[", tag));
        YamlEvent event = Emitter.getEvent(state);
        boolean firstValue = true;
        while (event.getKind() != YamlEvent.EventKind.END_EVENT) {
            if (!firstValue) {
                line.append(", ");
            }
            if (event.getKind() == YamlEvent.EventKind.SCALAR_EVENT) {
                YamlEvent.ScalarEvent scalarEvent = (YamlEvent.ScalarEvent)event;
                line.append(Emitter.writeNode(state, scalarEvent.getValue(), event.getTag()));
            }
            if (event.getKind() == YamlEvent.EventKind.START_EVENT) {
                YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
                if (startEvent.getStartType() == Types.Collection.SEQUENCE) {
                    line.append(Emitter.writeFlowSequence(state, event.getTag()));
                } else if (startEvent.getStartType() == Types.Collection.MAPPING) {
                    line.append(Emitter.writeFlowMapping(state, event.getTag()));
                }
            }
            event = Emitter.getEvent(state);
            firstValue = false;
        }
        line.append("]");
        return line.toString();
    }

    public static YamlEvent getEvent(EmitterState state) {
        return state.events.remove(0);
    }

    public static String appendTagToValue(boolean tagAsSuffix, String tag, String value) {
        return tagAsSuffix ? value + " " + tag : tag + " " + value;
    }

    public static class EmitterState {
        List<BString> document;
        final String indent;
        final boolean canonical;
        boolean lastBareDoc = false;
        final List<YamlEvent> events;

        public EmitterState(List<YamlEvent> events, int indentationPolicy, boolean canonical) {
            this.events = events;
            this.canonical = canonical;
            this.document = new ArrayList<BString>();
            this.indent = " ".repeat(indentationPolicy);
        }

        public void addLine(String line) {
            this.document.add(StringUtils.fromString((String)line));
        }

        public List<BString> getDocument() {
            return this.getDocument(false);
        }

        public List<BString> getDocument(boolean isStream) {
            ArrayList<BString> output = new ArrayList<BString>(this.document.stream().toList());
            if (isStream && this.document.size() > 0) {
                output.add(0, Constants.START_OF_YAML_DOCUMENT);
                this.lastBareDoc = true;
            }
            this.document = new ArrayList<BString>();
            return output;
        }
    }
}

