/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.lib.data.yaml.utils.Error;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class CharacterReader {
    private final Reader reader;
    private final char[] buff;
    private int[] dataBuffer;
    private int dataBufferSize = 0;
    private int remainingBufferedSize = 0;
    private int pointer = 0;
    private boolean eof = false;
    private int line = 1;
    private int column = 0;

    public CharacterReader(Reader reader) {
        this.reader = reader;
        this.dataBuffer = new int[0];
        this.buff = new char[1024];
    }

    public int peek(int k) {
        if (k >= 0 && this.checkAndReadData(k) && this.pointer + k >= 0) {
            return this.dataBuffer[this.pointer + k];
        }
        return -1;
    }

    public boolean forward(int k) {
        int i;
        for (i = 0; i < k && this.checkAndReadData(k); ++i) {
            int codePoint;
            if (this.hasNewLine(codePoint = this.dataBuffer[this.pointer++])) {
                this.remainingBufferedSize -= this.column + 1;
                this.column = 0;
                ++this.line;
                continue;
            }
            if (codePoint == 65279) continue;
            ++this.column;
        }
        return i == 0;
    }

    private boolean hasNewLine(int codePoint) {
        return codePoint == 10;
    }

    private boolean checkAndReadData(int k) {
        if (!this.eof && this.pointer + k >= this.dataBufferSize) {
            this.readData();
        }
        return this.pointer + k < this.dataBufferSize;
    }

    private void readData() {
        try {
            int size = this.reader.read(this.buff);
            if (size <= 0) {
                this.eof = true;
                return;
            }
            int cpIndex = this.dataBufferSize - this.pointer;
            this.dataBuffer = Arrays.copyOfRange(this.dataBuffer, this.pointer, this.dataBufferSize + size);
            int i = 0;
            while (i < size) {
                int codePoint;
                this.dataBuffer[cpIndex] = codePoint = Character.codePointAt(this.buff, i);
                if (CharacterReader.isPrintable(codePoint)) {
                    i += Character.charCount(codePoint);
                } else {
                    NewLineIndexData newLineIndexData = this.findLastNewLineIndexAndNewLineCount();
                    this.line += newLineIndexData.newLineCount;
                    this.column += newLineIndexData.lastNewLineIndex == -1 ? cpIndex : cpIndex - newLineIndexData.lastNewLineIndex;
                    throw new Error.YamlParserException("non printable character found", this.line, this.column);
                }
                ++cpIndex;
            }
            this.remainingBufferedSize = this.dataBufferSize = cpIndex;
            this.pointer = 0;
        }
        catch (Error.YamlParserException e) {
            throw DiagnosticLog.error(DiagnosticErrorCode.YAML_PARSER_EXCEPTION, e.getMessage(), this.line, this.column);
        }
        catch (IOException e) {
            throw DiagnosticLog.error(DiagnosticErrorCode.YAML_READER_FAILURE, e.getMessage());
        }
    }

    private NewLineIndexData findLastNewLineIndexAndNewLineCount() {
        int idx = -1;
        int count = 0;
        for (int i = 0; i < this.dataBuffer.length; ++i) {
            if (this.dataBuffer[i] != 10) continue;
            idx = i;
            ++count;
        }
        return new NewLineIndexData(idx, count);
    }

    private static boolean isPrintable(int codePoint) {
        return codePoint >= 32 && codePoint <= 126 || codePoint >= 160 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint == 133;
    }

    public boolean isEof() {
        return this.eof;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRemainingBufferedSize() {
        return this.remainingBufferedSize;
    }

    private record NewLineIndexData(int lastNewLineIndex, int newLineCount) {
    }
}

