/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.lexer.CharacterReader;
import io.ballerina.lib.data.yaml.lexer.IndentUtils;
import io.ballerina.lib.data.yaml.lexer.Scanner;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.lexer.Utils;
import io.ballerina.lib.data.yaml.utils.Error;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LexerState {
    public static final State LEXER_START_STATE = new StartState();
    public static final State LEXER_TAG_HANDLE_STATE = new TagHandleState();
    public static final State LEXER_TAG_PREFIX_STATE = new TagPrefixState();
    public static final State LEXER_NODE_PROPERTY = new NodePropertyState();
    public static final State LEXER_DIRECTIVE = new DirectiveState();
    public static final State LEXER_DOUBLE_QUOTE = new DoubleQuoteState();
    public static final State LEXER_SINGLE_QUOTE = new SingleQuoteState();
    public static final State LEXER_BLOCK_HEADER = new BlockHeaderState();
    public static final State LEXER_BLOCK_SCALAR = new BlockScalarState();
    public static final State LEXER_RESERVED_DIRECTIVE = new ReservedDirectiveState();
    private State state = LEXER_START_STATE;
    private final CharacterReader characterReader;
    private Token.TokenType token = null;
    private String lexeme = "";
    private String lexemeBuffer = "";
    private IndentUtils.Indentation indentation = null;
    private int tabInWhitespace = -1;
    private int numOpenedFlowCollections = 0;
    private int indent = -1;
    private int indentStartIndex = -1;
    private boolean indentationBreak = false;
    private boolean enforceMapping = false;
    private boolean keyDefinedForLine = false;
    private Stack<IndentUtils.Indent> indents = new Stack();
    private List<Token.TokenType> tokensForMappingValue = new ArrayList<Token.TokenType>();
    private boolean isJsonKey = false;
    private int mappingKeyColumn = -1;
    private int addIndent = 1;
    private boolean captureIndent;
    private boolean firstLine = true;
    private boolean trailingComment = false;
    private boolean allowTokensAsPlanar = false;
    private int lastEscapedChar = -1;
    private boolean eofStream = false;

    public LexerState(CharacterReader characterReader) {
        this.characterReader = characterReader;
    }

    public int peek() {
        return this.peek(0);
    }

    public int peek(int k) {
        return this.characterReader.peek(k);
    }

    public void forward() {
        this.eofStream = this.characterReader.forward(1);
    }

    public void forward(int k) {
        this.eofStream = this.characterReader.forward(k);
    }

    public void updateStartIndex() {
        this.updateStartIndex(null);
    }

    public void updateStartIndex(Token.TokenType token) {
        int column;
        if (token != null) {
            this.tokensForMappingValue.add(token);
        }
        if ((column = this.getColumn()) < this.indentStartIndex || this.indentStartIndex < 0) {
            this.indentStartIndex = column;
        }
    }

    public void resetState() {
        this.addIndent = 1;
        this.captureIndent = false;
        this.enforceMapping = false;
        this.indentStartIndex = -1;
        this.indent = -1;
        this.indents = new Stack();
        this.lexeme = "";
        this.state = LEXER_START_STATE;
    }

    public Token getToken() {
        Token.TokenType tokenBuffer = this.token;
        this.token = Token.TokenType.DUMMY;
        String lexemeBuffer = this.lexeme;
        this.lexeme = "";
        IndentUtils.Indentation indentationBuffer = this.indentation;
        this.indentation = null;
        return new Token(tokenBuffer, lexemeBuffer, indentationBuffer);
    }

    public State getState() {
        return this.state;
    }

    public void updateLexerState(State state) {
        this.state = state;
    }

    public void updateFirstTabIndex() {
        int column = this.getColumn();
        if (column < this.tabInWhitespace || this.tabInWhitespace < 0) {
            this.tabInWhitespace = column;
        }
    }

    public void tokenize(Token.TokenType token) {
        this.token = token;
    }

    public int getColumn() {
        return this.characterReader.getColumn();
    }

    public int getRemainingBufferedSize() {
        return this.characterReader.getRemainingBufferedSize();
    }

    public boolean isFlowCollection() {
        return this.numOpenedFlowCollections > 0;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setIndentationBreak(boolean indentationBreak) {
        this.indentationBreak = indentationBreak;
    }

    public int getTabInWhitespace() {
        return this.tabInWhitespace;
    }

    public boolean getEnforceMapping() {
        return this.enforceMapping;
    }

    public void setEnforceMapping(boolean enforceMapping) {
        this.enforceMapping = enforceMapping;
    }

    public int getIndentStartIndex() {
        return this.indentStartIndex;
    }

    public void setLexeme(String value) {
        this.lexeme = value;
    }

    public void appendToLexeme(String value) {
        this.lexeme = this.lexeme + value;
    }

    public void setKeyDefinedForLine(boolean keyDefinedForLine) {
        this.keyDefinedForLine = keyDefinedForLine;
    }

    public Stack<IndentUtils.Indent> getIndents() {
        return this.indents;
    }

    public List<Token.TokenType> getClonedTokensForMappingValue() {
        return List.copyOf(this.tokensForMappingValue);
    }

    public void setIndentation(IndentUtils.Indentation indentation) {
        this.indentation = indentation;
    }

    public String getLexeme() {
        return this.lexeme;
    }

    public String getLexemeBuffer() {
        return this.lexemeBuffer;
    }

    public void setLexemeBuffer(String lexemeBuffer) {
        this.lexemeBuffer = lexemeBuffer;
    }

    public boolean isIndentationBreak() {
        return this.indentationBreak;
    }

    public boolean isJsonKey() {
        return this.isJsonKey;
    }

    public void setJsonKey(boolean jsonKey) {
        this.isJsonKey = jsonKey;
    }

    public void setTrailingComment(boolean trailingComment) {
        this.trailingComment = trailingComment;
    }

    public boolean isFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(boolean firstLine) {
        this.firstLine = firstLine;
    }

    public void setAllowTokensAsPlanar(boolean allowTokensAsPlanar) {
        this.allowTokensAsPlanar = allowTokensAsPlanar;
    }

    public boolean isEndOfStream() {
        return this.eofStream && this.characterReader.isEof();
    }

    public int getLastEscapedChar() {
        return this.lastEscapedChar;
    }

    public void setLastEscapedChar(int lastEscapedChar) {
        this.lastEscapedChar = lastEscapedChar;
    }

    public void setEofStream(boolean eofStream) {
        this.eofStream = eofStream;
    }

    public int getLine() {
        return this.characterReader.getLine();
    }

    public void updateNewLineProps() {
        this.lastEscapedChar = -1;
        this.indentStartIndex = -1;
        this.tokensForMappingValue = new ArrayList<Token.TokenType>();
        this.tabInWhitespace = -1;
        this.keyDefinedForLine = false;
    }

    public static interface State {
        public State transition(LexerState var1) throws Error.YamlParserException;
    }

    private static class StartState
    implements State {
        private StartState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            boolean isFirstChar = lexerState.getColumn() == 0;
            boolean startsWithWhiteSpace = false;
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                startsWithWhiteSpace = true;
            }
            if (lexerState.isFlowCollection() && isFirstChar && lexerState.peek() != -1) {
                IndentUtils.assertIndent(lexerState);
                if (IndentUtils.isTabInIndent(lexerState, lexerState.getIndent())) {
                    throw new Error.YamlParserException("cannot have tabs as an indentation", lexerState.getLine(), lexerState.getColumn());
                }
            }
            if (startsWithWhiteSpace) {
                if (lexerState.peek() == -1 && isFirstChar) {
                    lexerState.tokenize(Token.TokenType.EMPTY_LINE);
                }
                return this;
            }
            if (Utils.isComment(lexerState)) {
                Scanner.iterate(lexerState, Scanner.COMMENT_SCANNER, Token.TokenType.COMMENT);
                lexerState.tokenize(Token.TokenType.COMMENT);
                return this;
            }
            if (Utils.isMarker(lexerState, true)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DIRECTIVE_MARKER);
                return this;
            }
            if (Utils.isMarker(lexerState, false)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DOCUMENT_MARKER);
                return this;
            }
            switch (lexerState.peek()) {
                case 45: {
                    if (Utils.discernPlanarFromIndicator(lexerState)) {
                        lexerState.updateStartIndex();
                        lexerState.forward();
                        lexerState.lexeme = lexerState.lexeme + "-";
                        IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.PLANAR_CHAR, Scanner.PLANAR_CHAR_SCANNER);
                        return this;
                    }
                    if (lexerState.indent < lexerState.getColumn() && lexerState.allowTokensAsPlanar) {
                        lexerState.lexeme = lexerState.lexeme + "-";
                        lexerState.forward();
                        Scanner.iterate(lexerState, Scanner.PLANAR_CHAR_SCANNER, Token.TokenType.PLANAR_CHAR);
                        return this;
                    }
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.SEQUENCE_ENTRY);
                    lexerState.indentation = IndentUtils.handleIndent(lexerState);
                    return this;
                }
                case 42: {
                    lexerState.updateStartIndex();
                    lexerState.forward();
                    IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.ALIAS, Scanner.ANCHOR_NAME_SCANNER);
                    return this;
                }
                case 37: {
                    if (lexerState.allowTokensAsPlanar) {
                        IndentUtils.assertIndent(lexerState, 1);
                        lexerState.lexeme = lexerState.lexeme + "%";
                        Scanner.iterate(lexerState, Scanner.PLANAR_CHAR_SCANNER, Token.TokenType.PLANAR_CHAR);
                        return this;
                    }
                    lexerState.forward();
                    Scanner.iterate(lexerState, Scanner.PRINTABLE_CHAR_SCANNER, Token.TokenType.DIRECTIVE);
                    return this;
                }
                case 33: {
                    if (lexerState.allowTokensAsPlanar) {
                        IndentUtils.assertIndent(lexerState, 1);
                        lexerState.forward();
                        lexerState.lexeme = lexerState.lexeme + "!";
                        Scanner.iterate(lexerState, Scanner.PLANAR_CHAR_SCANNER, Token.TokenType.PLANAR_CHAR);
                        return this;
                    }
                    IndentUtils.assertIndent(lexerState, 1, true);
                    lexerState.updateStartIndex(Token.TokenType.TAG);
                    switch (lexerState.peek(1)) {
                        case 60: {
                            lexerState.forward(2);
                            if (lexerState.peek() == 33 && lexerState.peek(1) == 62) {
                                throw new Error.YamlParserException("'verbatim tag' is not resolved. Hence, '!' is invalid", lexerState.getLine(), lexerState.getColumn());
                            }
                            int peek = lexerState.peek();
                            if (peek != -1 && (Utils.URI_PATTERN.pattern(peek) || Utils.WORD_PATTERN.pattern(peek))) {
                                Scanner.iterate(lexerState, Scanner.VERBATIM_URI_SCANNER, Token.TokenType.TAG, true);
                                return this;
                            }
                            throw new Error.YamlParserException("expected a 'uri-char' after '<' in a 'verbatim tag'", lexerState.getLine(), lexerState.getColumn());
                        }
                        case -1: 
                        case 9: 
                        case 32: {
                            lexerState.lexeme = "!";
                            lexerState.forward();
                            lexerState.tokenize(Token.TokenType.TAG);
                            return this;
                        }
                        case 33: {
                            lexerState.lexeme = "!!";
                            lexerState.forward(2);
                            lexerState.tokenize(Token.TokenType.TAG_HANDLE);
                            return this;
                        }
                    }
                    lexerState.lexeme = "!";
                    lexerState.forward();
                    Scanner.iterate(lexerState, Scanner.DIFF_TAG_HANDLE_SCANNER, Token.TokenType.TAG_HANDLE, true);
                    return this;
                }
                case 38: {
                    IndentUtils.assertIndent(lexerState, 1);
                    if (lexerState.allowTokensAsPlanar) {
                        lexerState.forward();
                        lexerState.lexeme = lexerState.lexeme + "&";
                        Scanner.iterate(lexerState, Scanner.PLANAR_CHAR_SCANNER, Token.TokenType.PLANAR_CHAR);
                        return this;
                    }
                    IndentUtils.assertIndent(lexerState, 1, true);
                    lexerState.updateStartIndex(Token.TokenType.ANCHOR);
                    lexerState.forward();
                    Scanner.iterate(lexerState, Scanner.ANCHOR_NAME_SCANNER, Token.TokenType.ANCHOR);
                    return this;
                }
                case 58: {
                    if (!lexerState.isJsonKey && Utils.discernPlanarFromIndicator(lexerState)) {
                        lexerState.lexeme = lexerState.lexeme + ":";
                        lexerState.updateStartIndex();
                        lexerState.forward();
                        IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.PLANAR_CHAR, Scanner.PLANAR_CHAR_SCANNER);
                        return this;
                    }
                    if (!lexerState.keyDefinedForLine && !lexerState.isFlowCollection()) {
                        if (lexerState.mappingKeyColumn != lexerState.getColumn() && !lexerState.isFlowCollection() && lexerState.mappingKeyColumn > -1) {
                            throw new Error.YamlParserException("'?' and ':' should have the same indentation", lexerState.getLine(), lexerState.getColumn());
                        }
                        if (lexerState.mappingKeyColumn == -1) {
                            lexerState.updateStartIndex();
                            lexerState.keyDefinedForLine = true;
                            lexerState.indentation = IndentUtils.handleIndent(lexerState, lexerState.indentStartIndex);
                        }
                        lexerState.mappingKeyColumn = -1;
                    }
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.MAPPING_VALUE);
                    return this;
                }
                case 63: {
                    if (Utils.discernPlanarFromIndicator(lexerState)) {
                        lexerState.lexeme = lexerState.lexeme + "?";
                        lexerState.updateStartIndex();
                        lexerState.forward();
                        IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.PLANAR_CHAR, Scanner.PLANAR_CHAR_SCANNER);
                        return this;
                    }
                    lexerState.mappingKeyColumn = lexerState.getColumn();
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.MAPPING_KEY);
                    if (!lexerState.isFlowCollection()) {
                        lexerState.indentation = IndentUtils.handleIndent(lexerState, lexerState.getColumn() - 1);
                    }
                    return this;
                }
                case 34: {
                    lexerState.updateStartIndex();
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.DOUBLE_QUOTE_DELIMITER);
                    return this;
                }
                case 39: {
                    lexerState.updateStartIndex();
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.SINGLE_QUOTE_DELIMITER);
                    return this;
                }
                case 44: {
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.SEPARATOR);
                    return this;
                }
                case 91: {
                    IndentUtils.assertIndent(lexerState, 1);
                    ++lexerState.numOpenedFlowCollections;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.SEQUENCE_START);
                    return this;
                }
                case 93: {
                    --lexerState.numOpenedFlowCollections;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.SEQUENCE_END);
                    return this;
                }
                case 123: {
                    IndentUtils.assertIndent(lexerState, 1);
                    ++lexerState.numOpenedFlowCollections;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.MAPPING_START);
                    return this;
                }
                case 125: {
                    --lexerState.numOpenedFlowCollections;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.MAPPING_END);
                    return this;
                }
                case 124: {
                    lexerState.addIndent = 1;
                    lexerState.captureIndent = true;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.LITERAL);
                    return this;
                }
                case 62: {
                    lexerState.addIndent = 1;
                    lexerState.captureIndent = true;
                    lexerState.forward();
                    lexerState.tokenize(Token.TokenType.FOLDED);
                    return this;
                }
            }
            if (Utils.isPlainSafe(lexerState)) {
                IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.PLANAR_CHAR, Scanner.PLANAR_CHAR_SCANNER);
                return this;
            }
            throw new Error.YamlParserException("invalid yaml document", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class TagHandleState
    implements State {
        private TagHandleState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (lexerState.peek() == 33) {
                switch (lexerState.peek(1)) {
                    case 9: 
                    case 32: {
                        lexerState.lexeme = "!";
                        lexerState.forward();
                        lexerState.tokenize(Token.TokenType.TAG_HANDLE);
                        return this;
                    }
                    case 33: {
                        lexerState.lexeme = "!!";
                        lexerState.forward(2);
                        lexerState.tokenize(Token.TokenType.TAG_HANDLE);
                        return this;
                    }
                    case -1: {
                        throw new Error.YamlParserException("expected a separation in line after primary tag handle", lexerState.getLine(), lexerState.getColumn());
                    }
                }
                lexerState.lexeme = "!";
                lexerState.forward();
                Scanner.iterate(lexerState, Scanner.TAG_HANDLE_SCANNER, Token.TokenType.TAG_HANDLE, true);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                return this;
            }
            throw new Error.YamlParserException("expected '!' to start the tag handle", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class TagPrefixState
    implements State {
        private TagPrefixState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (Utils.matchPattern(lexerState, List.of(Utils.URI_PATTERN, Utils.WORD_PATTERN, new Utils.CharPattern('%')), List.of(Utils.FLOW_INDICATOR_PATTERN))) {
                Scanner.iterate(lexerState, Scanner.URI_SCANNER, Token.TokenType.TAG_PREFIX);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                return this;
            }
            throw new Error.YamlParserException("invalid tag prefix character", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class NodePropertyState
    implements State {
        private NodePropertyState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (lexerState.peek() == 38) {
                lexerState.forward();
                Scanner.iterate(lexerState, Scanner.ANCHOR_NAME_SCANNER, Token.TokenType.ANCHOR);
                return this;
            }
            if (Utils.isTagChar(lexerState)) {
                Scanner.iterate(lexerState, Scanner.TAG_CHARACTER_SCANNER, Token.TokenType.TAG);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                return this;
            }
            throw new Error.YamlParserException("invalid character tag", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class DirectiveState
    implements State {
        private DirectiveState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (Utils.matchPattern(lexerState, List.of(Utils.DECIMAL_PATTERN))) {
                Scanner.iterate(lexerState, Scanner.DIGIT_SCANNER, Token.TokenType.DECIMAL);
                return this;
            }
            if (lexerState.peek() == 46) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DOT);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                return this;
            }
            throw new Error.YamlParserException("invalid version number character", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class DoubleQuoteState
    implements State {
        private DoubleQuoteState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (Utils.isMarker(lexerState, true)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DIRECTIVE_MARKER);
                return this;
            }
            if (Utils.isMarker(lexerState, false)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DOCUMENT_MARKER);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                String whitespace = Utils.getWhitespace(lexerState);
                if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                    return this;
                }
                if (lexerState.firstLine) {
                    lexerState.lexeme = lexerState.lexeme + whitespace;
                }
            }
            if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                return this;
            }
            if (lexerState.peek() == 34) {
                IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.DOUBLE_QUOTE_DELIMITER);
                return this;
            }
            Scanner.iterate(lexerState, Scanner.DOUBLE_QUOTE_CHAR_SCANNER, Token.TokenType.DOUBLE_QUOTE_CHAR);
            return this;
        }
    }

    private static class SingleQuoteState
    implements State {
        private SingleQuoteState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (Utils.isMarker(lexerState, true)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DIRECTIVE_MARKER);
                return this;
            }
            if (Utils.isMarker(lexerState, false)) {
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.DOCUMENT_MARKER);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                String whitespace = Utils.getWhitespace(lexerState);
                if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                    return this;
                }
                if (lexerState.firstLine) {
                    lexerState.lexeme = lexerState.lexeme + whitespace;
                }
            }
            if (lexerState.peek() == 39 && lexerState.peek(1) == 39) {
                lexerState.lexeme = lexerState.lexeme + "'";
                lexerState.forward(2);
            }
            if (lexerState.peek() == 39) {
                if (lexerState.lexeme.length() > 0) {
                    lexerState.tokenize(Token.TokenType.SINGLE_QUOTE_CHAR);
                    return this;
                }
                IndentUtils.handleMappingValueIndent(lexerState, Token.TokenType.SINGLE_QUOTE_DELIMITER);
                return this;
            }
            Scanner.iterate(lexerState, Scanner.SINGLE_QUOTE_CHAR_SCANNER, Token.TokenType.SINGLE_QUOTE_CHAR);
            return this;
        }
    }

    private static class BlockHeaderState
    implements State {
        private BlockHeaderState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            boolean hasWhiteSpace = false;
            if (lexerState.peek() == 32) {
                hasWhiteSpace = true;
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
            }
            if (lexerState.peek() == 35 && hasWhiteSpace) {
                Scanner.iterate(lexerState, Scanner.COMMENT_SCANNER, Token.TokenType.EOL);
                return this;
            }
            if (Utils.matchPattern(lexerState, List.of(Utils.DECIMAL_PATTERN), List.of(new Utils.CharPattern('0')))) {
                lexerState.captureIndent = false;
                int numericValue = Character.getNumericValue(lexerState.peek());
                lexerState.addIndent += numericValue;
                lexerState.forward();
                return this.transition(lexerState);
            }
            if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EOL)) {
                return this;
            }
            if (Utils.checkCharacters(lexerState, List.of(Character.valueOf('+'), Character.valueOf('-')))) {
                lexerState.lexeme = lexerState.lexeme + Character.toString(lexerState.peek());
                lexerState.forward();
                lexerState.tokenize(Token.TokenType.CHOMPING_INDICATOR);
                return this;
            }
            throw new Error.YamlParserException("invalid block header", lexerState.getLine(), lexerState.getColumn());
        }
    }

    private static class BlockScalarState
    implements State {
        private BlockScalarState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            boolean hasSufficientIndent = true;
            int limit = lexerState.indent + lexerState.addIndent;
            for (int i = 0; i < limit; ++i) {
                if (lexerState.peek() != 32) {
                    hasSufficientIndent = false;
                    break;
                }
                lexerState.forward();
            }
            if (!hasSufficientIndent) {
                if (Utils.isPlainSafe(lexerState)) {
                    lexerState.enforceMapping = true;
                    return LEXER_START_STATE.transition(lexerState);
                }
                if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                    return this;
                }
                switch (lexerState.peek()) {
                    case 35: {
                        if (!lexerState.trailingComment && lexerState.captureIndent) {
                            throw new Error.YamlParserException("Block scalars with more-indented leading empty linesmust use an explicit indentation indicator", lexerState.getLine(), lexerState.getColumn());
                        }
                        if (lexerState.trailingComment) {
                            lexerState.tokenize(Token.TokenType.EOL);
                        } else {
                            Scanner.iterate(lexerState, Scanner.COMMENT_SCANNER, Token.TokenType.TRAILING_COMMENT);
                        }
                        return this;
                    }
                    case 34: 
                    case 39: 
                    case 46: {
                        lexerState.enforceMapping = true;
                        return LEXER_START_STATE.transition(lexerState);
                    }
                    case 45: 
                    case 58: {
                        return LEXER_START_STATE.transition(lexerState);
                    }
                }
                throw new Error.YamlParserException("insufficient indent to process literal characters", lexerState.getLine(), lexerState.getColumn());
            }
            if (lexerState.trailingComment) {
                block10: while (true) {
                    if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                        return this;
                    }
                    switch (lexerState.peek()) {
                        case 32: {
                            lexerState.forward();
                            continue block10;
                        }
                        case 35: {
                            lexerState.tokenize(Token.TokenType.EOL);
                            return this;
                        }
                    }
                    break;
                }
                throw new Error.YamlParserException("invalid trailing comment", lexerState.getLine(), lexerState.getColumn());
            }
            if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                return this;
            }
            if (lexerState.captureIndent) {
                int additionalIndent = 0;
                while (lexerState.peek() == 32) {
                    ++additionalIndent;
                    lexerState.forward();
                }
                lexerState.addIndent += additionalIndent;
                if (lexerState.getColumn() < lexerState.getRemainingBufferedSize()) {
                    lexerState.captureIndent = false;
                }
            }
            if (Scanner.scanAndTokenizeEOL(lexerState, Token.TokenType.EMPTY_LINE)) {
                return this;
            }
            if (lexerState.peek() == 46 && lexerState.peek(1) == 46 && lexerState.peek(2) == 46 || lexerState.peek() == 45 && lexerState.peek(1) == 45 && lexerState.peek(2) == 45) {
                return LEXER_START_STATE.transition(lexerState);
            }
            Scanner.iterate(lexerState, Scanner.PRINTABLE_CHAR_WITH_WHITESPACE_SCANNER, Token.TokenType.PRINTABLE_CHAR);
            return this;
        }
    }

    private static class ReservedDirectiveState
    implements State {
        private ReservedDirectiveState() {
        }

        @Override
        public State transition(LexerState lexerState) throws Error.YamlParserException {
            if (Utils.isComment(lexerState)) {
                lexerState.tokenize(Token.TokenType.EOL);
                return this;
            }
            if (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek())) {
                Scanner.iterate(lexerState, Scanner.WHITE_SPACE_SCANNER, Token.TokenType.SEPARATION_IN_LINE);
                return this;
            }
            Scanner.iterate(lexerState, Scanner.PRINTABLE_CHAR_SCANNER, Token.TokenType.PRINTABLE_CHAR);
            return this;
        }
    }
}

