/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.lexer.Utils;
import io.ballerina.lib.data.yaml.utils.Error;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;

public class Scanner {
    public static final Scan ANCHOR_NAME_SCANNER = new AnchorNameScanner();
    public static final Scan PLANAR_CHAR_SCANNER = new PlanarCharScanner();
    public static final Scan URI_SCANNER = new UriScanner(false);
    public static final Scan VERBATIM_URI_SCANNER = new UriScanner(true);
    public static final Scan PRINTABLE_CHAR_WITH_WHITESPACE_SCANNER = new PrintableCharScanner(true);
    public static final Scan PRINTABLE_CHAR_SCANNER = new PrintableCharScanner(false);
    public static final Scan DIFF_TAG_HANDLE_SCANNER = new TagHandleScanner(true);
    public static final Scan TAG_HANDLE_SCANNER = new TagHandleScanner(false);
    public static final Scan WHITE_SPACE_SCANNER = new WhiteSpaceScanner();
    public static final Scan TAG_CHARACTER_SCANNER = new TagCharacterScanner();
    public static final Scan DIGIT_SCANNER = new DigitScanner();
    public static final Scan DOUBLE_QUOTE_CHAR_SCANNER = new DoubleQuoteCharScanner();
    public static final Scan SINGLE_QUOTE_CHAR_SCANNER = new SingleQuoteCharScanner();
    public static final Scan COMMENT_SCANNER = new CommentScanner();
    public static final Map<Character, String> ESCAPED_CHAR_MAP = new HashMap<Character, String>();

    private Scanner() {
    }

    public static void iterate(LexerState sm, Scan scan, Token.TokenType token) throws Error.YamlParserException {
        Scanner.iterate(sm, scan, token, false);
    }

    public static void iterate(LexerState sm, Scan scan, Token.TokenType token, boolean include) throws Error.YamlParserException {
        while (true) {
            if (scan.scan(sm)) {
                if (include && sm.peek() != 10) {
                    sm.forward();
                    sm.tokenize(token);
                    return;
                }
                if (include && sm.peek() != 13 && sm.peek(1) != 10) {
                    sm.forward(2);
                    sm.tokenize(token);
                    return;
                }
                sm.tokenize(token);
                return;
            }
            if (sm.peek(1) == -1) break;
            sm.forward();
        }
        sm.setEofStream(true);
        sm.forward();
        sm.tokenize(token);
    }

    private static void scanUnicodeEscapedCharacters(LexerState sm, char escapedChar, int length) throws Error.YamlParserException {
        StringBuilder unicodeDigits = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sm.forward();
            int peek = sm.peek();
            if (!Utils.HEXA_DECIMAL_PATTERN.pattern(peek)) {
                throw new Error.YamlParserException("expected a unicode character after escaped char", sm.getLine(), sm.getColumn());
            }
            unicodeDigits.append(Character.toString(peek));
        }
        int hexResult = HexFormat.fromHexDigits(unicodeDigits.toString());
        sm.appendToLexeme(Character.toString(hexResult));
    }

    private static void escapedCharacterScan(LexerState sm) throws Error.YamlParserException {
        int currentChar = sm.peek();
        if (Utils.LINE_BREAK_PATTERN.pattern(currentChar)) {
            sm.forward();
            Scanner.processEscapedWhiteSpaces(sm);
            return;
        }
        if (currentChar == -1) {
            sm.appendToLexeme("\\");
            return;
        }
        if (ESCAPED_CHAR_MAP.containsKey(Character.valueOf((char)currentChar))) {
            sm.appendToLexeme(ESCAPED_CHAR_MAP.get(Character.valueOf((char)currentChar)));
            return;
        }
        switch (currentChar) {
            case 120: {
                Scanner.scanUnicodeEscapedCharacters(sm, 'x', 2);
                return;
            }
            case 117: {
                Scanner.scanUnicodeEscapedCharacters(sm, 'u', 4);
                return;
            }
            case 85: {
                Scanner.scanUnicodeEscapedCharacters(sm, 'U', 8);
                return;
            }
        }
        throw new Error.YamlParserException("invalid escape character", sm.getLine(), sm.getColumn());
    }

    private static void processEscapedWhiteSpaces(LexerState sm) {
        while (Utils.WHITE_SPACE_PATTERN.pattern(sm.peek(1))) {
            sm.forward();
        }
    }

    public static boolean scanAndTokenizeEOL(LexerState state, Token.TokenType token) {
        if (state.peek() == 10 || state.peek() == -1) {
            state.forward();
            state.tokenize(token);
            return true;
        }
        if (state.peek() == 13 && state.peek(1) == 10) {
            state.forward(2);
            state.tokenize(token);
            return true;
        }
        return false;
    }

    static {
        ESCAPED_CHAR_MAP.put(Character.valueOf('0'), "\u0000");
        ESCAPED_CHAR_MAP.put(Character.valueOf('a'), "\u0007");
        ESCAPED_CHAR_MAP.put(Character.valueOf('b'), "\b");
        ESCAPED_CHAR_MAP.put(Character.valueOf('t'), "\t");
        ESCAPED_CHAR_MAP.put(Character.valueOf('n'), "\n");
        ESCAPED_CHAR_MAP.put(Character.valueOf('v'), "\u000b");
        ESCAPED_CHAR_MAP.put(Character.valueOf('f'), "\f");
        ESCAPED_CHAR_MAP.put(Character.valueOf('r'), "\r");
        ESCAPED_CHAR_MAP.put(Character.valueOf('e'), "\u001b");
        ESCAPED_CHAR_MAP.put(Character.valueOf('\"'), "\"");
        ESCAPED_CHAR_MAP.put(Character.valueOf('/'), "/");
        ESCAPED_CHAR_MAP.put(Character.valueOf('\\'), "\\\\");
        ESCAPED_CHAR_MAP.put(Character.valueOf('N'), "\u0085");
        ESCAPED_CHAR_MAP.put(Character.valueOf('_'), "\u00a0");
        ESCAPED_CHAR_MAP.put(Character.valueOf('L'), "\u2028");
        ESCAPED_CHAR_MAP.put(Character.valueOf('P'), "\u2029");
        ESCAPED_CHAR_MAP.put(Character.valueOf(' '), " ");
        ESCAPED_CHAR_MAP.put(Character.valueOf('\t'), "\t");
    }

    static interface Scan {
        public boolean scan(LexerState var1) throws Error.YamlParserException;
    }

    public static class AnchorNameScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) {
            if (Utils.matchPattern(sm, List.of(Utils.PRINTABLE_PATTERN), List.of(Utils.LINE_BREAK_PATTERN, Utils.BOM_PATTERN, Utils.FLOW_INDICATOR_PATTERN, Utils.WHITE_SPACE_PATTERN))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            return true;
        }
    }

    public static class PlanarCharScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            StringBuilder whitespace = new StringBuilder();
            int numWhitespace = 0;
            int peekAtIndex = sm.peek();
            while (Utils.WHITE_SPACE_PATTERN.pattern(peekAtIndex)) {
                whitespace.append(" ");
                peekAtIndex = sm.peek(++numWhitespace);
            }
            if (peekAtIndex == -1 || Utils.LINE_BREAK_PATTERN.pattern(peekAtIndex)) {
                return true;
            }
            if (Utils.matchPattern(sm, List.of(Utils.FLOW_INDICATOR_PATTERN), numWhitespace) && sm.isFlowCollection()) {
                sm.forward(numWhitespace);
                return true;
            }
            if (Utils.matchPattern(sm, List.of(Utils.PRINTABLE_PATTERN), List.of(Utils.LINE_BREAK_PATTERN, Utils.BOM_PATTERN, Utils.WHITE_SPACE_PATTERN, new Utils.CharPattern('#'), new Utils.CharPattern(':')), numWhitespace)) {
                sm.forward(numWhitespace);
                sm.appendToLexeme(String.valueOf(whitespace) + Character.toString(peekAtIndex));
                return false;
            }
            if (peekAtIndex == 35) {
                if (numWhitespace > 0) {
                    return true;
                }
                sm.appendToLexeme("#");
                return false;
            }
            if (peekAtIndex == 58) {
                if (!Utils.discernPlanarFromIndicator(sm, numWhitespace + 1)) {
                    return true;
                }
                sm.forward(numWhitespace);
                sm.appendToLexeme(String.valueOf(whitespace) + ":");
                return false;
            }
            throw new Error.YamlParserException("invalid planar character", sm.getLine(), sm.getColumn());
        }
    }

    public static class UriScanner
    implements Scan {
        private final boolean isVerbatim;

        public UriScanner(boolean isVerbatim) {
            this.isVerbatim = isVerbatim;
        }

        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            int currentChar = sm.peek();
            if (Utils.matchPattern(sm, List.of(Utils.URI_PATTERN, Utils.WORD_PATTERN))) {
                sm.appendToLexeme(Character.toString(currentChar));
                return false;
            }
            if (currentChar == 37) {
                Scanner.scanUnicodeEscapedCharacters(sm, '%', 2);
                return false;
            }
            if (Utils.matchPattern(sm, List.of(Utils.LINE_BREAK_PATTERN, Utils.WHITE_SPACE_PATTERN))) {
                return true;
            }
            if (this.isVerbatim && currentChar == 62) {
                return true;
            }
            throw new Error.YamlParserException("invalid URI character", sm.getLine(), sm.getColumn());
        }
    }

    public static class PrintableCharScanner
    implements Scan {
        private final boolean allowWhiteSpace;

        public PrintableCharScanner(boolean allowWhiteSpace) {
            this.allowWhiteSpace = allowWhiteSpace;
        }

        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (this.allowWhiteSpace ? Utils.matchPattern(sm, List.of(Utils.LINE_BREAK_PATTERN)) : Utils.matchPattern(sm, List.of(Utils.WHITE_SPACE_PATTERN, Utils.LINE_BREAK_PATTERN))) {
                return true;
            }
            if (Utils.matchPattern(sm, List.of(Utils.PRINTABLE_PATTERN), List.of(Utils.BOM_PATTERN, Utils.LINE_BREAK_PATTERN))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            throw new Error.YamlParserException("invalid printable character", sm.getLine(), sm.getColumn());
        }
    }

    public static class TagHandleScanner
    implements Scan {
        private final boolean differentiate;

        public TagHandleScanner(boolean differentiate) {
            this.differentiate = differentiate;
        }

        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (Utils.matchPattern(sm, List.of(Utils.WORD_PATTERN, Utils.URI_PATTERN), List.of(new Utils.CharPattern('!'), Utils.FLOW_INDICATOR_PATTERN), 0)) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                if (this.differentiate && sm.peek(1) == -1) {
                    sm.setLexemeBuffer(sm.getLexeme().substring(1));
                    sm.setLexeme("!");
                    return true;
                }
                if (this.differentiate && Utils.matchPattern(sm, List.of(Utils.FLOW_INDICATOR_PATTERN, Utils.WHITE_SPACE_PATTERN), 1)) {
                    sm.setLexemeBuffer(sm.getLexeme().substring(1));
                    sm.setLexeme("!");
                    return true;
                }
                return false;
            }
            if (sm.peek() == 33) {
                sm.appendToLexeme("!");
                return true;
            }
            if (this.differentiate && sm.peek() == 37) {
                Scanner.scanUnicodeEscapedCharacters(sm, '%', 2);
                sm.setLexemeBuffer(sm.getLexeme().substring(1));
                sm.setLexeme("!");
                return true;
            }
            throw new Error.YamlParserException("invalid tag handle runtime exception", sm.getLine(), sm.getColumn());
        }
    }

    public static class WhiteSpaceScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) {
            int peek = sm.peek();
            if (peek == 32) {
                return false;
            }
            if (peek == 9) {
                sm.updateFirstTabIndex();
                return false;
            }
            return true;
        }
    }

    public static class TagCharacterScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (Utils.matchPattern(sm, List.of(Utils.URI_PATTERN, Utils.WORD_PATTERN), List.of(Utils.FLOW_INDICATOR_PATTERN, new Utils.CharPattern('!')))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            if (Utils.matchPattern(sm, List.of(Utils.WHITE_SPACE_PATTERN, Utils.FLOW_INDICATOR_PATTERN, Utils.LINE_BREAK_PATTERN))) {
                return true;
            }
            if (sm.peek() == 37) {
                Scanner.scanUnicodeEscapedCharacters(sm, '%', 2);
                return false;
            }
            throw new Error.YamlParserException("invalid tag character", sm.getLine(), sm.getColumn());
        }
    }

    public static class DigitScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (Utils.matchPattern(sm, List.of(Utils.DECIMAL_PATTERN))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            int currentChar = sm.peek();
            if (Utils.WHITE_SPACE_PATTERN.pattern(currentChar) || currentChar == 46 || Utils.LINE_BREAK_PATTERN.pattern(currentChar)) {
                return true;
            }
            throw new Error.YamlParserException("invalid digit character", sm.getLine(), sm.getColumn());
        }
    }

    public static class DoubleQuoteCharScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (Utils.matchPattern(sm, List.of(Utils.JSON_PATTERN), List.of(new Utils.CharPattern('\\'), new Utils.CharPattern('\"')))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            if (sm.peek() == 92) {
                sm.forward();
                Scanner.escapedCharacterScan(sm);
                sm.setLastEscapedChar(sm.getLexeme().length() - 1);
                return false;
            }
            if (sm.peek() == 34) {
                return true;
            }
            if (Utils.isNewLine(sm)) {
                return true;
            }
            throw new Error.YamlParserException("invalid character", sm.getLine(), sm.getColumn());
        }
    }

    public static class SingleQuoteCharScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) throws Error.YamlParserException {
            if (Utils.matchPattern(sm, List.of(Utils.JSON_PATTERN), List.of(new Utils.CharPattern('\'')))) {
                sm.appendToLexeme(Character.toString(sm.peek()));
                return false;
            }
            if (sm.peek() == 39) {
                if (sm.peek(1) == 39) {
                    sm.appendToLexeme("'");
                    sm.forward();
                    return false;
                }
                return true;
            }
            if (Utils.isNewLine(sm)) {
                return true;
            }
            throw new Error.YamlParserException("invalid character", sm.getLine(), sm.getColumn());
        }
    }

    public static class CommentScanner
    implements Scan {
        @Override
        public boolean scan(LexerState sm) {
            return !Utils.matchPattern(sm, List.of(Utils.PRINTABLE_PATTERN), List.of(Utils.LINE_BREAK_PATTERN));
        }
    }
}

