/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Scanner;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.lexer.Utils;
import io.ballerina.lib.data.yaml.utils.Error;

public class YamlLexer {
    private YamlLexer() {
    }

    public static LexerState.State scanTokens(LexerState state) throws Error.YamlParserException {
        if (state.getLexemeBuffer().length() > 0) {
            state.setLexeme(state.getLexemeBuffer());
            state.setLexemeBuffer("");
            if (Utils.isTagChar(state)) {
                Scanner.iterate(state, Scanner.TAG_CHARACTER_SCANNER, Token.TokenType.TAG);
                return state.getState();
            }
            state.tokenize(Token.TokenType.TAG);
            return state.getState();
        }
        if (state.isEndOfStream()) {
            if (state.isIndentationBreak()) {
                throw new Error.YamlParserException("invalid indentation", state.getLine(), state.getColumn());
            }
            if (state.getColumn() == 0) {
                state.forward();
                state.tokenize(Token.TokenType.EMPTY_LINE);
            } else {
                state.forward();
                state.tokenize(Token.TokenType.EOL);
            }
            return state.getState();
        }
        if (state.peek() == 10 && state.getState() != LexerState.LEXER_DOUBLE_QUOTE) {
            state.forward();
            state.tokenize(Token.TokenType.EOL);
            return state.getState();
        }
        if (state.peek() == 13 && state.peek(1) == 10 && state.getState() != LexerState.LEXER_DOUBLE_QUOTE) {
            state.forward();
            state.tokenize(Token.TokenType.EOL);
            return state.getState();
        }
        return state.getState().transition(state);
    }
}

