/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.parser;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.common.YamlEvent;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.HashMap;
import java.util.Map;

public class ParserUtils {
    public static final String FIELD = "$field$.";
    public static final String FIELD_REGEX = "\\$field\\$\\.";
    public static final String NAME = "Name";
    public static final BString VALUE = StringUtils.fromString((String)"value");

    private ParserUtils() {
    }

    public static Map<String, Field> getAllFieldsInRecord(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        HashMap<String, String> modifiedNames = new HashMap<String, String>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains(FIELD)) continue;
            String fieldName = keyStr.split(FIELD_REGEX)[1];
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            modifiedNames.put(fieldName, ParserUtils.getModifiedName(fieldAnnotation, fieldName));
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Map recordFields = recordType.getFields();
        for (String key : recordFields.keySet()) {
            String fieldName = modifiedNames.getOrDefault(key, key);
            fields.put(fieldName, (Field)recordFields.get(key));
        }
        return fields;
    }

    public static String getModifiedName(Map<BString, Object> fieldAnnotation, String fieldName) {
        for (BString key : fieldAnnotation.keySet()) {
            if (!key.getValue().endsWith(NAME)) continue;
            return ((Map)fieldAnnotation.get(key)).get(VALUE).toString();
        }
        return fieldName;
    }

    public static boolean isStreamEndEvent(YamlEvent event) {
        return event.getKind() == YamlEvent.EventKind.END_EVENT && ((YamlEvent.EndEvent)event).getEndType() == Types.Collection.STREAM;
    }

    public static enum ParserOption {
        DEFAULT,
        EXPECT_MAP_KEY,
        EXPECT_MAP_VALUE,
        EXPECT_SEQUENCE_ENTRY,
        EXPECT_SEQUENCE_VALUE;

    }
}

