/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.utils;

import io.ballerina.lib.data.yaml.parser.YamlParser;
import io.ballerina.lib.data.yaml.utils.Error;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagResolutionUtils {
    private static final String DOT = ".";
    private static final String PLUS = "+";
    private static final String POSITIVE_FLOAT = "+.";
    private static final String NEGATIVE_FLOAT = "-.";
    private static final String SIMPLE_NULL = "null";
    private static final String SIMPLE_FALSE = "false";
    private static final String SIMPLE_TRUE = "true";
    private static final String OCTAL_START = "0o";
    private static final String HEXA_START = "0x";
    private static final Pattern SIMPLE_INT_PATTERN = Pattern.compile("-?(\\d+)");
    private static final Pattern COMPLEX_INT_PATTERN = Pattern.compile("[+-]?(\\d+)");
    private static final Pattern SIMPLE_FLOAT_PATTERN = Pattern.compile("-?(0|\\d+)(\\.\\d*)?([eE][-+]?\\d+)?");
    private static final Pattern COMPLEX_FLOAT_PATTERN = Pattern.compile("[-+]?(\\.\\d+|\\d+(\\.\\d*)?)([eE][-+]?\\d+)?");
    private static final Set<String> CORE_SCHEMA_INF = Set.of("inf", "Inf", "INF");
    private static final Set<String> CORE_SCHEMA_NAN = Set.of("nan", "NaN", "NAN");
    private static final Set<String> CORE_SCHEMA_NULL = Set.of("null", "Null", "NULL", "~");
    private static final Set<String> CORE_SCHEMA_TRUE = Set.of("true", "True", "TRUE");
    private static final Set<String> CORE_SCHEMA_FALSE = Set.of("false", "False", "FALSE");

    private TagResolutionUtils() {
    }

    public static Object constructSimpleNull(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        if (value.equals(SIMPLE_NULL)) {
            return null;
        }
        throw new Error.YamlParserException("cannot cast " + value + " to null", state.getLine(), state.getColumn());
    }

    public static Object constructNull(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        if (TagResolutionUtils.isCoreSchemaNull(value)) {
            return null;
        }
        throw new Error.YamlParserException("cannot cast " + value + " to null", state.getLine(), state.getColumn());
    }

    public static Object constructSimpleBool(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        if (value.equals(SIMPLE_TRUE)) {
            return true;
        }
        if (value.equals(SIMPLE_FALSE)) {
            return false;
        }
        throw new Error.YamlParserException("cannot cast " + value + " to boolean", state.getLine(), state.getColumn());
    }

    public static Object constructBool(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        if (TagResolutionUtils.isCoreSchemaTrue(value)) {
            return true;
        }
        if (TagResolutionUtils.isCoreSchemaFalse(value)) {
            return false;
        }
        throw new Error.YamlParserException("cannot cast " + value + " to boolean", state.getLine(), state.getColumn());
    }

    public static Object constructSimpleInt(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        Matcher matcher = SIMPLE_INT_PATTERN.matcher(value);
        if (matcher.find()) {
            return Long.valueOf(value);
        }
        throw new Error.YamlParserException("cannot cast " + value + " to int", state.getLine(), state.getColumn());
    }

    public static Object constructInt(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        Matcher matcher;
        if (value.length() > 1) {
            if (value.startsWith(OCTAL_START)) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith(HEXA_START)) {
                return Long.parseLong(value.substring(2), 16);
            }
        }
        if ((matcher = COMPLEX_INT_PATTERN.matcher(value)).find()) {
            return Long.valueOf(value);
        }
        throw new Error.YamlParserException("cannot cast " + value + " to int", state.getLine(), state.getColumn());
    }

    public static Object constructSimpleFloat(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        Matcher matcher = SIMPLE_FLOAT_PATTERN.matcher(value);
        if (matcher.find()) {
            return Double.parseDouble(value);
        }
        throw new Error.YamlParserException("cannot cast " + value + " to float", state.getLine(), state.getColumn());
    }

    public static Object constructFloat(String value, YamlParser.ComposerState state) throws Error.YamlParserException {
        Matcher matcher;
        if (value.length() > 1) {
            boolean isInfinity;
            String valueSuffix;
            if (value.startsWith(DOT)) {
                valueSuffix = value.substring(1);
                if (TagResolutionUtils.isCoreSchemaNaN(valueSuffix)) {
                    return Double.NaN;
                }
                if (TagResolutionUtils.isCoreSchemaInf(valueSuffix)) {
                    return Double.POSITIVE_INFINITY;
                }
            } else if ((value.startsWith(POSITIVE_FLOAT) || value.startsWith(NEGATIVE_FLOAT)) && (isInfinity = TagResolutionUtils.isCoreSchemaInf(valueSuffix = value.substring(2)))) {
                return value.startsWith(PLUS) ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        if ((matcher = COMPLEX_FLOAT_PATTERN.matcher(value)).find()) {
            return Double.parseDouble(value);
        }
        throw new Error.YamlParserException("cannot cast " + value + " to float", state.getLine(), state.getColumn());
    }

    private static boolean isCoreSchemaInf(String valueSuffix) {
        return CORE_SCHEMA_INF.contains(valueSuffix);
    }

    private static boolean isCoreSchemaNaN(String valueSuffix) {
        return CORE_SCHEMA_NAN.contains(valueSuffix);
    }

    public static boolean isCoreSchemaNull(String value) {
        return CORE_SCHEMA_NULL.contains(value);
    }

    public static boolean isCoreSchemaBoolean(String value) {
        return TagResolutionUtils.isCoreSchemaTrue(value) || TagResolutionUtils.isCoreSchemaFalse(value);
    }

    private static boolean isCoreSchemaTrue(String value) {
        return CORE_SCHEMA_TRUE.contains(value);
    }

    private static boolean isCoreSchemaFalse(String value) {
        return CORE_SCHEMA_FALSE.contains(value);
    }
}

