/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.linter.impl.codeactions;

import io.ballerina.compiler.linter.impl.codeactions.LinterCodeAction;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Optional;

public class CheckUsageCodeAction
extends LinterCodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of("BCE20404");
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        NonTerminalNode expr = CheckUsageCodeAction.getNodeFromDiagnostics(context);
        NonTerminalNode node = expr.parent();
        SyntaxKind syntaxKind = node.kind();
        if (syntaxKind != SyntaxKind.CHECK_ACTION && syntaxKind != SyntaxKind.CHECK_EXPRESSION) {
            return Optional.empty();
        }
        CheckExpressionNode checkExpressionNode = (CheckExpressionNode)node;
        String checkingKeyword = checkExpressionNode.checkKeyword().text();
        String updatedText = expr.toSourceCode();
        List<CodeActionArgument> args = List.of(CodeActionArgument.from((String)"lineRange", (Object)node.lineRange()), CodeActionArgument.from((String)"value", (Object)updatedText.strip()));
        return Optional.of(CodeActionInfo.from((String)String.format("Remove '%s' keyword", checkingKeyword), args));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        LineRange lineRange = (LineRange)((CodeActionArgument)context.arguments().get(0)).valueAs(LineRange.class);
        String updatedText = (String)((CodeActionArgument)context.arguments().get(1)).valueAs(String.class);
        DocumentEdit documentEdit = CheckUsageCodeAction.getDocumentEdit(context, lineRange, updatedText);
        return List.of(documentEdit);
    }

    public String name() {
        return "check-usage-code-action";
    }
}

