/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.linter.impl.codeactions;

import io.ballerina.compiler.linter.impl.codeactions.LinterCodeAction;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Optional;

public class FloatingPointLiteralCodeAction
extends LinterCodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of("BCE0410", "BCE0416");
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        NonTerminalNode node = FloatingPointLiteralCodeAction.getNodeFromDiagnostics(context);
        SyntaxKind kind = node.kind();
        if (kind != SyntaxKind.NUMERIC_LITERAL) {
            return Optional.empty();
        }
        BasicLiteralNode literalNode = (BasicLiteralNode)node;
        String text = literalNode.literalToken().text();
        String newLiteral = text.replace(".", ".0");
        List<CodeActionArgument> args = List.of(CodeActionArgument.from((String)"lineRange", (Object)node.lineRange()), CodeActionArgument.from((String)"value", (Object)newLiteral));
        return Optional.of(CodeActionInfo.from((String)String.format("Replace with '%s'", newLiteral), args));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        LineRange lineRange = (LineRange)((CodeActionArgument)context.arguments().get(0)).valueAs(LineRange.class);
        String updatedText = (String)((CodeActionArgument)context.arguments().get(1)).valueAs(String.class);
        DocumentEdit documentEdit = FloatingPointLiteralCodeAction.getDocumentEdit(context, lineRange, updatedText);
        return List.of(documentEdit);
    }

    public String name() {
        return "floating-point-code-action";
    }
}

