/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.linter.impl.codeactions;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.linter.impl.codeactions.LinterCodeAction;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLQualifiedNameNode;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Optional;

public class QualifiedIdentifierCodeAction
extends LinterCodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of("BCE0651", "BCE0676");
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        String updatedText;
        NonTerminalNode node = QualifiedIdentifierCodeAction.getNodeFromDiagnostics(context);
        SyntaxKind kind = node.kind();
        if (kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRefNode = (QualifiedNameReferenceNode)node;
            if (qNameRefNode.identifier().isMissing() || context.cursorPosition().isEmpty()) {
                return Optional.empty();
            }
            boolean validQName = context.currentSemanticModel().visibleSymbols(context.currentDocument(), (LinePosition)context.cursorPosition().get()).stream().filter(symbol -> symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).filter(moduleSymbol -> qNameRefNode.modulePrefix().text().equals(moduleSymbol.id().modulePrefix())).anyMatch(moduleSymbol -> moduleSymbol.allSymbols().stream().filter(symbol -> symbol.getName().isPresent()).anyMatch(symbol -> ((String)symbol.getName().get()).equals(qNameRefNode.identifier().text())));
            if (!validQName) {
                return Optional.empty();
            }
            updatedText = qNameRefNode.modulePrefix().text() + qNameRefNode.colon().toSourceCode().strip() + qNameRefNode.identifier().toSourceCode().strip();
        } else if (kind == SyntaxKind.XML_QUALIFIED_NAME) {
            XMLQualifiedNameNode xmlQualifiedNameNode = (XMLQualifiedNameNode)node;
            updatedText = xmlQualifiedNameNode.prefix().name().text() + xmlQualifiedNameNode.colon().toSourceCode().strip() + xmlQualifiedNameNode.name().toSourceCode().strip();
        } else {
            return Optional.empty();
        }
        List<CodeActionArgument> args = List.of(CodeActionArgument.from((String)"lineRange", (Object)node.lineRange()), CodeActionArgument.from((String)"value", (Object)updatedText));
        return Optional.of(CodeActionInfo.from((String)String.format("Replace with '%s'", updatedText), args));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        LineRange lineRange = (LineRange)((CodeActionArgument)context.arguments().get(0)).valueAs(LineRange.class);
        String updatedText = (String)((CodeActionArgument)context.arguments().get(1)).valueAs(String.class);
        DocumentEdit documentEdit = QualifiedIdentifierCodeAction.getDocumentEdit(context, lineRange, updatedText);
        return List.of(documentEdit);
    }

    public String name() {
        return "qualified-identifier-code-action";
    }
}

